<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center position-relative mb-4 flex-wrap gap-4">

    <div class="d-flex align-items-start flex-wrap gap-2">
        <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.service.all')); ?>" aria-current="page" href="<?php echo e(route('influencer.service.all')); ?>"><?php echo app('translator')->get('All'); ?></a>
        <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.service.pending')); ?>" href="<?php echo e(route('influencer.service.pending')); ?>"><?php echo app('translator')->get('Pending'); ?></a>
        <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.service.approved')); ?>" href="<?php echo e(route('influencer.service.approved')); ?>"><?php echo app('translator')->get('Approved'); ?></a>
        <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.service.rejected')); ?>" href="<?php echo e(route('influencer.service.rejected')); ?>"><?php echo app('translator')->get('Rejected'); ?></a>
    </div>
    <form action="" class="service-search-form flex-fill">
        <div class="input-group">
            <input type="text" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Title / Category'); ?>">
            <button class="input-group-text bg--base border-0 px-4 text-white"><i class="las la-search"></i></button>
        </div>
    </form>
</div>

<div class="row">
    <div class="col-lg-12">
        <table class="table--responsive--lg table">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Title'); ?></th>
                    <th><?php echo app('translator')->get('Category | Price'); ?></th>
                    <th><?php echo app('translator')->get('Order'); ?></th>
                    <?php if(request()->routeIs('influencer.service.all')): ?>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <?php endif; ?>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td data-label="<?php echo app('translator')->get('Title'); ?>">
                        <?php echo e(strLimit($service->title, 60)); ?>

                    </td>

                    <td data-label="<?php echo app('translator')->get('Category | Price'); ?>">
                        <div>
                            <span><?php echo e(__(@$service->category->name)); ?></span><br>
                            <span class="fw-bold"><?php echo e($general->cur_sym); ?><?php echo e(showAmount(@$service->price)); ?></span>
                        </div>
                    </td>

                    <td data-label="<?php echo app('translator')->get('Order'); ?>">
                        <div>
                            <span> <?php echo app('translator')->get('Total'); ?> : <?php echo e(getAmount($service->total_order_count)); ?></span><br>
                            <span> <?php echo app('translator')->get('Done'); ?> : <?php echo e(getAmount($service->complete_order_count)); ?></span><br>
                        </div>
                    </td>
                    <?php if(request()->routeIs('influencer.service.all')): ?>
                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                        <div class="">
                            <?php echo $service->statusBadge ?>
                            <?php if($service->status == 2): ?>
                            <button type="button" class="btn btn--sm btn--outline-warning detailBtn" data-admin_feedback="<?php echo e($service->admin_feedback); ?>"><i class="la la-info"></i></button>
                            <?php endif; ?>
                        </div>
                    </td>
                    <?php endif; ?>
                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                        <div class="d-flex flex-wrap gap-2 justify-content-end">
                            <a href="<?php echo e(route('influencer.service.edit', $service->id)); ?>" class="btn btn--sm btn--outline-base <?php if($service->status == 2): ?> disabled <?php endif; ?>">
                                <i class="la la-edit"></i> <?php echo app('translator')->get('Edit'); ?>
                            </a>

                            <a href="<?php echo e(route('influencer.service.orders', $service->id)); ?>" class="btn btn--sm btn--outline-info <?php if($service->status != 1): ?> disabled <?php endif; ?>">
                                <i class="las la-list-ul"></i> <?php echo app('translator')->get('Orders'); ?>
                            </a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td class="justify-content-center text-center" colspan="100%">
                        <i class="la la-4x la-frown"></i>
                        <br>
                        <?php echo e(__($emptyMessage)); ?>

                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <?php echo e($services->links()); ?>

    </div>
</div>
<div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Reason of Rejection'); ?></h5>
                <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <p class="modal-detail"></p>
            </div>
        </div>
    </div>
</div>
<?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ConfirmationModal::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
<style>
    .nav-link {
        color: rgb(var(--base));
    }

    .nav-tabs .nav-link:focus,
    .nav-tabs .nav-link:hover {
        border-color: rgb(var(--base)) rgb(var(--base)) rgb(var(--base));
        color: rgb(var(--base));
        isolation: isolate;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                modal.find('.modal-detail').text($(this).data('admin_feedback'));
                modal.modal('show');
            });

        })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/infu.nibiru-it.ro/public_html/core/resources/views/templates/basic/influencer/service/list.blade.php ENDPATH**/ ?>