<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card custom--card">
                <div class="card-body p-sm-4">
                    <form action="" method="post" class="row gy-3">
                        <?php echo csrf_field(); ?>
                        <div class="form-group col-md-12">
                            <label for="current_password" class="form-label"><?php echo app('translator')->get('Current Password'); ?></label>
                            <input class="form-control form--control bg--body" name="current_password" id="current_password"
                                   type="password" placeholder="<?php echo app('translator')->get('Enter Current Password'); ?>" required>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="new_password" class="form-label"><?php echo app('translator')->get('New Password'); ?></label>
                            <input class="form-control form--control bg--body" name="password" id="new_password"
                                   type="password" placeholder="<?php echo app('translator')->get('Enter New Password'); ?>" required autocomplete="off">
                            <?php if($general->secure_password): ?>
                                <div class="input-popup">
                                    <p class="error lower"><?php echo app('translator')->get('1 small letter minimum'); ?></p>
                                    <p class="error capital"><?php echo app('translator')->get('1 capital letter minimum'); ?></p>
                                    <p class="error number"><?php echo app('translator')->get('1 number minimum'); ?></p>
                                    <p class="error special"><?php echo app('translator')->get('1 special character minimum'); ?></p>
                                    <p class="error minimum"><?php echo app('translator')->get('6 character password'); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="confirm_password" class="form-label"><?php echo app('translator')->get('Confirm Password'); ?></label>
                            <input class="form-control form--control bg--body" name="password_confirmation"
                                   id="confirm_password" type="password" placeholder="<?php echo app('translator')->get('Enter Confirm Password'); ?>" required>
                        </div>
                        <div class="col-lg-12">
                            <button type="submit" class="btn btn--base w-100 mt-2"><?php echo app('translator')->get('Submit'); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            <?php if($general->secure_password): ?>
                $('input[name=password]').on('input', function() {
                    secure_password($(this));
                });
                $('[name=password]').focus(function() {
                    $(this).closest('.form-group').addClass('hover-input-popup');
                });
                $('[name=password]').focusout(function() {
                    $(this).closest('.form-group').removeClass('hover-input-popup');
                });
            <?php endif; ?>
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/user/password.blade.php ENDPATH**/ ?>