<?php $__env->startSection('content'); ?>
    <section class="pt-80 pb-80">
        <div class="container">
            
            <h3 class="card-title text-center">
               Formular Programare Intalnire <br> <?php echo e(__($service->title)); ?>

            </h3>
            <div class="row d-flex justify-content-center mb-4">
                <div class="col-lg-3 text-center">
                    <a href="<?php echo e(route('influencer.profile', [slug($service->influencer->username), $service->influencer->id])); ?>">
                        <span class="position-relative mr10">
                            <img class="rounded-circle"
                                src="<?php echo e(getImage(getFilePath('influencerProfile') . '/' . @$service->influencer->image, getFileSize('influencerProfile'), true)); ?>"
                                alt="Freelancer Photo"
                                style="width: 40px; height: 40px;">
                            <span class="online-badge"></span>
                        </span>
                        <span
                            class="fz14"><?php echo e(__(@$service->influencer->username)); ?></span>
                    </a>
                </div>
            </div>
            <form action="<?php echo e(route('user.order.confirm', [$influencer->id, $service->id])); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row gy-3">

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label class="form-label"><?php echo app('translator')->get('Request Title'); ?> </label>
                            <input type="text" name="title" class="form-control form--control" value="<?php echo e(old('title')); ?>" required>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="form-group">
                            <label class="form-label"><?php echo app('translator')->get('Estimated Delivery Date'); ?> </label>
                            <input type="text" class="datepicker-here form-control form--control" data-language='en' data-date-format="yyyy-mm-dd" data-position='bottom left' placeholder="<?php echo app('translator')->get('Select Date'); ?>" name="delivery_date" autocomplete="off" required>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="form-group">
                            <label class="form-label"><?php echo app('translator')->get('Influencer'); ?></label>
                            <input type="text" class="form-control form--control" value="<?php echo e(__($influencer->fullname)); ?>" disabled>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="form-group">
                            <label class="form-label"><?php echo app('translator')->get('Service Price'); ?></label>
                            <div class="input-group">
                                <input type="text" step="any" class="form-control form--control" value="<?php echo e(showAmount($service->price)); ?>" disabled>
                                <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="form-group">
                            <label class="form-label"><?php echo app('translator')->get('Payment Type'); ?></label>
                            <select class="form-control form--control form-select" name="payment_type" required>
                                <option value="" disabled selected><?php echo app('translator')->get('Select One'); ?></option>
                                <option value="2"><?php echo app('translator')->get('Direct Payment'); ?></option>
                                <option value="1"><?php echo app('translator')->get('Deposited Wallet'); ?> (<?php echo e(showAmount(auth()->user()->balance)); ?> <?php echo e($general->cur_text); ?>)</option>
                            </select>
                        </div>
                    </div>


                    <div class="col-xl-12">
                        <div class="form-group">
                            <label class="form-label" for="description"><?php echo app('translator')->get('Description'); ?></label>
                            <textarea rows="6" class="form-control form--control " style="height:unset!important" name="description" id="description" placeholder="<?php echo app('translator')->get('Description'); ?>"><?php echo e(old('description')); ?></textarea>
                        </div>
                    </div>

                    <div class="col-xl-12">
                        <button type="submit" class="ud-btn btn-thm w-100"><?php echo app('translator')->get('Confirm Order'); ?></button>
                    </div>

                </div>
            </form>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/datepicker.min.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/datepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/datepicker.en.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $('.datepicker-here').datepicker({
            changeYear: true,
            changeMonth: true,
            minDate: new Date(),
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/user/order/form.blade.php ENDPATH**/ ?>