<?php
$testimonialContent = getContent('testimonial.content', true);
$testimonials = getContent('testimonial.element', false, null, true);
?>
<section class="testimonial-section pt-80 pb-80">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-xxl-7">
                <div class="section-header text-center">
                    <h2 class="section-header__title"><?php echo e(__(@$testimonialContent->data_values->heading)); ?></h2>
                </div>
            </div>
        </div>
        <div class="testimonial-slider">
            <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="single-slide">
                    <div class="testimonial-item">
                        <div class="testimonial-item__content">
                            <ul class="rating">
                                <?php
                                echo showRatings($testimonial->data_values->rating);
                                ?>
                            </ul>
                            <p><?php echo e(__(@$testimonial->data_values->review)); ?></p>
                        </div>
                        <div class="d-flex align-items-center justify-content-between gap-3">
                            <div class="testimonial-thumb-wrapper">
                                <div class="testimonial-thumb">
                                    <img src="<?php echo e(getImage('assets/images/frontend/testimonial/' . @$testimonial->data_values->profile_image, '150x150')); ?>" alt="cover">
                                </div>
                                <div class="testimonial-content">
                                    <h5 class="name"><?php echo e(__(@$testimonial->data_values->name)); ?></h5>
                                    <p class="text--muted"><?php echo e(__(@$testimonial->data_values->designation)); ?></p>
                                </div>
                            </div>
                            <span class="icon"><i class="fas fa-quote-right"></i></span>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH /home/infu.nibiru-it.ro/public_html/core/resources/views/templates/basic/sections/testimonial.blade.php ENDPATH**/ ?>