<?php
$banner = getContent('banner.content', true);
?>
<section class="banner-section bg_img overflow-hidden mb-0">
    <div class="container">
        <div class="d-flex justify-content-lg-between flex-wrap">
            <div class="banner-content">
                <h1 class="title"><?php echo e(__(@$banner->data_values->heading)); ?></h1>
                <p><?php echo e(__(@$banner->data_values->subheading)); ?></p>
                <form action="<?php echo e(route('influencers')); ?>" class="search-form" method="GET">
                    <div class="form--group">
                        <div class="icon"><i class="fas fa-search"></i></div>
                        <div class="input-group">
                            <input type="text" name="search" class="form-control form--control" placeholder="<?php echo app('translator')->get('Search by name, profession or country'); ?>">
                            <button class="btn btn--base btn--round btn--md"><?php echo app('translator')->get('Search'); ?></button>
                        </div>
                    </div>
                </form>
                <?php if($tags->count()): ?>
                <ul class="tags mt-5">
                    <li class="text-light"><?php echo app('translator')->get('Trending'); ?> :</li>
                    <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <a class="btn btn--sm btn--outline-light" href="<?php echo e(route('service.tag', [$tag->id, slug($tag->name)])); ?>">
                            <?php echo e(__($tag->name)); ?></a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <?php endif; ?>
            </div>
            <div class="banner-thumb ps-xl-5 ps-lg-4 d-lg-block d-none">
                <img src="<?php echo e(getImage('assets/images/frontend/banner/' . @$banner->data_values->image, '500x735')); ?>" alt="images">
            </div>
        </div>
    </div>
</section>


<?php
    $partnerContent = getContent('partner.content', true);
    $partnerElement = getContent('partner.element', false, null, true);
?>

<section class="brand-section bg--light pt-30 pb-30 overflow-hidden">
    <div class="container">
        <div class="row gy-4 align-items-center">
            <div class="col-md-3 col-lg-2">
                <h5 class="text-center text-md-start"><?php echo e(__(@$partnerContent->data_values->heading)); ?></h5>
            </div>
            <div class="col-md-9 col-lg-10">
                <div class="brands-slider">
                    <?php $__currentLoopData = $partnerElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="single-slide">
                        <div class="brand-item">
                            <img src="<?php echo e(getImage('assets/images/frontend/partner/' . @$partner->data_values->image, '130x65')); ?>" alt="brands">
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php /**PATH /home/infu.nibiru-it.ro/public_html/core/resources/views/templates/basic/sections/banner.blade.php ENDPATH**/ ?>