<?php
$pages = App\Models\Page::where('tempname', $activeTemplate)
    ->where('is_default', 0)
    ->get();

$condition = request()->routeIs('user.*') || request()->routeIs('influencer.*') || request()->routeIs('ticket*');
?>


<div class="header <?php if($condition): ?> dash-header <?php endif; ?>">
    <div class="header-bottom">
        <div class="container">
            <div class="header-bottom-area align-items-center">
                <div class="logo"><a href="<?php echo e(route('home')); ?>"><img src="<?php if(!$condition): ?> <?php echo e(getImage(getFilePath('logoIcon') . '/logo.png')); ?> <?php else: ?> <?php echo e(getImage(getFilePath('logoIcon') . '/logo_dark.png')); ?> <?php endif; ?> " alt="logo"></a></div>
                <ul class="menu">
                    <li class="d-lg-none p-0 border-0 header-close ">
                        <span class="fs--20px text-white"><i class="las la-times"></i></span>
                    </li>

                    <li>
                        <a href="<?php echo e(route('home')); ?>" class="<?php echo e(menuActive('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                    </li>

                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a href="<?php echo e(route('pages', [$data->slug])); ?>" class="<?php echo e(menuActive('pages', [$data->slug])); ?>"><?php echo e(__($data->name)); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <li>
                        <a href="<?php echo e(route('services')); ?>" class="<?php echo e(menuActive('services')); ?>"><?php echo app('translator')->get('Services'); ?></a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('influencers')); ?>" class="<?php echo e(menuActive('influencers')); ?>"><?php echo app('translator')->get('Influencers'); ?></a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('contact')); ?>" class="<?php echo e(menuActive('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                    </li>

                    <li class="d-lg-none">
                        <?php if(!(auth()->id() || authInfluencerId())): ?>
                            <a href="<?php echo e(route('user.login')); ?>" class="btn btn-md btn--base"><?php echo app('translator')->get('Login'); ?></a>
                        <?php endif; ?>

                        <?php if(auth()->guard()->check()): ?>
                            <a href="<?php echo e(route('user.home')); ?>" class="btn btn-md btn--base"><?php echo app('translator')->get('Dashboard'); ?></a>
                        <?php endif; ?>

                        <?php if(auth()->guard('influencer')->check()): ?>
                            <a href="<?php echo e(route('influencer.home')); ?>" class="btn btn-md btn--base"><?php echo app('translator')->get('Dashboard'); ?></a>
                        <?php endif; ?>
                    </li>
                </ul>
                <div class="header-trigger-wrapper d-flex align-items-center">
                    <div class="button-wrapper d-flex align-items-center flex-wrap" style="gap:8px 15px">
                        <?php if(!(auth()->id() || authInfluencerId())): ?>
                            <ul class="d-flex align-items-center flex-wrap" style="gap:8px 15px">
                                <li class="me-0">
                                    <a href="<?php echo e(route('user.login')); ?>" class="login-btn btn btn--md btn--outline-base d-none d-sm-grid text-white"><?php echo app('translator')->get('Login'); ?></a>
                                </li>
                                <li class="me-0">
                                    <a href="<?php echo e(route('user.register')); ?>" class="login-btn btn btn--md btn--outline-base d-none d-sm-grid text-white"><?php echo app('translator')->get('Register'); ?></a>
                                </li>
                            </ul>
                        <?php endif; ?>

                        <?php if(auth()->guard()->check()): ?>
                            <ul class="d-flex align-items-center flex-wrap">
                                <li class="me-0">
                                    <a href="<?php echo e(route('user.home')); ?>" class="login-btn btn btn--md btn--outline-base d-none d-sm-grid text-white"><?php echo app('translator')->get('Dashboard'); ?></a>
                                </li>
                            </ul>
                        <?php endif; ?>

                        <?php if(auth()->guard('influencer')->check()): ?>
                            <ul class="d-flex align-items-center flex-wrap">
                                <li class="me-0">
                                    <a href="<?php echo e(route('influencer.home')); ?>" class="login-btn btn--md btn btn--outline-base d-none d-sm-grid text-white"><?php echo app('translator')->get('Dashboard'); ?></a>
                                </li>
                            </ul>
                        <?php endif; ?>

                        <?php if($language->count()): ?>
                            <select class="language langSel form--control h-auto px-2 py-2">
                                <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->code); ?>" <?php if(session('lang') == $item->code): ?> selected <?php endif; ?>>
                                        <?php echo e(__($item->name)); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        <?php endif; ?>
                    </div>
                    <div class="header-trigger d-lg-none">
                        <span></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/partials/header.blade.php ENDPATH**/ ?>