<?php $__env->startSection('content'); ?>
    <form action="" class="d-flex justify-content-end ms-auto table--form mb-3 flex-wrap">
        <div class="input-group">
            <input type="text" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>"
                   placeholder="<?php echo app('translator')->get('Search by transactions'); ?>">
            <button class="input-group-text bg--base border-0 px-4 text-white">
                <i class="las la-search"></i>
            </button>
        </div>
    </form>
    <table class="table--responsive--lg table">
        <thead>
            <tr>
                <th><?php echo app('translator')->get('Gateway | Transaction'); ?></th>
                <th><?php echo app('translator')->get('Initiated'); ?></th>
                <th><?php echo app('translator')->get('Amount'); ?></th>
                <th><?php echo app('translator')->get('Conversion'); ?></th>
                <th><?php echo app('translator')->get('Status'); ?></th>
                <th><?php echo app('translator')->get('Action'); ?></th>
            </tr>
        </thead>
        <tbody>

            <?php $__empty_1 = true; $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td data-label="<?php echo app('translator')->get('Gateway | Transaction'); ?>">
                        <div>
                            <p class="text--base fw-bold"> <?php echo e(__(@$withdraw->method->name)); ?></p>
                            <small><?php echo e($withdraw->trx); ?></small>
                        </div>
                    </td>
                    <td data-label="<?php echo app('translator')->get('Initiated'); ?>">
                        <?php echo e(showDateTime($withdraw->created_at)); ?> <br> <?php echo e(diffForHumans($withdraw->created_at)); ?>

                    </td>
                    <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                        <div>
                            <?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($withdraw->amount)); ?> - <span class="text-danger"
                                  title="<?php echo app('translator')->get('charge'); ?>"><?php echo e(showAmount($withdraw->charge)); ?> </span><br>
                            <strong title="<?php echo app('translator')->get('Amount after charge'); ?>">
                                <?php echo e(showAmount($withdraw->amount - $withdraw->charge)); ?> <?php echo e(__($general->cur_text)); ?>

                            </strong>
                        </div>

                    </td>
                    <td data-label="<?php echo app('translator')->get('Conversion'); ?>">
                        <div>
                            1 <?php echo e(__($general->cur_text)); ?> = <?php echo e(showAmount($withdraw->rate)); ?>

                            <?php echo e(__($withdraw->currency)); ?><br>
                            <strong><?php echo e(showAmount($withdraw->final_amount)); ?> <?php echo e(__($withdraw->currency)); ?></strong>
                        </div>
                    </td>
                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                        <?php echo $withdraw->statusBadge ?>
                    </td>
                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                        <div>
                            <button class="btn btn--sm btn--outline-base detailBtn"  data-bs-toggle="tooltip" data-placement="top" title="<?php echo app('translator')->get('View'); ?>"
                                    data-user_data="<?php echo e(json_encode($withdraw->withdraw_information)); ?>"
                                    <?php if($withdraw->status == 3 || $withdraw->status == 1): ?> data-admin_feedback="<?php echo e($withdraw->admin_feedback); ?>" <?php endif; ?>>
                                <i class="las la-desktop"></i> <?php echo app('translator')->get('Detail'); ?>
                            </button>
                        </div>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td class="justify-content-center text-center" colspan="100%">
                        <i class="la la-4x la-frown"></i>
                        <br>
                        <?php echo e(__($emptyMessage)); ?>

                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
    <?php echo e($withdraws->links()); ?>


    <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <ul class="list-group-flush userData">

                    </ul>
                    <div class="feedback"></div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                var userData = $(this).data('user_data');
                var html = ``;
                userData.forEach(element => {
                    if (element.type != 'file') {
                        html += `
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>${element.name}</span>
                            <span">${element.value}</span>
                        </li>`;
                    }
                });
                modal.find('.userData').html(html);

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong><?php echo app('translator')->get('Admin Feedback'); ?></strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                modal.find('.feedback').html(adminFeedback);

                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/influencer/withdraw/log.blade.php ENDPATH**/ ?>