<?php $__env->startSection('content'); ?>
<form action="" class="d-flex flex-wrap justify-content-end ms-auto table--form mb-3">
    <div class="input-group">
        <input type="text" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Order No / Influencer'); ?>">
        <button class="input-group-text bg--base text-white border-0 px-4"><i class="las la-search"></i></button>
    </div>
</form>
<table class="table--responsive--lg table">
    <thead>
        <tr>
            <th><?php echo app('translator')->get('Order Number'); ?></th>
            <th><?php echo app('translator')->get('Influencer'); ?></th>
            <th class="text-center"><?php echo app('translator')->get('Amount | Delivery'); ?></th>
            <th><?php echo app('translator')->get('Status'); ?></th>
            <th><?php echo app('translator')->get('Action'); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td data-label="<?php echo app('translator')->get('Order Number'); ?>">
                <span><?php echo e($order->order_no); ?></span>
            </td>
            <td data-label="<?php echo app('translator')->get('Influencer'); ?>">
                <span class="fw-bold"><a href="<?php echo e(route('influencer.profile', [slug($order->influencer->username), $order->influencer_id])); ?>" class="text--base"><?php echo e(__(@$order->influencer->username)); ?></span>
            </td>
            <td data-label="<?php echo app('translator')->get('Amount | Delivery'); ?>" class="text-center">
                <div>
                    <span class="fw-bold"><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($order->amount)); ?></span> <br>
                    <?php echo e($order->delivery_date); ?>

                </div>
            </td>
            <td data-label="<?php echo app('translator')->get('Status'); ?>">
                <?php echo $order->statusBadge ?>
            </td>

            <td data-label="<?php echo app('translator')->get('Action'); ?>">
                <div class="d-flex flex-wrap gap-1 justify-content-end">
                    <?php if($order->status == 1): ?>
                        <?php if($order->review): ?>
                            <a href="<?php echo e(route('user.review.service',$order->id)); ?>" class="btn btn--sm btn--outline-warning">
                                <i class="las la-star"></i> <?php echo app('translator')->get('Review'); ?>
                            </a>
                        <?php else: ?>
                            <a href="<?php echo e(route('service.details', [slug(@$order->service->title), $order->service_id, $order->id])); ?>" class="btn btn--sm btn--outline-warning">
                                <i class="las la-star"></i> <?php echo app('translator')->get('Review'); ?>
                            </a>
                        <?php endif; ?>
                    <?php else: ?>
                    <span class="d-inline-block" tabindex="0" data-bs-toggle="tooltip" data-placement="top" title="<?php echo app('translator')->get('You can review it after the order is completed.'); ?>">
                        <button type="button" class="btn btn--sm btn--outline-warning disabled"><i class="las la-star"></i> <?php echo app('translator')->get('Review'); ?></button>
                    </span>
                    <?php endif; ?>
                    <a href="<?php echo e(route('user.order.detail',$order->id)); ?>" class="btn btn--sm btn--outline-base">
                        <i class="la la-desktop"></i> <?php echo app('translator')->get('Detail'); ?>
                    </a>
                    <a href="<?php echo e(route('user.order.conversation.view',$order->id)); ?>" class="btn btn--sm btn--outline-info">
                        <i class="las la-sms"></i> <?php echo app('translator')->get('Chat'); ?>
                    </a>
                </div>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr>
            <td class="justify-content-center text-center" colspan="100%">
                <i class="la la-4x la-frown"></i>
                <br>
                <?php echo e(__($emptyMessage)); ?>

            </td>
        </tr>
        <?php endif; ?>
    </tbody>
</table>
<?php echo e($orders->links()); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/user/order/list.blade.php ENDPATH**/ ?>