<?php $__env->startSection('content'); ?>
    <?php if($layout == 'frontend'): ?>
        <div class="pt-80 pb-80">
            <div class="container">
    <?php endif; ?>
    <div class="card custom--card">
        <div class="card-header d-flex justify-content-between align-items-center flex-wrap gap-3">
            <h6 class="card-title m-0">
                <?php echo $myTicket->statusBadge; ?> [<?php echo app('translator')->get('Ticket'); ?>#<?php echo e($myTicket->ticket); ?>] <?php echo e($myTicket->subject); ?>

            </h6>
            <?php if($myTicket->status != 3 && $myTicket->user): ?>
                <button class="btn btn--danger btn--sm confirmationBtn" type="button" data-question="<?php echo app('translator')->get('Are you sure to close this ticket?'); ?>" data-action="<?php echo e(route('ticket.close', $myTicket->id)); ?>" data-btn_class="btn btn--base btn--md"><i class="la la-lg la-times-circle"></i></button>
            <?php endif; ?>
        </div>

        <div class="card-body">
            <?php if($myTicket->status != 4): ?>
                <form method="post" action="<?php echo e(route('ticket.reply', $myTicket->id)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <div class="form-group">
                        <textarea name="message" class="form-control form--control shadow-none" id="inputMessage" placeholder="<?php echo app('translator')->get('Your Reply'); ?>" rows="4" cols="10"><?php echo e(old('message')); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label for="inputAttachments" class="form-label"><?php echo app('translator')->get('Attachments'); ?></label>
                        <small class="text-danger"><?php echo app('translator')->get('Max 5 files can be uploaded'); ?>. <?php echo app('translator')->get('Maximum upload size is'); ?>
                            <?php echo e(ini_get('upload_max_filesize')); ?></small>
                        <div class="d-flex gap-2">
                            <input type="file" name="attachments[]" id="inputAttachments" class="form--control form-control">
                            <a href="javascript:void(0)" class="btn btn--base d-flex align-items-center addFile">
                                <i class="la la-plus"></i>
                            </a>
                        </div>
                        <div id="fileUploadsContainer"></div>
                        <p class="ticket-attachments-message text-muted mt-2 fs--13px">
                            <?php echo app('translator')->get('Allowed File Extensions'); ?>: .<?php echo app('translator')->get('jpg'); ?>, .<?php echo app('translator')->get('jpeg'); ?>,
                            .<?php echo app('translator')->get('png'); ?>, .<?php echo app('translator')->get('pdf'); ?>,
                            .<?php echo app('translator')->get('doc'); ?>, .<?php echo app('translator')->get('docx'); ?>
                        </p>
                    </div>
                    <button type="submit" class="btn btn--base w-100 h-40">
                        <i class="fa fa-reply"></i> <?php echo app('translator')->get('Reply'); ?>
                    </button>
                </form>
            <?php endif; ?>
        </div>
    </div>
    <div class="card custom--card mt-3">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($message->admin_id == 0): ?>
                            <div class="row border-radius-3 my-sm-3 mx-sm-2 ticket-reply-user my-2 mx-0 border py-3">
                                <div class="col-md-3 border--right text-end">
                                    <h5 class="text--base my-3"><?php echo e(@$message->ticket->name); ?></h5>
                                </div>
                                <div class="col-md-9 ps-2">
                                    <p class="text-muted fw-bold">
                                        <?php echo app('translator')->get('Posted on'); ?> <?php echo e($message->created_at->format('l, dS F Y @ H:i')); ?>

                                    </p>
                                    <p>
                                        <?php echo e(__($message->message)); ?>

                                    </p>
                                    <?php if($message->attachments->count() > 0): ?>
                                        <div class="d-flex mt-2 flex-wrap gap-4">
                                            <?php $__currentLoopData = $message->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="<?php echo e(route('ticket.download', encrypt($image->id))); ?>" class="text--base mr-3"><i class="fa fa-file"></i>
                                                    <?php echo app('translator')->get('Attachment'); ?> <?php echo e(++$k); ?> </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="row border-warning border-radius-3 my-sm-3 mx-sm-2 my-2 mx-0 border py-3">
                                <div class="col-md-3 border--right text-end">
                                    <h5 class="text--base my-3"><?php echo e(@$message->admin->name); ?></h5>
                                </div>
                                <div class="col-md-9 ps-2">
                                    <p class="text-muted fw-bold">
                                        <?php echo app('translator')->get('Posted on'); ?> <?php echo e($message->created_at->format('l, dS F Y @ H:i')); ?>

                                    </p>
                                    <p><?php echo e(__($message->message)); ?></p>
                                    <?php if($message->attachments->count() > 0): ?>
                                        <div class="d-flex mt-2 flex-wrap gap-4">
                                            <?php $__currentLoopData = $message->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="<?php echo e(route('ticket.download', encrypt($image->id))); ?>" class="text--base mr-3"><i class="la la-file"></i>
                                                    <?php echo app('translator')->get('Attachment'); ?> <?php echo e(++$k); ?> </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php if($layout == 'frontend'): ?>
        </div>
        </div>
    <?php endif; ?>
    <?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ConfirmationModal::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addFile').on('click', function() {
                if (fileAdded >= 4) {
                    notify('error', 'You\'ve added maximum number of file');
                    return false;
                }
                fileAdded++;
                $("#fileUploadsContainer").append(`
                    <div class="form-group d-flex gap-2 mt-3">
                        <input type="file" name="attachments[]" class="form-control form--control" required/>
                        <button class="btn btn--danger radius-5 remove-btn" type="button"><i class="las la-times"></i></button>
                    </div>
                `)
            });
            $(document).on('click', '.remove-btn', function() {
                fileAdded--;
                $(this).closest('.form-group').remove();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.' . $layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/user/support/view.blade.php ENDPATH**/ ?>