<?php $__env->startSection('content'); ?>
<form action="" class="d-flex flex-wrap justify-content-end ms-auto table--form mb-3">
    <div class="input-group">
        <input type="text" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Search by Influencer'); ?>">
        <button class="input-group-text bg--base text-white border-0 px-4"><i class="las la-search"></i></button>
    </div>
</form>
<table class="table table--responsive--lg">
    <thead>
        <tr>
            <th><?php echo app('translator')->get('Influencer'); ?></th>
            <th><?php echo app('translator')->get('Rating'); ?></th>
            <th class="text-center"><?php echo app('translator')->get('Completed Order'); ?></th>
            <th><?php echo app('translator')->get('Joined At'); ?></th>
            <th><?php echo app('translator')->get('Action'); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $favorites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $favorite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td data-label="<?php echo app('translator')->get('Influencer'); ?>">
                <span class="fw-bold">
                    <a href="<?php echo e(route('influencer.profile', [slug($favorite->influencer->username), $favorite->influencer_id])); ?>"><?php echo e(__(@$favorite->influencer->username)); ?>

                    </a>
                </span>
            </td>

            <td data-label="<?php echo app('translator')->get('Rating'); ?>">
                <p class="text--warning">
                    <?php
                    echo showRatings($favorite->influencer->rating);
                    ?>
                    (<?php echo e(getAmount(@$favorite->influencer->reviews_count)); ?>)
                </p>
            </td>

            <td data-label="<?php echo app('translator')->get('Completed Order'); ?>" class="text-center">
                <span><?php echo e(getAmount(@$favorite->influencer->completed_order )); ?></span>
            </td>

            <td data-label="<?php echo app('translator')->get('Joined'); ?>">
                <span><?php echo e(showDateTime(@$favorite->influencer->created_at)); ?></span>
            </td>

            <td data-label="<?php echo app('translator')->get('Action'); ?>">
                <div>
                    <a href="<?php echo e(route('influencer.profile', [slug($favorite->influencer->username), $favorite->influencer_id])); ?>" class="btn btn--sm btn--outline-base">
                        <i class="las la-external-link-alt"></i> <?php echo app('translator')->get('Profile'); ?>
                    </a>

                    <button type="button" class="btn btn--sm btn--outline-danger confirmationBtn" data-action="<?php echo e(route('user.favorite.remove', $favorite->id)); ?>" data-question="Are you sure to remove this influencer?" data-btn_class="btn btn--base btn--md">
                        <i class="la la-times"></i> <?php echo app('translator')->get('Remove'); ?>
                    </button>

                </div>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr>
            <td class="justify-content-center text-center" colspan="100%">
                <i class="la la-4x la-frown"></i>
                <br>
                <?php echo e(__($emptyMessage)); ?>

            </td>
        </tr>
        <?php endif; ?>
    </tbody>
</table>
<?php echo e($favorites->links()); ?>


<?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ConfirmationModal::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/user/favorite/list.blade.php ENDPATH**/ ?>