

<?php
$servicePropular = getContent('service.content', true);
$servicesPropular = App\Models\Service::approved()
    ->with('influencer', 'category')
    ->latest()
    ->orderBy('rating', 'desc')
    ->take(8)
    ->get();
?>
<?php if($servicesPropular->count() > 0): ?>
    <section class="counter-section pt-80 pb-80">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7 col-xl-6">
                    <div class="section-header text-center">
                        <h2 class="section-header__title">Servicii Popluare</h2>
                    </div>
                </div>
            </div>
            <div class="row gy-4 justify-content-center">
                <?php $__currentLoopData = $servicesPropular; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-xl-3 col-md-6 col-sm-10">
                        <div class="service-item">
                            <div class="service-item__thumb">
                                <img src="<?php echo e(getImage(getFilePath('service') . '/thumb_' . $service->image, getFileThumb('service'))); ?>" alt="images">
                            </div>
                            <div class="service-item__content">
                                <div class="influencer-thumb">
                                    <img src="<?php echo e(getImage(getFilePath('influencerProfile') . '/' . @$service->influencer->image, getFileSize('influencerProfile'), true)); ?>" alt="images">
                                </div>
                                <div class="d-flex justify-content-between mb-1 flex-wrap">
                                    <h6 class="name"> <i class="la la-user"></i> <?php echo e(__(@$service->influencer->username)); ?></h6>
                                    <span class="service-rating">
                                        <?php
                                            echo showRatings(@$service->rating);
                                        ?>
                                        (<?php echo e($service->reviews_count ?? 0); ?>)
                                    </span>
                                </div>
                                <h6 class="title mb-3 mt-2"><a href="<?php echo e(route('service.details', [slug($service->title), $service->id])); ?>"><?php echo e(__(@$service->title)); ?></a></h6>
                                <div class="service-footer border-top d-flex justify-content-between align-items-center flex-wrap pt-1">
                                    <span class="fs--14px"><i class="fas fa-tag fs--13px me-1"></i> <?php echo e(__(@$service->category->name)); ?></span>
                                    <h6 class="service-price fs--15px"><small><?php echo e($general->cur_sym); ?></small><?php echo e(showAmount($service->price)); ?></h6>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="text-center">
                <a href="<?php echo e(route('services')); ?>" class="cmn--btn mt-5" style="width: 20%;"><?php echo app('translator')->get('Vezi toate'); ?></a>
            </div>
        </div>
    </section>
<?php endif; ?>










<?php
$service = getContent('service.content', true);
$services = App\Models\Service::approved()
    ->with('influencer', 'category')
    ->latest()
    ->take(8)
    ->get();
?>
<?php if($services->count() > 0): ?>
    <section class="counter-section pt-80 pb-80">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7 col-xl-6">
                    <div class="section-header text-center">
                        <h2 class="section-header__title">Ultimele Servicii</h2>
                    </div>
                </div>
            </div>
            <div class="row gy-4 justify-content-center">
                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-xl-3 col-md-6 col-sm-10">
                        <div class="service-item">
                            <div class="service-item__thumb">
                                <img src="<?php echo e(getImage(getFilePath('service') . '/thumb_' . $service->image, getFileThumb('service'))); ?>" alt="images">
                            </div>
                            <div class="service-item__content">
                                <div class="influencer-thumb">
                                    <img src="<?php echo e(getImage(getFilePath('influencerProfile') . '/' . @$service->influencer->image, getFileSize('influencerProfile'), true)); ?>" alt="images">
                                </div>
                                <div class="d-flex justify-content-between mb-1 flex-wrap">
                                    <h6 class="name"> <i class="la la-user"></i> <?php echo e(__(@$service->influencer->username)); ?></h6>
                                    <span class="service-rating">
                                        <?php
                                            echo showRatings(@$service->rating);
                                        ?>
                                        (<?php echo e($service->reviews_count ?? 0); ?>)
                                    </span>
                                </div>
                                <h6 class="title mb-3 mt-2"><a href="<?php echo e(route('service.details', [slug($service->title), $service->id])); ?>"><?php echo e(__(@$service->title)); ?></a></h6>
                                <div class="service-footer border-top d-flex justify-content-between align-items-center flex-wrap pt-1">
                                    <span class="fs--14px"><i class="fas fa-tag fs--13px me-1"></i> <?php echo e(__(@$service->category->name)); ?></span>
                                    <h6 class="service-price fs--15px"><small><?php echo e($general->cur_sym); ?></small><?php echo e(showAmount($service->price)); ?></h6>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="text-center">
                <a href="<?php echo e(route('services')); ?>" class="cmn--btn mt-5" style="width: 20%;"><?php echo app('translator')->get('Vezi toate'); ?></a>
            </div>
        </div>
    </section>
<?php endif; ?>


<?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/sections/service.blade.php ENDPATH**/ ?>