<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Influencer'); ?></th>
                                <th><?php echo app('translator')->get('Email-Phone'); ?></th>
                                <th><?php echo app('translator')->get('Country'); ?></th>
                                <th><?php echo app('translator')->get('Joined At'); ?></th>
                                <th><?php echo app('translator')->get('Balance'); ?></th>
                                <th><?php echo app('translator')->get('Complete Order'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $influencers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $influencer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo app('translator')->get('Influencer'); ?>">
                                    <span class="fw-bold"><?php echo e($influencer->fullname); ?></span>
                                    <br>
                                    <span class="small">
                                    <a href="<?php echo e(route('admin.influencers.detail', $influencer->id)); ?>"><span>@</span><?php echo e($influencer->username); ?></a>
                                    </span>
                                </td>


                                <td data-label="<?php echo app('translator')->get('Email-Phone'); ?>">
                                    <?php echo e($influencer->email); ?><br><?php echo e($influencer->mobile); ?>

                                </td>
                                <td data-label="<?php echo app('translator')->get('Country'); ?>">
                                    <span class="fw-bold" title="<?php echo e(@$influencer->address->country); ?>"><?php echo e($influencer->country_code); ?></span>
                                </td>



                                <td data-label="<?php echo app('translator')->get('Joined At'); ?>">
                                    <?php echo e(showDateTime($influencer->created_at)); ?> <br> <?php echo e(diffForHumans($influencer->created_at)); ?>

                                </td>


                                <td data-label="<?php echo app('translator')->get('Balance'); ?>">
                                    <span class="fw-bold">
                                    <?php echo e($general->cur_sym); ?><?php echo e(showAmount($influencer->balance)); ?>

                                    </span>
                                </td>

                                <td data-label="<?php echo app('translator')->get('Complete Order'); ?>">
                                    <span class="fw-bold"><?php echo e(getAmount($influencer->completed_order)); ?></span>
                                </td>

                                <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                    <a href="<?php echo e(route('admin.influencers.detail', $influencer->id)); ?>" class="btn btn-sm btn-outline--primary">
                                        <i class="las la-desktop text--shadow"></i> <?php echo app('translator')->get('Details'); ?>
                                    </a>
                                    
                                </td>

                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <?php if($influencers->hasPages()): ?>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($influencers)); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>


    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('breadcrumb-plugins'); ?>
    <div class="d-flex flex-wrap justify-content-end">
        <form action="" method="GET" class="form-inline">
            <div class="input-group justify-content-end">
                <input type="text" name="search" class="form-control bg--white" placeholder="<?php echo app('translator')->get('Search username'); ?>" value="<?php echo e(request()->search); ?>">
                <button class="btn btn--primary input-group-text" type="submit"><i class="fa fa-search"></i></button>
            </div>
        </form>
    </div>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/admin/influencers/list.blade.php ENDPATH**/ ?>