<?php
$content = getContent('top_influencer.content', true);
?>

<?php $__env->startSection('content'); ?>
<section class="story-details pt-80 pb-80">
    <div class="container">
        <div class="row gy-4">
            <div class="col-lg-9">
                <div class="story-item border-0 p-0 shadow-none">
                    <div class="service-order-wrapper__left">
                        <div class="service-details-slider">

                            <div class="single-slide">
                                <div class="slider-preview-thumb">
                                    <img src="<?php echo e(getImage(getFilePath('service') . '/' . $service->image, getFileSize('service'))); ?>" alt="image">
                                </div>
                            </div>

                            <?php $__currentLoopData = $service->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="single-slide">
                                <div class="slider-preview-thumb">
                                    <img src="<?php echo e(getImage(getFilePath('service') . '/' . $gallery->image, getFileSize('service'))); ?>" alt="image">
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="service-nav-slider">
                            <?php if($service->gallery->count()): ?>
                            <div class="single-slide">
                                <div class="slider-nav-thumb">
                                    <img src="<?php echo e(getImage(getFilePath('service') . '/thumb_' . $service->image, getFileThumb('service'))); ?>" alt="image">
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php $__currentLoopData = $service->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="single-slide">
                                <div class="slider-nav-thumb">
                                    <img src="<?php echo e(getImage(getFilePath('service') . '/thumb_' . $gallery->image, getFileThumb('service'))); ?>" alt="image">
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="story-item__content details-content">
                        <div class="story-meta d-flex justify-content-between flex-wrap">
                            <div class="story-meta">
                                <?php $__currentLoopData = $service->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('service.tag', [@$tag->id, slug(@$tag->name)])); ?>" class="tag badge badge--base"><?php echo e(__(@$tag->name)); ?></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <span class="text--warning service-rating">
                                <?php
                                echo showRatings(@$service->rating);
                                ?>
                                (<?php echo e(@$service->total_review ?? 0); ?>)
                            </span>

                        </div>
                        <h3 class="title"><?php echo e(__($service->title)); ?></h3>
                        <p><?php echo $service->description; ?></p>
                    </div>
                </div>
                <div class="col-lg-12" id="review-section">
                    <ul class="nav nav-tabs custom--nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php if(!@$orderId): ?> active <?php endif; ?>" id="description-tab" data-bs-toggle="tab" data-bs-target="#description" type="button" role="tab" aria-controls="description" ><?php echo app('translator')->get('About'); ?></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php if(@$orderId): ?> active <?php endif; ?>" id="review-tab" data-bs-toggle="tab" data-bs-target="#review" type="button" role="tab" aria-controls="review" ><?php echo app('translator')->get('Reviews'); ?></button>
                        </li>
                    </ul>
                    <div class="tab-content mt-3" id="myTabContent">
                        <div class="tab-pane fade <?php if(!@$orderId): ?> show active <?php endif; ?>" id="description" role="tabpanel" aria-labelledby="description-tab">
                            <p>
                                <?php
                                echo @$service->influencer->summary;
                                ?>
                            </p>
                        </div>
                        <div class="tab-pane fade <?php if(@$orderId): ?> show active <?php endif; ?>" id="review" role="tabpanel" aria-labelledby="review-tab">
                            <?php if($orderId): ?>
                            <form action="<?php echo e(route('user.review.service.add', $orderId)); ?>" method="POST" class="row review-form rating gy-3">
                                <?php echo csrf_field(); ?>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label text-dark me-5"><?php echo app('translator')->get('Your Ratings'); ?> :</label>
                                        <div class="rating-form-group">
                                            <label class="star-label">
                                                <input type="radio" name="star" value="1" />
                                                <span class="icon"><i class="las la-star"></i></span>
                                            </label>
                                            <label class="star-label">
                                                <input type="radio" name="star" value="2" />
                                                <span class="icon"><i class="las la-star"></i></span>
                                                <span class="icon"><i class="las la-star"></i></span>
                                            </label>
                                            <label class="star-label">
                                                <input type="radio" name="star" value="3" />
                                                <span class="icon"><i class="las la-star"></i></span>
                                                <span class="icon"><i class="las la-star"></i></span>
                                                <span class="icon"><i class="las la-star"></i></span>
                                            </label>
                                            <label class="star-label">
                                                <input type="radio" name="star" value="4" />
                                                <span class="icon"><i class="las la-star"></i></span>
                                                <span class="icon"><i class="las la-star"></i></span>
                                                <span class="icon"><i class="las la-star"></i></span>
                                                <span class="icon"><i class="las la-star"></i></span>
                                            </label>
                                            <label class="star-label">
                                                <input type="radio" name="star" value="5" />
                                                <span class="icon"><i class="las la-star"></i></span>
                                                <span class="icon"><i class="las la-star"></i></span>
                                                <span class="icon"><i class="las la-star"></i></span>
                                                <span class="icon"><i class="las la-star"></i></span>
                                                <span class="icon"><i class="las la-star"></i></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="form-label text--dark"><?php echo app('translator')->get('Say something about this service'); ?></label>
                                        <textarea name="review" class="form-control form--control" placeholder="<?php echo app('translator')->get('Write here'); ?>..." required><?php echo e(old('review')); ?></textarea>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <button type="submit" class="btn btn--base w-100 btn--md"><?php echo app('translator')->get('Submit'); ?></button>
                                </div>
                            </form>
                            <?php endif; ?>
                            <div class="custom--card mt-4">
                                <div class="card-body">
                                    <h4 class="mb-3"><?php echo app('translator')->get('Reviews'); ?></h4>
                                    <?php $__empty_1 = true; $__currentLoopData = $service->reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="d-flex justify-content-between review-item border-top flex-wrap gap-4 py-3">
                                        <div class="left">
                                            <div class="profile">
                                                <div class="thumb">
                                                    <img src="<?php echo e(getImage(getFilePath('userProfile') . '/' . @$review->user->image, getFileSize('userProfile'), true)); ?>" alt="profile thumb">
                                                </div>
                                                <div class="content">
                                                    <h6 class="name"><?php echo e(__(@$review->user->fullname)); ?></h6>
                                                    <ul class="list d-flex fs--13px flex-wrap">
                                                        <li><?php echo e($review->created_at->format('d M Y')); ?></li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="right">
                                            <div class="rating-wrapper">
                                                <ul class="rating d-inline-flex">
                                                    <?php
                                                    echo showRatings(@$review->star);
                                                    ?>

                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="<?php if(!$loop->last): ?> mb-3 <?php endif; ?>"><?php echo e(__($review->review)); ?></p>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <h6 class="fw-light text--danger text-center"><?php echo app('translator')->get('No Review found'); ?></h6>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12 mt-5">
                    <div class="text-center">
                        <ul class="share-links d-flex justify-content-center flex-wrap">
                            <li class="caption"><?php echo app('translator')->get('Share'); ?> : </li>
                            <li data-bs-toggle="tooltip" data-bs-placement="top" title="Facebook">
                                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(url()->current())); ?>"><i class="lab la-facebook-f"></i></a>
                            </li>
                            <li data-bs-toggle="tooltip" data-bs-placement="top" title="Linkedin">
                                <a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo e(urlencode(url()->current())); ?>&amp;title=<?php echo e(__($service->title)); ?>&amp;summary=<?php echo e(__($service->description)); ?>"><i class="lab la-linkedin-in"></i></a>
                            </li>
                            <li data-bs-toggle="tooltip" data-bs-placement="top" title="Twitter">
                                <a href="https://twitter.com/intent/tweet?text=<?php echo e(__($service->title)); ?>%0A<?php echo e(url()->current()); ?>"><i class="lab la-twitter"></i></a>
                            </li>
                            <li data-bs-toggle="tooltip" data-bs-placement="top" title="pinterest">
                                <a href="http://pinterest.com/pin/create/button/?url=<?php echo e(urlencode(url()->current())); ?>&description=<?php echo e(__($service->title)); ?>&media=<?php echo e(getImage(getFilePath('service') . '/' . $service->image, getFileSize('service'))); ?>"><i class="lab la-pinterest"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-lg-3">
                <div class="sidebar">

                    <div class="card custom--card">
                        <div class="card-header bg--light">
                            <h6 class="text--base"><?php echo app('translator')->get('Price'); ?></h6>
                            <h3 class="text--base"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($service->price)); ?></h3>
                        </div>
                        <div class="card-body">
                            <ul class="list list-style-one ps-3 mb-3">
                                <?php $__currentLoopData = $service->key_points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e(__($point)); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <?php if(!authInfluencerId()): ?>
                            <a href="<?php echo e(route('user.order.form', $service->id)); ?>" class="btn btn--outline-base btn--md w-100">
                                <?php echo app('translator')->get('Order Now'); ?>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="sidebar-item mt-5">
                        <div class="influencer-item">
                            <div class="influencer-thumb">
                                <img src="<?php echo e(getImage(getFilePath('influencerProfile') . '/' . @$service->influencer->image, getFileSize('influencerProfile'), true)); ?>" alt="cover">
                                <span class="influencer-status <?php if(@$service->influencer->isOnline()): ?> active <?php endif; ?>"></span>
                            </div>

                            <div class="influencer-item__content">

                                <h5 class="name text--muted"><?php echo e(__(@$service->influencer->fullname)); ?></h5>
                                <p class="text--muted"><?php echo e(__(@$service->influencer->profession)); ?></p>

                                <div class="rating d-flex justify-content-center align-items-center mt-2">

                                    <span class="me-1">
                                        <?php
                                        echo showRatings(@$service->influencer->rating);
                                        ?>
                                    </span>
                                    (<?php echo e(getAmount(@$service->influencer->total_review) ?? 0); ?>)
                                </div>


                                <div class="d-flex justify-content-center my-2 flex-wrap gap-4">
                                    <a href="<?php echo e(route('influencer.profile', [slug(@$service->influencer->username), @$service->influencer_id])); ?>" class="btn btn--sm btn--outline-base radius-0"><?php echo app('translator')->get('View Profile'); ?></a>
                                </div>
                                <ul class="social-links d-flex justify-content-center flex-wrap">
                                    <?php $__currentLoopData = @$service->influencer->socialLink; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e($social->url); ?>" data-bs-toggle="tooltip" data-placement="top" title="<?php echo e(__($social->followers)); ?>"><?php echo $social->social_icon ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                            <?php
                            $skills = array_slice(@$service->influencer->skills ?? [], 0, 4);
                            ?>
                            <div class="skills-wrapper">
                                <?php if(@$service->influencer->skills): ?>
                                <?php $__currentLoopData = @$skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="skill"><?php echo e(__($skill)); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                <span class="skill m-auto"><?php echo app('translator')->get('No Specific Skill'); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <?php if($anotherServices->count() > 0): ?>
                    <h4 class="mt-5 mb-3"><?php echo app('translator')->get('Other Services'); ?></h4>
                    <?php $__currentLoopData = $anotherServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="sidebar-item">
                        <div class="recent-story story-item">
                            <div class="story-item__thumb">
                                <img src="<?php echo e(getImage(getFilePath('service') . '/thumb_' . $service->image, getFileThumb('service'))); ?>" alt="story">
                            </div>
                            <div class="story-item__content">
                                <h6 class="title"><a href="<?php echo e(route('service.details', [slug($service->title), $service->id])); ?>"><?php echo e(__($service->title)); ?></a></h6>
                                <div class="story-meta">
                                    <?php echo app('translator')->get('Posted by'); ?> - <a href="<?php echo e(route('influencer.profile', [slug($service->influencer->username), $service->influencer_id])); ?>"><span class="text--base"><span>@</span><?php echo e(__(@$service->influencer->username)); ?></span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ConfirmationModal::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
<style>
    .service-details-slider .single-slide img {
        max-height: 450px;
        display: inline-block;
    }

    .service-nav-slider {
        margin-top: 1.875rem;
    }

    .service-nav-slider .slick-list {
        margin: 0 -10px;
    }

    .service-nav-slider .single-slide {
        padding: 0 10px;
    }

    .service-nav-slider .slick-arrow {
        top: 50%;
        margin-top: -15px;
        width: 30px;
        height: 30px;
        border: 1px solid #3b2020;
        box-shadow: 0 0 3px rgba(116, 11, 11, 0.05);
        background-color: rgb(102, 34, 34);
        opacity: 0;
        visibility: hidden;
    }

    .service-nav-slider .slick-arrow.prev {
        left: 0px;
    }

    .service-nav-slider .slick-arrow.next {
        right: 0px;
    }

    .service-details-slider .single-slide {
        text-align: center;
    }

    .service-order-wrapper__left {
        width: 100%;
    }

    @media (max-width: 991px) {
        .service-order-wrapper__left {
            width: 100%;
        }
    }

    .service-order-wrapper__left:hover .service-nav-slider .slick-arrow {
        opacity: 1;
        visibility: visible;
    }

    .service-order-wrapper__left:hover .service-nav-slider .slick-arrow.prev {
        left: -20px;
    }

    .service-order-wrapper__left:hover .service-nav-slider .slick-arrow.next {
        right: -20px;
    }

    .service-order-wrapper__left {
        background-color: #fff;
    }

    .custom--nav-tabs {
        border-bottom: 1px solid #e5e5e5;
    }

    .nav {
        display: flex;
        flex-wrap: wrap;
        padding-left: 0;
        margin-bottom: 0;
        list-style: none;
    }

    .custom--nav-tabs .nav-item .nav-link {
        background-color: transparent;
        border: none;
        border-radius: 0px;
        -webkit-border-radius: 0px;
        -moz-border-radius: 0px;
        -ms-border-radius: 0px;
        -o-border-radius: 0px;
        padding: 0.75rem 1.5625rem;
        font-weight: 500;
        border-bottom: 2px solid transparent;
    }

    .custom--nav-tabs .nav-item .nav-link.active {
        border-color: rgb(var(--base));
        ;
    }

    .custom--nav-tabs .nav-item .nav-link.active {
        color: rgb(var(--base));
    }

    .nav-link {
        color: #000;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    (function($){
        "use strict";
        <?php if(@$orderId): ?>
            $('body,html').animate({scrollTop: 1000});
        <?php endif; ?>
    })(jQuery)
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/infu.nibiru-it.ro/public_html/core/resources/views/templates/basic/service/detail.blade.php ENDPATH**/ ?>