<?php
$login = getContent('influencer_login.content', true);
$userLogin = getContent('user_login.content', true);
?>

<?php $__env->startSection('content'); ?>
    <div class="account-section pt-80 pb-80">
        <div class="container">
            <div class="account-wrapper">
                <div class="row gy-5">
                    <div class="col-lg-6">
                        <div class="account-thumb-wrapper">
                            <img src="<?php echo e(getImage('assets/images/frontend/influencer_login/' . @$login->data_values->image, '660x450')); ?>" class="mw-100 h-100">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="account-content">

                            <div class="d-flex justify-content-between flex-wrap gap-3 pb-5">
                                <div class="account-content-left">
                                    <h3 class="this-page-title"><?php echo e(__(@$login->data_values->title)); ?></h3>
                                </div>
                                <div class="account-content-right">
                                    <button type="button" class="btn btn--md btn--outline-base actionBtn" data-type="client"><?php echo app('translator')->get('Client'); ?></button>
                                    <button type="button" class="btn btn--md btn--outline-base actionBtn active" data-type="influencer"><?php echo app('translator')->get('Influencer'); ?></button>
                                </div>
                            </div>

                            <form method="POST" action="<?php echo e(route('influencer.login')); ?>" class="account-form verify-gcaptcha">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label class="form-label"><?php echo app('translator')->get('Username or Email'); ?> </label>
                                    <input type="text" name="username" value="<?php echo e(old('username')); ?>" class="form-control form--control" required>
                                </div>
                                <div class="form-group">
                                    <label for="password" class="form-label"><?php echo app('translator')->get('Password'); ?> </label>
                                    <input type="password" name="password" id="password" class="form-control form--control" required>
                                </div>

                                <?php if (isset($component)) { $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Captcha::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\Captcha::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243)): ?>
<?php $component = $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243; ?>
<?php unset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243); ?>
<?php endif; ?>

                                <div class="d-flex justify-content-between flex-wrap">
                                    <div class="form-group custom--checkbox">
                                        <input type="checkbox" name="remember" id="remember"<?php echo e(old('remember') ? 'checked' : ''); ?>>
                                        <label for="remember"><?php echo app('translator')->get('Remember Me'); ?></label>
                                    </div>
                                    <a class="text--base forgot-url" href="<?php echo e(route('influencer.password.request')); ?>"><?php echo app('translator')->get('Forgot Password?'); ?></a>
                                </div>
                                <button type="submit" id="recaptcha" class="btn btn--base w-100"><?php echo app('translator')->get('Submit'); ?></button>
                            </form>
                            <div class="text-center">
                                <p class="mt-4"><?php echo app('translator')->get('Don\'t have an account?'); ?>
                                    <a href="<?php echo e(route('influencer.register')); ?>" class="text--base register-url"><?php echo app('translator')->get('Create an account'); ?></a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.actionBtn').on('click', function() {
                let action;
                let forgotUrl;
                let registerUrl;
                let pageTitle;

                if ($(this).data('type') == 'client') {
                    action = `<?php echo e(route('user.login')); ?>`;
                    forgotUrl = `<?php echo e(route('user.password.request')); ?>`;
                    registerUrl = `<?php echo e(route('user.register')); ?>`;
                    pageTitle = `<?php echo e(__(@$userLogin->data_values->title)); ?>`;
                } else {
                    action = `<?php echo e(route('influencer.login')); ?>`;
                    forgotUrl = `<?php echo e(route('influencer.password.request')); ?>`;
                    registerUrl = `<?php echo e(route('influencer.register')); ?>`;
                    pageTitle = `<?php echo e(__(@$login->data_values->title)); ?>`;
                }

                $('form')[0].action = action;
                $('.forgot-url').attr('href', forgotUrl);
                $('.register-url').attr('href', registerUrl);
                $('.this-page-title').text(pageTitle);
                $(this).addClass('active');
                $('.actionBtn').not($(this)).removeClass('active');
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/infu.nibiru-it.ro/public_html/core/resources/views/templates/basic/influencer/auth/login.blade.php ENDPATH**/ ?>