<?php
$influencerContent = getContent('top_influencer.content', true);
$influencers = App\Models\Influencer::with('socialLink')->where('completed_order','>',0)->orderBy('completed_order','desc')
    ->take(4)
    ->get();

$favorite    = App\Models\Favorite::where('user_id', auth()->id())->select('influencer_id')->pluck('influencer_id');
$influencersId = json_decode($favorite);
?>

<?php if($influencers->count() > 0): ?>
    <section class="influencer-section pt-80 pb-80 bg--light">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7 col-xxl-6">
                    <div class="section-header text-center">
                        <h2 class="section-header__title"><?php echo e(__(@$influencerContent->data_values->heading)); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row gy-4 justify-content-center">
                <?php $__currentLoopData = $influencers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $influencer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xxl-3 col-lg-4 col-md-6 col-sm-10">
                        <div class="influencer-item">
                            <?php if(auth()->guard()->check()): ?>
                                <?php if(in_array($influencer->id, @$influencersId)): ?>
                                <a href="javascript:void(0)" class="favoriteBtn active" data-influencer_id="<?php echo e($influencer->id); ?>"><i class="las la-heart"></i></a>
                                <?php else: ?>
                                <a href="javascript:void(0)" class="favoriteBtn" data-influencer_id="<?php echo e($influencer->id); ?>"><i class="lar la-heart"></i></a>
                                <?php endif; ?>
                            <?php endif; ?>
                            <div class="influencer-thumb">
                                <img src="<?php echo e(getImage(getFilePath('influencerProfile') . '/' . @$influencer->image, getFileSize('influencerProfile'), true)); ?>" alt="cover">
                                <span class="influencer-status <?php if($influencer->isOnline()): ?> active <?php endif; ?>"></span>
                            </div>

                            <div class="influencer-item__content">

                                <h5 class="name text--muted"><?php echo e(__($influencer->fullname)); ?></h5>
                                <p class="text--muted"><?php echo e(__($influencer->profession)); ?></p>

                                <div class="rating d-flex justify-content-center align-items-center mt-2">
                                    <span class="me-1">
                                        <?php
                                        echo showRatings($influencer->rating);
                                        ?>
                                    </span>
                                    (<?php echo e($influencer->total_review ?? 0); ?>)
                                </div>


                                <div class="d-flex justify-content-center mt-3 flex-wrap gap-4">
                                    <a href="<?php echo e(route('influencer.profile', [slug($influencer->username), $influencer->id])); ?>" class="btn btn--sm btn--outline-base radius-0"><?php echo app('translator')->get('View Profile'); ?></a>
                                </div>

                                <ul class="social-links d-flex justify-content-center flex-wrap">
                                    <?php $__currentLoopData = $influencer->socialLink; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a href="<?php echo e($social->url); ?>" data-bs-toggle="tooltip" data-placement="top" title="<?php echo e(__($social->followers)); ?>"><?php echo $social->social_icon ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <div class="skills-wrapper">
                                <?php if($influencer->skills): ?>
                                    <?php $__currentLoopData = @$influencer->skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="skill"><?php echo e(__($skill)); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <span class="skill m-auto"><?php echo app('translator')->get('No Specific Skill'); ?></span>
                                <?php endif; ?>
                            </div>


                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="text-center">
                <a href="<?php echo e(route('influencers')); ?>" class="cmn--btn mt-5"><?php echo app('translator')->get('View More'); ?></a>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/infu.nibiru-it.ro/public_html/core/resources/views/templates/basic/sections/top_influencer.blade.php ENDPATH**/ ?>