<?php $__env->startSection('content'); ?>
    <?php
    $contact = getContent('contact_us.content', true);
    $socialIcons = getContent('social_icon.element', false, null, true);
    ?>
    <section class="contact-area pt-80 pb-80">
        <div class="container">
            <div class="card custom--card">
                <div class="card-body">
                    <div class="row gy-5 justify-content-center align-items-center">
                        <div class="col-lg-7">
                            <div class="contact-form">
                                <h3 class="mb-4"><?php echo e(__(@$contact->data_values->heading)); ?></h3>
                                <form method="post" action="" class="verify-gcaptcha">
                                    <?php echo csrf_field(); ?>
                                    <div class="row gy-3">
                                        <?php
                                            if(auth()->user()){
                                                $user = auth()->user();
                                            }elseif (auth()->guard('influencer')->user()) {
                                                $user = auth()->guard('influencer')->user();
                                            }
                                        ?>

                                        <div class="col-lg-6 col-md-6">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo app('translator')->get('Name'); ?></label>
                                                <input type="text" name="name" id="name" class="form-control form--control" placeholder="<?php echo app('translator')->get('Name'); ?>" value="<?php echo e(old('name', @$user->fullname)); ?>" required <?php if(@$user): ?> readonly <?php endif; ?>>
                                                <div class="help-block with-errors"></div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo app('translator')->get('Email'); ?></label>
                                                <input type="email" name="email" id="email" class="form-control form--control" placeholder="<?php echo app('translator')->get('Email'); ?>" value="<?php echo e(old('email', @$user->email)); ?>"required <?php if(@$user): ?> readonly <?php endif; ?>>
                                                <div class="help-block with-errors"></div>
                                            </div>
                                        </div>

                                        <div class="col-lg-12 col-md-12">
                                            <div class="form-group">
                                                <label class="form-label" for="msg_subject"><?php echo app('translator')->get('Subject'); ?></label>
                                                <input type="text" name="subject" id="msg_subject" class="form-control form--control" placeholder="<?php echo app('translator')->get('Subject'); ?>" required>
                                                <div class="help-block with-errors"></div>
                                            </div>
                                        </div>

                                        <div class="col-lg-12">
                                            <div class="form-group has-error">
                                                <label class="form-label" for="message"><?php echo app('translator')->get('Message'); ?></label>
                                                <textarea name="message" class="form-control form--control" id="message" cols="30" rows="4" placeholder="<?php echo app('translator')->get('Write your message'); ?>" required></textarea>
                                            </div>
                                        </div>

                                        <?php if (isset($component)) { $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Captcha::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\Captcha::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243)): ?>
<?php $component = $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243; ?>
<?php unset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243); ?>
<?php endif; ?>

                                        <div class="col-lg-12 col-md-12">
                                            <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Send Message'); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div class="col-lg-5 ps-lg-4 ps-xl-5">
                            <div class="contacts-info">
                                <img src="<?php echo e(getImage('assets/images/frontend/contact_us/' . @$contact->data_values->image, '350x270')); ?>" class="contact-img mb-4" alt="image">
                                <div class="address row gy-4">
                                    <div class="location col-12">
                                        <div class="contact-card">
                                            <span class="icon"><i class="las la-map-marker"></i></span>
                                            <span><?php echo e(__(@$contact->data_values->contact_details)); ?></span>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="contact-card">
                                            <span class="icon"><i class="las la-phone-volume"></i></span>
                                            <a href="tel:<?php echo e(@$contact->data_values->contact_number_one); ?>"><?php echo e(@$contact->data_values->contact_number_one); ?></a>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="contact-card">
                                            <span class="icon"><i class="las la-envelope-open"></i></span>
                                            <a href="mailto:<?php echo e(@$contact->data_values->email_address); ?>"><?php echo e(__(@$contact->data_values->email_address)); ?></a>
                                        </div>
                                    </div>
                                </div>

                                <div class="footer-widget">
                                    <ul class="social-links d-flex align-items-center mt-4 flex-wrap pt-2">
                                        <li>
                                            <h6 class="fs--15px me-2"><?php echo app('translator')->get('Social'); ?>:</h6>
                                        </li>
                                        <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="me-2">
                                                <a href="<?php echo e(@$social->data_values->url); ?>" target="_blank">
                                                    <?php
                                                        echo @$social->data_values->social_icon;
                                                    ?>
                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="map-area">
        <div class="map-wrap">
            <iframe src="https://maps.google.com/maps?q=<?php echo e(@$contact->data_values->latitude); ?>,<?php echo e(@$contact->data_values->longitude); ?>&hl=es;z=14&amp;output=embed"></iframe>
        </div>
    </div>

    <?php if($sections->secs != null): ?>
        <?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make($activeTemplate . 'sections.' . $sec, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/infu.nibiru-it.ro/public_html/core/resources/views/templates/basic/contact.blade.php ENDPATH**/ ?>