<!-- meta tags and other links -->
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($general->siteName(__(isset($customPageTitle) ? $customPageTitle : $pageTitle))); ?></title>
    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <link rel="icon" type="image/png" href="<?php echo e(getImage(getFilePath('logoIcon') . '/favicon.png', '?' . time())); ?>"
        sizes="16x16">
    <link rel="stylesheet" href="<?php echo e(asset('theme/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('theme/css/jquery-ui.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('theme/css/ace-responsive-menu.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('theme/css/menu.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('theme/css/fontawesome.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('theme/css/flaticon.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('theme/css/bootstrap-select.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('theme/css/animate.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('theme/css/slider.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('theme/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('theme/css/ud-custom-spacing.css')); ?>">
    <!-- Responsive stylesheet -->
    <link rel="stylesheet" href="<?php echo e(asset('theme/css/responsive.css')); ?>">


    <?php echo $__env->yieldPushContent('style-lib'); ?>

    <?php echo $__env->yieldPushContent('style'); ?>
    <style>
        .dashboard__sidebar {
            margin-top: 0px !important;
        }

        .dashboard__main {
            margin-top: 0px;
        }

        .ace-responsive-menu>li>a {

            text-transform: unset !important;
        }

        .ace-responsive-menu>li>a:hover {
            color: #2f743e;
        }

        a.login-info {
            border-radius: 100px;
            padding: 5px 10px;
            /* border: 1px solid #000; */
        }

        a.logo1 img {
            max-width: 100px !important;
            max-height: 100px !important;
        }

        a.mobile_logo img {
            max-width: 150px !important;
            max-height: 70px !important;
        }
    </style>
</head>

<body>
    <div class="wrapper ovh">
        <div class="preloader"></div>

        <!-- Main Header Nav -->


        <div class="hiddenbar-body-ovelay"></div>

        <div id="page" class="mobilie_header_nav stylehome1">
            <div class="mobile-menu">
                <div class="header bdrb1">
                    <div class="menu_and_widgets">
                        <div class="row p-0">
                            <div class="col-3">
                                <a class="mobile_logo" href="/">
                                    <img src="<?php echo e(asset('assets/SolveetIcon.png')); ?>" alt="Header Logo">
                                </a>
                            </div>
                            <div class="col-6 p-0 d-flex justify-content-center">
                                <a class="mobile_logo" href="/">
                                    <img src="<?php echo e(asset('assets/SolveetText.png')); ?>" alt="Header Logo">
                                </a>
                            </div>
                            <div class="col-3">
                                <div class="right-side text-end">
                                    
                                    <a class="menubar ml30" href="#menu"><img
                                            src="<?php echo e(asset('theme/images/mobile-dark-nav-icon.svg')); ?>"
                                            alt=""></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="posr">
                        <div class="mobile_menu_close_btn"><span class="far fa-times"></span></div>
                    </div>
                </div>
            </div>
            <!-- /.mobile-menu -->
            <nav id="menu" class="">
                <?php if(!empty(authInfluencer())): ?>
                    <?php echo $__env->make($activeTemplate . 'influencer.mobileMenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php else: ?>
                    <?php echo $__env->make($activeTemplate . 'user.mobileMenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                
            </nav>
        </div>


        <?php echo $__env->yieldPushContent('fbComment'); ?>



        <?php echo $__env->yieldContent('app'); ?>

        <?php
            $cookie = App\Models\Frontend::where('data_keys', 'cookie.data')->first();
        ?>
        <?php if($cookie->data_values->status == 1 && !\Cookie::get('gdpr_cookie')): ?>
            <div class="cookies-card text-center hide">
                <div class="cookies-card__icon bg--base">
                    <i class="las la-cookie-bite"></i>
                </div>
                <p class="mt-4 cookies-card__content"><?php echo e($cookie->data_values->short_desc); ?>

                    <a href="<?php echo e(route('cookie.policy')); ?>" target="_blank" class="text--base"><?php echo app('translator')->get('learn more'); ?></a>
                </p>
                <div class="cookies-card__btn mt-4">
                    <a href="javascript:void(0)" class="btn btn--base w-100 policy"><?php echo app('translator')->get('Allow'); ?></a>
                </div>
            </div>
        <?php endif; ?>


        
        <a class="scrollToHome at-home2" href="#"><i class="fas fa-angle-up"></i></a>
    </div>
    <!-- Wrapper End -->
    <script src="<?php echo e(asset('theme/js/jquery-3.6.4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/js/jquery-migrate-3.0.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/js/bootstrap-select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/js/jquery.mmenu.all.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/js/ace-responsive-menu.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/js/jquery-scrolltofixed-min.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/js/wow.min.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/js/owl.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/js/scrollbalance.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/js/jquery.counterup.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/js/pricing-table.js')); ?>"></script>
    
    <!-- Custom script for all pages -->
    <script src="<?php echo e(asset('theme/js/script.js')); ?>"></script>


    <?php echo $__env->yieldPushContent('script-lib'); ?>

    <?php echo $__env->yieldPushContent('script'); ?>

    <?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('partials.plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <!-- Pluglin Link -->
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/lib/slick.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/lib/magnific-popup.min.js')); ?>"></script>

    <!-- Main js -->
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/lib/chart.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/nicEdit.js')); ?>"></script>

    <script src="<?php echo e(asset($activeTemplateTrue . 'js/main.js')); ?>"></script>

    <script>
        bkLib.onDomLoaded(function() {
            $(".nicEdit").each(function(index) {
                $(this).attr("id", "nicEditor" + index);
                new nicEditor({
                    fullPanel: true
                }).panelInstance('nicEditor' + index, {
                    hasPanel: true
                });
            });
        });
        (function($) {
            "use strict";
            $(".langSel").on("change", function() {
                window.location.href = "<?php echo e(route('home')); ?>/change/" + $(this).val();
            });

            $('.policy').on('click', function() {
                $.get('<?php echo e(route('cookie.accept')); ?>', function(response) {
                    $('.cookies-card').addClass('d-none');
                });
            });

            setTimeout(function() {
                $('.cookies-card').removeClass('hide')
            }, 2000);

            var inputElements = $('[type=text],select,textarea');
            $.each(inputElements, function(index, element) {
                element = $(element);
                element.closest('.form-group').find('label').attr('for', element.attr('name'));
                element.attr('id', element.attr('name'))
            });

            $.each($('input, select, textarea'), function(i, element) {

                if (element.hasAttribute('required')) {
                    $(element).closest('.form-group').find('label').addClass('required');
                }

            });

            $('.showFilterBtn').on('click', function() {
                $('.responsive-filter-card').slideToggle();
            });

            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });

            // Sticky Menu
            let logo = `<?php echo e(getImage(getFilePath('logoIcon') . '/logo.png')); ?>`;
            let logoDark = `<?php echo e(getImage(getFilePath('logoIcon') . '/logo_dark.png')); ?>`;
            window.addEventListener("scroll", function() {
                var header = document.querySelector(".header");
                header.classList.toggle("sticky", window.scrollY > 0);

                if ($('.header').hasClass('dash-header')) {
                    $('.header .logo img').attr('src', logoDark);
                } else {

                    if ($('.header').hasClass('sticky')) {
                        $('.header .logo img').attr('src', logoDark)
                    } else {
                        $('.header .logo img').attr('src', logo);
                    }
                }
            });

        })(jQuery);
    </script>



</body>

</html>
<?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/layouts/appdashboard.blade.php ENDPATH**/ ?>