
<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th><?php echo app('translator')->get('S.N.'); ?></th>
                                <th><?php echo app('translator')->get('Name'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo app('translator')->get('S.N.'); ?>"><?php echo e($categories->firstItem() + $loop->index); ?></td>
                                <td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e(__($category->name)); ?></td>
                                <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                    <?php if($category->status == 1): ?>
                                        <span class="text--small badge font-weight-normal badge--success"><?php echo app('translator')->get('Enabled'); ?></span>
                                    <?php else: ?>
                                        <span class="text--small badge font-weight-normal badge--danger"><?php echo app('translator')->get('Disabled'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                    <button class="btn btn-sm btn-outline--primary editButton" data-id="<?php echo e($category->id); ?>" data-name="<?php echo e($category->name); ?>" data-status="<?php echo e($category->status); ?>" data-image="<?php echo e(getImage(getFilePath('category').'/'.$category->image, getFileSize('category'))); ?>">
                                        <i class="la la-pencil"></i> <?php echo app('translator')->get('Edit'); ?>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($categories->hasPages()): ?>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($categories)); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="modal fade" id="categoryModal" tabindex="-1" role="dialog" aria-labelledby="createModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="createModalLabel"></h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><i class="las la-times"></i></button>
                </div>
                <form class="form-horizontal" method="post" action="" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Name'); ?></label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" value="<?php echo e(old('name')); ?>" name="name" required>
                            </div>
                        </div>
                        <div class="row form-group">
                            <label><?php echo app('translator')->get('Image'); ?><span class="text--danger">*</span></label>
                            <div class="col-sm-12">
                                <div class="image-upload">
                                    <div class="thumb">
                                        <div class="avatar-preview">
                                            <div class="profilePicPreview" style="background-image: url(<?php echo e(getImage('/',getFileSize('category'))); ?>)">
                                                <button type="button" class="remove-image"><i class="fa fa-times"></i></button>
                                            </div>
                                        </div>
                                        <div class="avatar-edit">
                                            <input type="file" class="profilePicUpload" name="image" id="profilePicUpload1" accept=".png, .jpg, .jpeg">
                                            <label for="profilePicUpload1" class="bg--primary"><?php echo app('translator')->get('Upload Image'); ?></label>
                                            <small class="mt-2 text-facebook"><?php echo app('translator')->get('Supported files'); ?>:
                                                <b><?php echo app('translator')->get('jpeg'); ?>, <?php echo app('translator')->get('jpg'); ?>, <?php echo app('translator')->get('png'); ?>.</b>
                                                <?php echo app('translator')->get('Image will be resized into '); ?><?php echo e(getFileSize('category')); ?> <?php echo app('translator')->get('px'); ?>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group status">
                            <label><?php echo app('translator')->get('Status'); ?></label>
                            <div class="col-sm-12">
                                <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Enable'); ?>" data-off="<?php echo app('translator')->get('Disable'); ?>" name="status">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45" id="btn-save" value="add"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<div class="d-flex flex-colum flex-wrap gap-2 justify-content-end align-items-center">
    <button class="btn btn-lg btn-outline--primary createButton"><i class="las la-plus"></i><?php echo app('translator')->get('Add New'); ?></button>

    <form action="" method="GET" class="form-inline float-sm-end">
        <div class="input-group justify-content-end">
            <input type="text" name="search" class="form-control bg--white" placeholder="<?php echo app('translator')->get('Name'); ?>" value="<?php echo e(request()->search); ?>">
            <button class="btn btn--primary input-group-text" type="submit"><i class="fa fa-search"></i></button>
        </div>
    </form>
</div>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    (function($) {
            "use strict"

            let modal = $('#categoryModal');
            $('.createButton').on('click', function() {
                modal.find('.modal-title').text(`<?php echo app('translator')->get('Add New Category'); ?>`);
                modal.find('.status').addClass('d-none');
                modal.find('form').attr('action', `<?php echo e(route('admin.category.store','')); ?>`);
                modal.modal('show');
            });

            $('.editButton').on('click', function() {
                modal.find('form').attr('action', `<?php echo e(route('admin.category.store','')); ?>/${$(this).data('id')}`);
                modal.find('.modal-title').text(`<?php echo app('translator')->get('Update Category'); ?>`);
                modal.find('[name=name]').val($(this).data('name'));
                modal.find('.status').removeClass('d-none');
                modal.find('.profilePicPreview').attr('style', `background-image: url(${$(this).data('image')})`);

                if ($(this).data('status') == 1) {
                    modal.find('input[name=status]').bootstrapToggle('on');
                } else {
                    modal.find('input[name=status]').bootstrapToggle('off');
                }
                modal.modal('show')
            });
            var defautlImage = `<?php echo e(getImage(getFilePath('category'), getFileSize('category'))); ?>`;

            modal.on('hidden.bs.modal', function () {
                modal.find('.profilePicPreview').attr('style', `background-image: url(${defautlImage})`);
                $('#categoryModal form')[0].reset();
            });

        })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/infu.nibiru-it.ro/public_html/core/resources/views/admin/category/index.blade.php ENDPATH**/ ?>