<?php
    $kycContent = getContent('influencer_kyc.content', true);
?>

<?php $__env->startSection('content'); ?>
    <?php if(authInfluencer()->kv == 0): ?>
        <div class="alert alert-info" role="alert">
            <h4 class="alert-heading"><?php echo app('translator')->get('KYC Verification required'); ?></h4>
            <hr>
            <p class="mb-0"><?php echo e(__($kycContent->data_values->verification_content)); ?>

                <a href="<?php echo e(route('influencer.kyc.form')); ?>" class="text--base"><?php echo app('translator')->get('Click Here to Verify'); ?></a>
            </p>
        </div>
    <?php elseif(authInfluencer()->kv == 2): ?>
        <div class="alert alert-warning" role="alert">
            <h4 class="alert-heading"><?php echo app('translator')->get('KYC Verification pending'); ?></h4>
            <hr>
            <p class="mb-0"><?php echo e(__($kycContent->data_values->pending_content)); ?>

                <a href="<?php echo e(route('influencer.kyc.data')); ?>" class="text--base"><?php echo app('translator')->get('See KYC Data'); ?></a>
            </p>
        </div>
    <?php endif; ?>
    <div class="wrapper">
        <div class="preloader"></div>

        <!-- Main Header Nav -->
        
        <!-- Search Modal -->
        

        <!-- Mobile Nav  -->
        

        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    <?php echo $__env->make($activeTemplate . 'influencer.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <div class="row pb40">
                            
                            <div class="col-lg-9">
                                <div class="dashboard_title_area">
                                    <h2>Programări</h2>
                                    
                                </div>
                            </div>
                            
                        </div>
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                    <div class="navtab-style1">
                                        <nav>
                                            <div class="nav nav-tabs mb30" id="nav-tab2" role="tablist">
                                                <button class="nav-link fw500 <?php echo e(menuActive('influencer.hiring.index')); ?>"
                                                    id="nav-item1-tab" data-bs-toggle="tab" data-bs-target="#nav-item1"
                                                    type="button" role="tab" aria-controls="nav-item1"
                                                    aria-selected="true">Toate</button>
                                                <button
                                                    class="nav-link fw500 <?php echo e(menuActive('influencer.hiring.pending')); ?>') }}"
                                                    id="nav-item2-tab" data-bs-toggle="tab" data-bs-target="#nav-item2"
                                                    type="button" role="tab" aria-controls="nav-item2"
                                                    aria-selected="false">În așteptare</button>
                                                <button
                                                    class="nav-link fw500 <?php echo e(menuActive('influencer.hiring.completed')); ?>"
                                                    id="nav-item3-tab" data-bs-toggle="tab" data-bs-target="#nav-item3"
                                                    type="button" role="tab" aria-controls="nav-item3"
                                                    aria-selected="false">Finalizat</button>
                                                <button    
                                                    class="nav-link fw500 <?php echo e(menuActive('influencer.hiring.cancelled')); ?>"
                                                    id="nav-item4-tab" data-bs-toggle="tab" data-bs-target="#nav-item4"
                                                    type="button" role="tab" aria-controls="nav-item4"
                                                    aria-selected="false">Refuzat</button>    
                                            </div>
                                        </nav>
                                        <div class="tab-content" id="nav-tabContent">
                                            <div class="tab-pane fade show active" id="nav-item1" role="tabpanel"
                                                aria-labelledby="nav-item1-tab">
                                                <div class="packages_table table-responsive">
                                                    <table class="table-style3 table at-savesearch">
                                                        <thead class="t-head">
                                                            <tr>
                                                                <th scope="col">ID</th>
                                                                <th scope="col">Utilizator</th>
                                                                <th scope="col">Preț | Dată</th>
                                                                <?php if(request()->routeIs('influencer.hiring.index')): ?>
                                                                    <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                                                <?php endif; ?>
                                                                <th scope="col">Acțiuni</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="t-body">
                                                            <?php $__currentLoopData = $hirings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiring): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <tr>
                                                                    <th class="dashboard-img-service" scope="row">
                                                                        
                                                                        <div class="list-content flex-grow-1 py-0">
                                                                            <h6 class="list-title mb-0"><a
                                                                                    href="page-services-single.html"><?php echo e($hiring->hiring_no); ?></a>
                                                                            </h6>
                                                                        </div>
                                                                    </th>
                                                                    <td class="align-top"><span
                                                                            class="fz15 fw400"><?php echo e(__(@$hiring->user->username)); ?></span>
                                                                    </td>
                                                                    <td class="align-top"><span
                                                                            class="fz14 fw400"><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($hiring->amount)); ?></span><br>
                                                                            <?php echo e($hiring->delivery_date); ?>

                                                                    </td>
                                                                    <?php if(request()->routeIs('influencer.hiring.index')): ?>
                                                                        <td class="align-top">
                                                                            <div class="d-flex align-items-center">
                                                                                <?php echo $hiring->statusBadge ?>
                                                                            </div>
                                                                        </td>
                                                                    <?php endif; ?>
                                                                    <td class="align-top">
                                                                        <div class="d-flex">
                                                                            <a href="<?php echo e(route('influencer.hiring.detail',$hiring->id)); ?>" class="icon me-2"
                                                                                data-bs-toggle="tooltip"
                                                                                data-bs-placement="top"
                                                                                title="Detalii"><span
                                                                                    class="flaticon-eye"></span></a>
                                                                            <a href="<?php echo e(route('influencer.hiring.conversation.view',$hiring->id)); ?>" class="icon"
                                                                                data-bs-toggle="tooltip"
                                                                                data-bs-placement="top"
                                                                                title="Chat"><span class="flaticon-sms"></span></a>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                    <?php echo e($hirings->links()); ?>

                                                        
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        </footer>
                    </div>
                </div>
            </div>
            <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
        </div>

    <?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/influencer/hiring/list2.blade.php ENDPATH**/ ?>