<?php $__env->startSection('content'); ?>
    <div class="wrapper">
        <div class="preloader"></div>
        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    <?php echo $__env->make($activeTemplate . 'user.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <div class="row pb40">
                            <div class="col-lg-12">
                                <div class="dashboard_title_area">
                                    <h2>Adauga Fonduri</h2>
                                    
                                </div>
                            </div>
                            
                        </div>
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                    <div class="card-body">
                                        <form action="<?php echo e(route('user.deposit.insert')); ?>" method="post"
                                            class="from row gy-2">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="method_code">
                                            <input type="hidden" name="currency">
                                            <div class="form-group">
                                                <label class="form-label"><?php echo app('translator')->get('Selectează metoda de depunere'); ?></label>
                                                <select class="form-control form--control form-select" name="gateway"
                                                    required>
                                                    <option value=""><?php echo app('translator')->get('Selectează metoda de depunere'); ?></option>
                                                    <?php $__currentLoopData = $gatewayCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($data->method_code); ?>"
                                                            <?php if(old('gateway') == $data->method_code): echo 'selected'; endif; ?> selected data-gateway="<?php echo e($data); ?>">
                                                            <?php echo e($data->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label"><?php echo app('translator')->get('Suma'); ?></label>
                                                <div class="input-group">
                                                    <input type="number" step="any" name="amount"
                                                        value="<?php echo e(old('amount', @$amount)); ?>" <?php if(isset($amount)): ?> readonly <?php endif; ?> class="form-control form--control"
                                                        required>
                                                    <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                                                </div>
                                            </div>
                                            
                                            <div class="preview-details d-none my-3">
                                                <ul class="list-group-flush text-center">
                                                    <li class="list-group-item d-flex justify-content-between">
                                                        <span><?php echo app('translator')->get('Limită'); ?></span>
                                                        <span><span class="min fw-bold">0</span>
                                                            <?php echo e(__($general->cur_text)); ?> - <span
                                                                class="max fw-bold">0</span>
                                                            <?php echo e(__($general->cur_text)); ?></span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between">
                                                        <span><?php echo app('translator')->get('Comision'); ?></span>
                                                        <span><span class="charge fw-bold">0</span>
                                                            <?php echo e(__($general->cur_text)); ?></span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between">
                                                        <span><?php echo app('translator')->get('Suma depusă'); ?></span> <span><span
                                                                class="receivable fw-bold"> 0</span>
                                                            <?php echo e(__($general->cur_text)); ?> </span>
                                                    </li>
                                                    <li class="list-group-item d-none justify-content-between rate-element">

                                                    </li>
                                                    <li class="list-group-item justify-content-between d-none in-site-cur">
                                                        <span><?php echo app('translator')->get('Total in'); ?> <span class="base-currency"></span></span>
                                                        <span class="final_amo fw-bold">0</span>
                                                    </li>
                                                    <li class="list-group-item d-none justify-content-between in-site-cur">
                                                        <span><?php echo app('translator')->get('Conversion with'); ?> <span class="method_currency"></span> <?php echo app('translator')->get('and final value will Show on next step'); ?></span>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div
                                                style="align-items: center; display: flex; justify-content: space-between; flex-direction: column; margin-top: 20px;">
                                                <button type="submit"
                                                    class="ud-btn btn-dark default-box-shadow2 w100"><?php echo app('translator')->get('Depune'); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    </footer>
                </div>
            </div>
        </div>
        <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('select[name=gateway]').change(function() {
                if (!$('select[name=gateway]').val()) {
                    $('.preview-details').addClass('d-none');
                    return false;
                }
                var resource = $('select[name=gateway] option:selected').data('gateway');
                var fixed_charge = parseFloat(resource.fixed_charge);
                var percent_charge = parseFloat(resource.percent_charge);
                var rate = parseFloat(resource.rate)
                if (resource.method.crypto == 1) {
                    var toFixedDigit = 8;
                    $('.crypto_currency').removeClass('d-none');
                } else {
                    var toFixedDigit = 2;
                    $('.crypto_currency').addClass('d-none');
                }
                $('.min').text(parseFloat(resource.min_amount).toFixed(2));
                $('.max').text(parseFloat(resource.max_amount).toFixed(2));
                var amount = parseFloat($('input[name=amount]').val());
                if (!amount) {
                    amount = 0;
                }
                if (amount <= 0) {
                    $('.preview-details').addClass('d-none');
                    return false;
                }
                $('.preview-details').removeClass('d-none');
                var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
                $('.charge').text(charge);
                var payable = parseFloat((parseFloat(amount) + parseFloat(charge))).toFixed(2);
                $('.payable').text(payable);
                var final_amo = (parseFloat((parseFloat(amount) + parseFloat(charge))) * rate).toFixed(
                    toFixedDigit);
                $('.final_amo').text(final_amo);
                if (resource.currency != '<?php echo e($general->cur_text); ?>') {
                    var rateElement =
                        `<span><?php echo app('translator')->get('Conversion Rate'); ?></span> <span><span  class="fw-bold">1 <?php echo e(__($general->cur_text)); ?> = <span class="rate">${rate}</span>  <span class="base-currency">${resource.currency}</span></span></span>`;
                    $('.rate-element').html(rateElement)
                    $('.rate-element').removeClass('d-none');
                    $('.in-site-cur').removeClass('d-none');
                    $('.rate-element').addClass('d-flex');
                    $('.in-site-cur').addClass('d-flex');
                } else {
                    $('.rate-element').html('')
                    $('.rate-element').addClass('d-none');
                    $('.in-site-cur').addClass('d-none');
                    $('.rate-element').removeClass('d-flex');
                    $('.in-site-cur').removeClass('d-flex');
                }
                $('.base-currency').text(resource.currency);
                $('.method_currency').text(resource.currency);
                $('input[name=currency]').val(resource.currency);
                $('input[name=method_code]').val(resource.method_code);
                $('input[name=amount]').on('input');
            });
            $('input[name=amount]').on('input', function() {
                $('select[name=gateway]').change();
                $('.amount').text(parseFloat($(this).val()).toFixed(2));
            });
        })(jQuery);


        // on load we will trigger the change event
        // to show the default selected gateway
        $(document).ready(function() {
            $('select[name=gateway]').change();
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/user/payment/deposit2.blade.php ENDPATH**/ ?>