<?php
    $kycContent = getContent('influencer_kyc.content', true);
?>

<?php $__env->startSection('content'); ?>
    <style>
        .day-section {
            margin-bottom: 2rem;
        }

        .interval-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 6px;
        }

        .toggle-btn {
            padding: 6px 10px;
            font-size: 0.8rem;
        }

        .toggle-btn.active {
            background-color: #0d6efd;
            color: white;
        }
    </style>
    <?php if(authInfluencer()->kv == 0): ?>
        <div class="alert alert-info" role="alert">
            <h4 class="alert-heading"><?php echo app('translator')->get('KYC Verification required'); ?></h4>
            <hr>
            <p class="mb-0"><?php echo e(__($kycContent->data_values->verification_content)); ?>

                <a href="<?php echo e(route('influencer.kyc.form')); ?>" class="text--base"><?php echo app('translator')->get('Click Here to Verify'); ?></a>
            </p>
        </div>
    <?php elseif(authInfluencer()->kv == 2): ?>
        <div class="alert alert-warning" role="alert">
            <h4 class="alert-heading"><?php echo app('translator')->get('KYC Verification pending'); ?></h4>
            <hr>
            <p class="mb-0"><?php echo e(__($kycContent->data_values->pending_content)); ?>

                <a href="<?php echo e(route('influencer.kyc.data')); ?>" class="text--base"><?php echo app('translator')->get('See KYC Data'); ?></a>
            </p>
        </div>
    <?php endif; ?>
    <div class="wrapper">
        <div class="preloader"></div>

        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    <?php echo $__env->make($activeTemplate . 'influencer.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <form action="<?php echo e(route('influencer.service.store', @$service->id)); ?>" method="POST"
                            enctype="multipart/form-data" class="create-service-form">
                            <?php echo csrf_field(); ?>
                            <div class="row pb40">
                                <div class="col-lg-9">
                                    <div class="dashboard_title_area">
                                        <h2>Adaugă Serviciile Oferite</h2>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="text-lg-end">
                                        
                                    </div>
                                </div>
                            </div>
                            <div class="ps-widget bgc-white bdrs12 p30 mb30 overflow-hidden position-relative">
                                <div class="bdrb1 pb15 mb30">
                                    <h5 class="list-title">Imagine</h5>
                                </div>
                                <div class="col-xl-9">
                                    <div class="d-flex mb30">
                                        <div class="d-flex justify-content-center">
                                            <img id="upload-img"
                                                src="<?php if(isset($service)): ?> <?php echo e(getImage(getFilePath('service') . '/thumb_' . $service->image, getFileThumb('service'))); ?><?php else: ?><?php echo e(getImage(getFilePath('service') . '/thumb_' . @$general->default_image, getFileThumb('service'))); ?> <?php endif; ?>"
                                                alt="userProfile" name="userProfileImg"
                                                style="max-height: 200px; max-width: 600px; object-fit: contain;">
                                            <label class="badge badge--icon badge--fill-base update-thumb-icon"
                                                for="update-photo"><i class="las la-pen"></i></label>
                                        </div>
                                        <div class="profile__info">

                                        </div>
                                    </div>
                                    <p class="text">Max file size is 1MB, Minimum dimension: 330x300 And Suitable
                                        files are .jpg & .png</p>

                                    <input type="file" name="image" class="form-control " id="update-photo"
                                        <?php if(!@$service): ?> required <?php endif; ?>>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                        <div class="bdrb1 pb15 mb25">
                                            <h5 class="list-title">Informații Generale</h5>
                                        </div>


                                        <div class="col-xl-12">

                                            <div class="row">
                                                <div class="col-12 col-md-4">
                                                    <div class="mb20">
                                                        <label class="heading-color ff-heading fw500 mb10">Titlu
                                                            Serviciu</label>
                                                        <input type="text" class="form-control" name="title"
                                                            placeholder="ex: Consultanță în Marketing"
                                                            value="<?php echo e(@$service->title ?? ''); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-12 col-md-4">
                                                    <div class="mb20">
                                                        <label class="heading-color ff-heading fw500 mb10">Preț in
                                                            Lei</label>
                                                        <input type="number" class="form-control" placeholder="ex: 100"
                                                            value="<?php echo e(@$service->price ?? ''); ?>" name="price" required
                                                            step="1">
                                                    </div>
                                                </div>
                                                <?php
                                                    if (@$service) {
                                                        $categoryId = $service->category_id;
                                                    } else {
                                                        $categoryId = old('category_id');
                                                    }
                                                ?>
                                                <div class="col-12 col-md-4">
                                                    <div class="mb20">
                                                        <div class="form-style1">
                                                            <label class="heading-color ff-heading fw500 mb10"
                                                                for="category_id"><?php echo app('translator')->get('Categorie'); ?></label>
                                                            <div class="bootselect-multiselect">
                                                                <select class="selectpicker" name="category_id"
                                                                    id="category_id" required>
                                                                    <option value="" selected disabled>
                                                                        <?php echo app('translator')->get('Selectează categoria'); ?></option>
                                                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($category->id); ?>"
                                                                            <?php if($categoryId == $category->id): ?> selected="selected" <?php endif; ?>>
                                                                            <?php echo e(__($category->name)); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                

                                                <div class="col-md-12">
                                                    <div class="mb10">
                                                        <label class="heading-color ff-heading fw500 mb10">Detalii
                                                            Servicii</label>
                                                        <textarea cols="30" rows="6" placeholder="Descriere" name="description"> <?php if(@$service): ?>
<?php echo e(@$service->description); ?>

<?php endif; ?>
</textarea>
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                    <h2 class="mb-4">Setează-ți programul pentru întâlniri</h2>
                                                    <div class="row" id="availabilityForm">
                                                        
                                                        
                                                        <div class="col-6">
                                                            <div class="mb-3">
                                                                <label for="startTime" class="form-label">Durata
                                                                    întâlnirii</label>
                                                                <select class="form-select" name="durata_sedinta"
                                                                    id="duration" required
                                                                    value="<?php echo e(@$service->durata_sedinta ?? ''); ?>">
                                                                    <?php if(isset($service)): ?>
                                                                        <option
                                                                            <?php if($service->durata_sedinta == null): ?> selected <?php endif; ?>>
                                                                            Selectează durata întâlnirii</option>
                                                                        <option
                                                                            <?php if($service->durata_sedinta == 15): ?> selected <?php endif; ?>
                                                                            value="15">15 minute</option>
                                                                        <option
                                                                            <?php if($service->durata_sedinta == 30): ?> selected <?php endif; ?>
                                                                            value="30">30 minute</option>
                                                                        <option
                                                                            <?php if($service->durata_sedinta == 45): ?> selected <?php endif; ?>
                                                                            value="45">45 minute</option>
                                                                        <option
                                                                            <?php if($service->durata_sedinta == 60): ?> selected <?php endif; ?>
                                                                            value="60">1 oră</option>
                                                                    <?php else: ?>
                                                                        <option value="0" selected>Fără întâlnire
                                                                        </option>
                                                                        <option value="15">15 minute</option>
                                                                        <option value="30">30 minute</option>
                                                                        <option value="45">45 minute</option>
                                                                        <option value="60">1 oră</option>
                                                                    <?php endif; ?>

                                                                </select>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="col-6">
                                                            <div class="mb-3">
                                                                <label for="startTime" class="form-label">Pauză
                                                                    între întâlniri</label>
                                                                <select class="form-select" name="durata_pauza"
                                                                    id="pause" required disabled
                                                                    value="<?php echo e(@$service->durata_pauza ?? ''); ?>">
                                                                    <?php if(isset($service)): ?>
                                                                        <option
                                                                            <?php if($service->durata_pauza == null): ?> selected <?php endif; ?>>
                                                                            Selectează durata pauzei</option>
                                                                        <option
                                                                            <?php if($service->durata_pauza == 15): ?> selected <?php endif; ?>
                                                                            value="15">15 minute</option>
                                                                        <option
                                                                            <?php if($service->durata_pauza == 30): ?> selected <?php endif; ?>
                                                                            value="30">30 minute</option>
                                                                        <option
                                                                            <?php if($service->durata_pauza == 45): ?> selected <?php endif; ?>
                                                                            value="45">45 minute</option>
                                                                        <option
                                                                            <?php if($service->durata_pauza == 60): ?> selected <?php endif; ?>
                                                                            value="60">1 oră</option>
                                                                    <?php else: ?>
                                                                        <option value="0" selected>Fără pauză</option>
                                                                        <option value="15">15 minute</option>
                                                                        <option value="30">30 minute</option>
                                                                        <option value="45">45 minute</option>
                                                                        <option value="60">1 oră</option>
                                                                    <?php endif; ?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div id="scheduleContainer"></div>
                                                        <input type="hidden" name="schedule" id="schedule">
                                                    </div>


                                                    <script>
                                                        const existingSchedule = JSON.parse(<?php echo json_encode($service->schedule ?? 'null', 15, 512) ?>);

                                                        const days = ['Luni', 'Marți', 'Miercuri', 'Joi', 'Vineri', 'Sâmbătă', 'Duminică'];
                                                        const startHour = 6;
                                                        const endHour = 24;

                                                        var activeDuration = 40;



                                                        var pauseDuration = 0;

                                                        const durationSelect = document.getElementById('duration');
                                                        const pauseSelect = document.getElementById('pause');

                                                        <?php if(isset($service)): ?>
                                                            <?php if($service->durata_sedinta != null): ?>
                                                                activeDuration = parseInt(<?php echo e($service->durata_sedinta); ?>);
                                                            <?php endif; ?>
                                                            <?php if($service->durata_pauza != null): ?>
                                                                pauseDuration = parseInt(<?php echo e($service->durata_pauza); ?>);
                                                            <?php endif; ?>
                                                        <?php endif; ?>


                                                        var intervalDuration = activeDuration + pauseDuration;

                                                        const container = document.getElementById('scheduleContainer');

                                                        function pad(num) {
                                                            return num.toString().padStart(2, '0');
                                                        }

                                                        function formatTime(h, m) {
                                                            return `${pad(h)}:${pad(m)}`;
                                                        }

                                                        function generateIntervals() {
                                                            let intervals = [];
                                                            let h = startHour,
                                                                m = 0;
                                                            while (h < endHour || (h === endHour && m === 0)) {
                                                                let start = formatTime(h, m);
                                                                let endMins = h * 60 + m + activeDuration;
                                                                let endH = Math.floor(endMins / 60);
                                                                let endM = endMins % 60;
                                                                let end = formatTime(endH, endM);
                                                                if (endH >= 24) break;
                                                                intervals.push(`${start} - ${end}`);
                                                                m += intervalDuration;
                                                                while (m >= 60) {
                                                                    m -= 60;
                                                                    h++;
                                                                }
                                                            }
                                                            return intervals;
                                                        }

                                                        function updateSelectedIntervals() {
                                                            const selected = {};
                                                            document.querySelectorAll('.toggle-btn.active').forEach(btn => {
                                                                const day = btn.dataset.day;
                                                                const value = btn.dataset.value;
                                                                if (!selected[day]) selected[day] = [];
                                                                selected[day].push(value);
                                                            });
                                                            console.log('Program selectat:', selected);
                                                            document.getElementById('schedule').value = JSON.stringify(selected);

                                                        }


                                                        <?php if(isset($service)): ?>
                                                            let intervals = generateIntervals();

                                                            days.forEach((day, dayIndex) => {
                                                                let section = document.createElement('div');
                                                                section.className = 'day-section';

                                                                let header = document.createElement('h5');
                                                                header.textContent = day;
                                                                section.appendChild(header);

                                                                let grid = document.createElement('div');
                                                                grid.className = 'interval-grid';

                                                                intervals.forEach((interval, index) => {
                                                                    let btn = document.createElement('button');
                                                                    btn.type = 'button';
                                                                    btn.className = 'btn btn-outline-secondary toggle-btn';
                                                                    btn.textContent = interval;
                                                                    btn.dataset.day = day.toLowerCase();
                                                                    btn.dataset.value = interval;

                                                                    btn.addEventListener('click', function() {
                                                                        btn.classList.toggle('active');
                                                                        btn.classList.toggle('btn-outline-secondary');
                                                                        btn.classList.toggle('btn-primary');
                                                                        updateSelectedIntervals();
                                                                    });

                                                                    grid.appendChild(btn);
                                                                });

                                                                section.appendChild(grid);
                                                                container.appendChild(section);
                                                            });

                                                            // Preselect existing intervals
                                                            if (existingSchedule) {
                                                                Object.keys(existingSchedule).forEach(day => {
                                                                    let selectedIntervals = existingSchedule[day];
                                                                    selectedIntervals.forEach(interval => {
                                                                        let btn = document.querySelector(
                                                                            `.toggle-btn[data-day="${day}"][data-value="${interval}"]`);
                                                                        if (btn) {
                                                                            btn.classList.add('active', 'btn-primary');
                                                                            btn.classList.remove('btn-outline-secondary');
                                                                        }
                                                                    });
                                                                });
                                                                updateSelectedIntervals();
                                                            }
                                                        <?php endif; ?>




                                                        durationSelect.addEventListener('change', function() {
                                                            // Clear previous schedule
                                                            container.innerHTML = '';
                                                            // we unlock the pause select
                                                            pauseSelect.removeAttribute('disabled');
                                                            activeDuration = parseInt(this.value);
                                                            intervalDuration = activeDuration + pauseDuration;


                                                            let intervals = generateIntervals();

                                                            days.forEach((day, dayIndex) => {
                                                                let section = document.createElement('div');
                                                                section.className = 'day-section';

                                                                let header = document.createElement('h5');
                                                                header.textContent = day;
                                                                section.appendChild(header);

                                                                let grid = document.createElement('div');
                                                                grid.className = 'interval-grid';

                                                                intervals.forEach((interval, index) => {
                                                                    let btn = document.createElement('button');
                                                                    btn.type = 'button';
                                                                    btn.className = 'btn btn-outline-secondary toggle-btn';
                                                                    btn.textContent = interval;
                                                                    btn.dataset.day = day.toLowerCase();
                                                                    btn.dataset.value = interval;

                                                                    btn.addEventListener('click', function() {
                                                                        btn.classList.toggle('active');
                                                                        btn.classList.toggle('btn-outline-secondary');
                                                                        btn.classList.toggle('btn-primary');
                                                                        updateSelectedIntervals();
                                                                    });

                                                                    grid.appendChild(btn);
                                                                });

                                                                section.appendChild(grid);
                                                                container.appendChild(section);
                                                            });

                                                            // Preselect existing intervals
                                                            if (existingSchedule) {
                                                                Object.keys(existingSchedule).forEach(day => {
                                                                    let selectedIntervals = existingSchedule[day];
                                                                    selectedIntervals.forEach(interval => {
                                                                        let btn = document.querySelector(
                                                                            `.toggle-btn[data-day="${day}"][data-value="${interval}"]`);
                                                                        if (btn) {
                                                                            btn.classList.add('active', 'btn-primary');
                                                                            btn.classList.remove('btn-outline-secondary');
                                                                        }
                                                                    });
                                                                });
                                                                updateSelectedIntervals();
                                                            }
                                                        });

                                                        // pause duration
                                                        pauseSelect.addEventListener('change', function() {
                                                            // Clear previous schedule
                                                            container.innerHTML = '';
                                                            // we unlock the pause select
                                                            pauseSelect.removeAttribute('disabled');
                                                            activeDuration = parseInt(durationSelect.value);
                                                            pauseDuration = parseInt(this.value);
                                                            intervalDuration = activeDuration + pauseDuration;


                                                            let intervals = generateIntervals();

                                                            days.forEach((day, dayIndex) => {
                                                                let section = document.createElement('div');
                                                                section.className = 'day-section';

                                                                let header = document.createElement('h5');
                                                                header.textContent = day;
                                                                section.appendChild(header);

                                                                let grid = document.createElement('div');
                                                                grid.className = 'interval-grid';

                                                                intervals.forEach((interval, index) => {
                                                                    let btn = document.createElement('button');
                                                                    btn.type = 'button';
                                                                    btn.className = 'btn btn-outline-secondary toggle-btn';
                                                                    btn.textContent = interval;
                                                                    btn.dataset.day = day.toLowerCase();
                                                                    btn.dataset.value = interval;

                                                                    btn.addEventListener('click', function() {
                                                                        btn.classList.toggle('active');
                                                                        btn.classList.toggle('btn-outline-secondary');
                                                                        btn.classList.toggle('btn-primary');
                                                                        updateSelectedIntervals();
                                                                    });

                                                                    grid.appendChild(btn);
                                                                });

                                                                section.appendChild(grid);
                                                                container.appendChild(section);
                                                            });

                                                            // Preselect existing intervals
                                                            if (existingSchedule) {
                                                                Object.keys(existingSchedule).forEach(day => {
                                                                    let selectedIntervals = existingSchedule[day];
                                                                    selectedIntervals.forEach(interval => {
                                                                        let btn = document.querySelector(
                                                                            `.toggle-btn[data-day="${day}"][data-value="${interval}"]`);
                                                                        if (btn) {
                                                                            btn.classList.add('active', 'btn-primary');
                                                                            btn.classList.remove('btn-outline-secondary');
                                                                        }
                                                                    });
                                                                });
                                                                updateSelectedIntervals();
                                                            }
                                                        });
                                                    </script>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="text-start">
                                                        <button type="submit" class="ud-btn btn-thm">Posteaza<i
                                                                class="fal fa-arrow-right-long"></i></a>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    </div>
    <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            const inputField = document.querySelector('#update-photo'),
                uploadImg = document.querySelector('#upload-img');
            inputField.addEventListener('change', function() {
                const file = this.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function() {
                        const result = reader.result;
                        uploadImg.src = result;
                    }
                    reader.readAsDataURL(file);
                }
            });


            <?php if(isset($images)): ?>
                let preloaded = <?php echo json_encode($images, 15, 512) ?>;
            <?php else: ?>
                let preloaded = [];
            <?php endif; ?>

            $('.input-images').imageUploader({
                preloaded: preloaded,
                imagesInputName: 'images',
                preloadedInputName: 'old',
                maxSize: 2 * 1024 * 1024,
            });

            $('.pointBtn').on('click', function() {
                var html = `
                <div class="key-point d-flex gap-2 mb-3">
                    <input type="text" class="form-control form--control" name="key_points[]" required>
                    <button class="btn btn--danger remove-button border-0" type="button"><i class="fas fa-times"></i></button>
                </div>`;
                $('#more-keyPoint').append(html);
            });

            $(document).on('click', '.remove-button', function() {
                $(this).closest('.key-point').remove();
            });


            $(".select2-auto-tokenize").select2({
                tags: true,
                tokenSeparators: [","],
                dropdownParent: $(".skill-body"),
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/influencer/service/create2.blade.php ENDPATH**/ ?>