
<?php $__env->startSection('panel'); ?>
    <div class="row mb-none-30 justify-content-center">
        <div class="col-xl-4 col-md-6 mb-30">
            <div class="card b-radius--10 box--shadow1 overflow-hidden">
                <div class="card-header">
                    <h6><?php echo app('translator')->get('Influencer Information'); ?></h6>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo app('translator')->get('Fullname'); ?>
                            <span class="fw-bold">
                                <a href="<?php echo e(route('admin.influencers.detail', $service->influencer_id)); ?>"><?php echo e(__(@$service->influencer->fullname)); ?></a>
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo app('translator')->get('Username'); ?>
                            <span class="fw-bold">
                                <a href="<?php echo e(route('admin.influencers.detail', $service->influencer_id)); ?>"><?php echo e(__(@$service->influencer->username)); ?></a>
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo app('translator')->get('Email'); ?>
                            <span class="fw-bold"><?php echo e(__(@$service->influencer->email)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo app('translator')->get('Mobile'); ?>
                            <span class="fw-bold"><?php echo e(__(@$service->influencer->mobile)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo app('translator')->get('Country'); ?>
                            <span class="fw-bold"><?php echo e(__(@$service->influencer->address->country)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo app('translator')->get('Balance'); ?>
                            <span class="fw-bold"><?php echo e(showAmount(@$service->influencer->balance)); ?> <?php echo e($general->cur_text); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo app('translator')->get('Created_at'); ?>
                            <span class="fw-bold"><?php echo e(showDateTime($service->created_at)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo app('translator')->get('Status'); ?>
                            <?php echo $service->statusBadge ?>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-xl-8 col-md-6 mb-30">
            <div class="card b-radius--10 box--shadow1 overflow-hidden">
                <div class="card-body">
                    <h5 class="card-title border-bottom mb-3 pb-2"><?php echo app('translator')->get('Service Information'); ?></h5>
                    <div class="row gy-3">
                        <div class="col-md-12">
                            <h6 class="mb-2"><?php echo app('translator')->get('Category'); ?></h6>
                            <p><?php echo e(__(@$service->category->name)); ?></p>
                        </div>
                        <div class="col-md-12">
                            <h6 class="mb-2"><?php echo app('translator')->get('Title'); ?></h6>
                            <p><?php echo e(__($service->title)); ?></p>
                        </div>
                        <div class="col-md-12">
                            <h6 class="mb-2"><?php echo app('translator')->get('Price'); ?></h6>
                            <p><?php echo e(getAmount($service->price)); ?> <?php echo e($general->cur_text); ?></p>
                        </div>
                        <div class="col-md-12">
                            <h6 class="mb-2"><?php echo app('translator')->get('Tags'); ?></h6>
                            <?php $__currentLoopData = $service->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span><?php echo e(__($tag->name)); ?> <?php if(!$loop->last): ?>,<?php endif; ?> </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="col-md-12">
                            <h6 class="mb-2"><?php echo app('translator')->get('Image'); ?></h6>
                            <img src="<?php echo e(getImage(getFilePath('service') . '/' . $service->image, getFileSize('service'))); ?>" alt="" class="w-50">
                        </div>
                        <div class="col-md-12">
                            <h6 class="mb-2"><?php echo app('translator')->get('Description'); ?></h6>
                            <p>
                                <?php echo $service->description ?>
                            </p>
                        </div>
                        <div class="col-md-12">
                            <h6 class="mb-2"><?php echo app('translator')->get('key Point'); ?></h6>
                            <ul>
                                <?php $__currentLoopData = $service->key_points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e(__($point)); ?></li>                                    
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <?php if(@$service->gallery->count()): ?>
                        <div class="col-md-12">
                            <h6 class="mb-2"><?php echo app('translator')->get('Images'); ?></h6>
                            <?php $__currentLoopData = $service->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <img src="<?php echo e(getImage(getFilePath('service') . '/' . $gallery->image, getFileSize('service'))); ?>" alt="" class="w-25 m-2">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php if($service->status == 0): ?>
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <button class="btn btn--success statusBtn" data-status="1" data-id="<?php echo e($service->id); ?>"><i class="fas fa-check"></i>
                                    <?php echo app('translator')->get('Approve'); ?>
                                </button>

                                <button class="btn btn--danger ms-1 statusBtn" data-status="2" data-id="<?php echo e($service->id); ?>"><i class="fas fa-ban"></i>
                                    <?php echo app('translator')->get('Reject'); ?>
                                </button>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    
    <div id="statusModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Confirmation Alert!'); ?></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.service.status')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="status">
                    <div class="modal-body">
                        <p class="modal-detail"></p>
                        <div class="form-group admin-feedback">
                            <label class="fw-bold mt-2"><?php echo app('translator')->get('Reason for Rejection'); ?></label>
                            <textarea name="admin_feedback" maxlength="255" class="form-control" rows="5"><?php echo e(old('admin_feedback')); ?></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-bs-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                        <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Yes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.statusBtn').on('click', function() {
                var modal = $('#statusModal');
                var status = $(this).data('status')
                modal.find('form').attr('action', `<?php echo e(route('admin.service.status', '')); ?>/${$(this).data('id')}`);
                modal.find('[name=status]').val(status);
                if (status == 1) {
                    $('.modal-detail').text(`<?php echo app('translator')->get('Are you sure to approve this service?'); ?>`)
                    $('.admin-feedback').addClass('d-none')
                } else {
                    $('.modal-detail').text(`<?php echo app('translator')->get('Are you sure to reject this service?'); ?>`)
                    $('.admin-feedback').removeClass('d-none')
                }
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/admin/service/detail.blade.php ENDPATH**/ ?>