<?php $__env->startSection('content'); ?>
<div class="pt-80 pb-80">
    <div class="influencer-profile-area">
        <div class="container">
            <div class="influencer-profile-wrapper">
                <div class="d-flex justify-content-between flex-wrap gap-4">
                    <div class="left">
                        <div class="profile">
                            <div class="thumb">
                                <img src="<?php echo e(getImage(getFilePath('influencerProfile') . '/' . $influencer->image, getFileSize('influencerProfile'), true)); ?>" alt="profile thumb">
                            </div>
                            <div class="content">
                                <h5 class="fw-medium name account-status d-inline-block"><?php echo e($influencer->fullname); ?></h5>
                                <h6 class="text--base"> <?php echo e($influencer->username); ?></h6>

                                <span><?php echo app('translator')->get('Profession'); ?>: <i class="title text--small text--muted p-0 m-0"><?php echo e($influencer->profession); ?></i></span>
                                <ul class="list d-flex flex-wrap">
                                    <li><?php echo app('translator')->get('Member Since'); ?>: <?php echo e($influencer->created_at->format('d M Y')); ?></li>
                                    <li>
                                        <div class="rating-wrapper">
                                            <span class="text--warning service-rating">
                                                <?php
                                                echo showRatings($influencer->rating);
                                                ?>
                                                (<?php echo e(getAmount($influencer->total_review)); ?>)
                                            </span>
                                        </div>
                                    </li>
                                </ul>

                                <?php if($influencer->categories): ?>
                                    <?php $__currentLoopData = @$influencer->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="justify-content-between skill-card mt-3">
                                            <span><?php echo e(__(@$category->name)); ?></span>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php if(!authInfluencerId()): ?>
                    <div class="right buttons-wrapper">
                        <a href="<?php echo e(route('user.hiring.request', [slug($influencer->username), $influencer->id])); ?>" class="btn btn--outline-base btn--sm radius-0"><i class="fas fa-user-check"></i>
                            <?php echo app('translator')->get('Hire Me Now'); ?></a>

                        <a href="<?php echo e(route('user.conversation.create', $influencer->id)); ?>" class="btn btn--outline-info btn--sm radius-0"><i class="fas fa-sms"></i> <?php echo app('translator')->get('Contact'); ?></a>
                    </div>
                    <?php endif; ?>
                </div>

                <ul class="info d-flex justify-content-between border-top mt-4 flex-wrap gap-3 pt-4">
                    <li class="d-flex align-items-center gap-2">
                        <h4 class="text--warning d-inline-block"><?php echo e($data['pending_job']); ?></h4>
                        <span><?php echo app('translator')->get('Pending Job'); ?></span>
                    </li>
                    <li class="d-flex align-items-center gap-2">
                        <h4 class="text--base d-inline-block"><?php echo e($data['ongoing_job']); ?></h4>
                        <span><?php echo app('translator')->get('Ongoing Job'); ?></span>
                    </li>
                    <li class="d-flex align-items-center gap-2">
                        <h4 class="text--info d-inline-block"><?php echo e($data['queue_job']); ?></h4>
                        <span><?php echo app('translator')->get('Queue Job'); ?></span>
                    </li>
                    <li class="d-flex align-items-center gap-2">
                        <h4 class="text--success d-inline-block"><?php echo e($data['completed_job']); ?></h4>
                        <span><?php echo app('translator')->get('Completed Job'); ?></span>
                    </li>
                </ul>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="profile-content mt-4">
                        <div class="custom--card">
                            <div class="card-body">
                                <div class="influencer-profile-sidebar">
                                    <h6 class="mb-3"><?php echo app('translator')->get('Description'); ?></h6>
                                    <p>
                                        <?php if($influencer->summary): ?>
                                        <?php
                                        echo $influencer->summary;
                                        ?>
                                        <?php else: ?>
                                        <?php echo app('translator')->get('No summary have been added.'); ?>
                                        <?php endif; ?>
                                    </p>
                                </div>

                                <?php if($influencer->skills): ?>
                                <div class="influencer-profile-sidebar">
                                    <h6 class="mb-3"><?php echo app('translator')->get('Skills'); ?></h6>
                                    <?php $__currentLoopData = $influencer->skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <div class="justify-content-between skill-card my-1">
                                        <span><?php echo e(__(@$skill)); ?></span>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <?php endif; ?>

                                <?php if($influencer->languages): ?>
                                    <?php $__currentLoopData = @$influencer->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$profiencies): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-12 ">
                                        <div class="education-content py-3">
                                            <div class="d-flex justify-content-between align-items-center gap-3">
                                                <h6><?php echo e(__($key)); ?></h6>
                                            </div>
                                            <div class="d-flex flex-wrap gap-2 my-2">
                                                <?php $__currentLoopData = $profiencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$profiency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="skill-card px-2 py-1 rounded">
                                                    <?php echo e(keyToTitle($key)); ?> : <?php echo e($profiency); ?>

                                                </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>

                                <?php if($influencer->education->count() > 0): ?>
                                <div class="influencer-profile-sidebar">
                                    <h6 class="mb-3"><?php echo app('translator')->get('Educations'); ?></h6>
                                    <?php $__currentLoopData = $influencer->education; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $education): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="expertise-content">
                                        <div class="expertise-product">
                                            <div class="expertise-details">
                                                <h6 class="fs--15px mb-1 mt-3"><?php echo e(__($education->degree)); ?>

                                                </h6>
                                                <ul class="experties-meta fs--14px my-1">
                                                    <li class="text-dark">
                                                        <span><?php echo e(__($education->institute)); ?>,
                                                            <?php echo e($education->country); ?></span>
                                                    </li>
                                                </ul>
                                                <ul class="experties-meta fs--14px my-1">
                                                    <li class="text-dark">
                                                        <span><?php echo e(__($education->start_year)); ?> -
                                                            <?php echo e(__($education->end_year)); ?></span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <?php endif; ?>

                                <?php if($influencer->qualification->count() > 0): ?>
                                <div class="influencer-profile-sidebar">
                                    <h6 class="mb-3"><?php echo app('translator')->get('Qualifications'); ?></h6>
                                    <?php $__currentLoopData = $influencer->qualification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $qualification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="expertise-content">
                                        <div class="expertise-product">
                                            <div class="expertise-details">
                                                <h6 class="fs--15px mb-2">
                                                    <?php echo e(__($qualification->certificate)); ?></h6>
                                                <ul class="experties-meta my-1">
                                                    <li class="text-dark">
                                                        <span><?php echo e(__($qualification->organization)); ?>,
                                                            <?php echo e($qualification->year); ?></span>
                                                    </li>
                                                </ul>
                                                <p><?php echo e(__($qualification->summary)); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-9">
                    <?php if($influencer->services->count()): ?>
                    <div class="profile-content mt-4">
                        <h4 class="mb-3"><?php echo app('translator')->get('Services'); ?></h4>
                        <div class="row gy-3">
                            <?php $__currentLoopData = $influencer->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-4 col-xl-4 col-md-6 col-sm-10">
                                <div class="service-item">
                                    <div class="service-item__thumb">
                                        <img src="<?php echo e(getImage(getFilePath('service') . '/thumb_' . $service->image, getFileThumb('service'))); ?>" alt="images">
                                    </div>
                                    <div class="service-item__content">

                                        <div class="d-flex flex-wrap justify-content-between my-1">
                                            <span class="service-rating">
                                                <?php
                                                    echo showRatings(@$service->rating);
                                                ?>
                                                (<?php echo e($service->total_review ?? 0); ?>)
                                            </span>
                                        </div>
                                        <h6 class="title mb-3 mt-2"><a href="<?php echo e(route('service.details', [slug($service->title), $service->id])); ?>"><?php echo e(__(@$service->title)); ?></a></h6>
                                        <div class="service-footer border-top pt-1 d-flex flex-wrap justify-content-between align-items-center">
                                            <span class="fs--14px"><i class="fas fa-tag fs--13px me-1"></i> <?php echo e(__(@$service->category->name)); ?></span>
                                            <h6 class="service-price fs--15px"><small><?php echo e($general->cur_sym); ?></small><?php echo e(showAmount($service->price)); ?></h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php if($reviews->count() > 0): ?>
                    <div class="profile-content mt-5">
                        <div class="custom--card">
                            <div class="card-body">
                                <h4 class="mb-3"><?php echo app('translator')->get('Reviews'); ?></h4>
                                <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="d-flex justify-content-between review-item border-top flex-wrap gap-4 py-3">
                                    <div class="left">
                                        <div class="profile">
                                            <div class="thumb">
                                                <img src="<?php echo e(getImage(getFilePath('userProfile') . '/' . @$review->user->image, getFileSize('userProfile'), true)); ?>" alt="profile thumb">
                                            </div>
                                            <div class="content">
                                                <h6 class="name"><?php echo e(__(@$review->user->fullname)); ?>

                                                </h6>
                                                <ul class="list d-flex fs--13px flex-wrap">
                                                    <li><?php echo e($review->created_at->format('d M Y')); ?></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="right">
                                        <div class="rating-wrapper">
                                            <ul class="rating d-inline-flex">
                                                <?php for($i = 1; $i <= $review->star; $i++): ?>
                                                    <i class="las la-star"></i>
                                                    <?php endfor; ?>

                                                    <?php for($k = 1; $k <= 5 - $review->star; $k++): ?>
                                                        <i class="lar la-star"></i>
                                                        <?php endfor; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <p><?php echo e(__($review->review)); ?></p>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($reviews->links()); ?>

                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
<style>
    .profile .thumb {
        width: 100px;
        height: 100px;
    }
</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/influencer/profile.blade.php ENDPATH**/ ?>