<?php
$kycContent = getContent('client_kyc.content', true);
?>

<?php $__env->startSection('content'); ?>

<?php if(auth()->user()->kv == 0): ?>
<div class="alert alert-info mb-4" role="alert">
    <h4 class="alert-heading"><?php echo app('translator')->get('KYC Verification required'); ?></h4>
    <hr>
    <p class="mb-0"><?php echo e(__($kycContent->data_values->verification_content)); ?><a href="<?php echo e(route('user.kyc.form')); ?>" class="text--base"> &nbsp;<?php echo app('translator')->get('Click Here to Verify'); ?></a></p>
</div>
<?php elseif(auth()->user()->kv == 2): ?>
<div class="alert alert-warning mb-4" role="alert">
    <h4 class="alert-heading"><?php echo app('translator')->get('KYC Verification pending'); ?></h4>
    <hr>
    <p class="mb-0"> <?php echo e(__($kycContent->data_values->pending_content)); ?> <a href="<?php echo e(route('user.kyc.data')); ?>" class="text--base">&nbsp; <?php echo app('translator')->get('See KYC Data'); ?></a></p>
</div>
<?php endif; ?>

<div class="row justify-content-center gy-4">
    <div class="col-xxl-4 col-md-6 col-sm-10">
        <div class="dashboard-widget widget--base">
            <div class="dashboard-widget__icon">
                <i class="las la-money-check"></i>
            </div>
            <div class="dashboard-widget__content">
                <p><?php echo app('translator')->get('Current Balance'); ?></p>
                <h4 class="title"><?php echo e(showAmount($data['current_balance'])); ?> <?php echo e($general->cur_text); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-md-6 col-sm-10">
        <div class="dashboard-widget widget--primary">
            <div class="dashboard-widget__icon">
                <i class="las la-wallet"></i>
            </div>
            <div class="dashboard-widget__content">
                <p><?php echo app('translator')->get('Total Deposited'); ?></p>
                <h4 class="title"><?php echo e(showAmount($data['deposit_amount'])); ?> <?php echo e($general->cur_text); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-md-6 col-sm-10">
        <div class="dashboard-widget widget--secondary">
            <div class="dashboard-widget__icon">
                <i class="las la-exchange-alt"></i>
            </div>
            <div class="dashboard-widget__content">
                <p><?php echo app('translator')->get('Total Transactions'); ?></p>
                <h4 class="title"><?php echo e($data['total_transaction']); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-md-6 col-sm-10">
        <div class="dashboard-widget widget--info">
            <div class="dashboard-widget__icon">
                <i class="las la-list"></i>
            </div>
            <div class="dashboard-widget__content">
                <p><?php echo app('translator')->get('Total Order'); ?></p>
                <h4 class="title"><?php echo e($data['total_order']); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-md-6 col-sm-10">
        <div class="dashboard-widget widget--success">
            <div class="dashboard-widget__icon">
                <i class="lar la-list-alt"></i>
            </div>
            <div class="dashboard-widget__content">
                <p><?php echo app('translator')->get('Completed Order'); ?></p>
                <h4 class="title"><?php echo e($data['complete_order']); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-md-6 col-sm-10">
        <div class="dashboard-widget widget--danger">
            <div class="dashboard-widget__icon">
                <i class="las la-times"></i>
            </div>
            <div class="dashboard-widget__content">
                <p><?php echo app('translator')->get('Incompleted Order'); ?></p>
                <h4 class="title"><?php echo e($data['incomplete_order']); ?></h4>
            </div>
        </div>
    </div>
</div>
<div class="mt-4">
    <h5 class="mb-3"><?php echo app('translator')->get('Latest Transactions'); ?></h5>
    <table class="table table--responsive--lg">
        <thead>
            <tr>
                <th><?php echo app('translator')->get('Trx'); ?></th>
                <th><?php echo app('translator')->get('Transacted'); ?></th>
                <th><?php echo app('translator')->get('Amount'); ?></th>
                <th><?php echo app('translator')->get('Post Balance'); ?></th>
                <th><?php echo app('translator')->get('Detail | Transacted'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td data-label="<?php echo app('translator')->get('Trx'); ?>">
                    <?php echo e($trx->trx); ?>

                </td>

                <td data-label="<?php echo app('translator')->get('Transacted'); ?>">
                    <span><?php echo e(showDateTime($trx->created_at)); ?><br><?php echo e(diffForHumans($trx->created_at)); ?></span>
                </td>


                <td data-label="<?php echo app('translator')->get('Amount'); ?>" class="budget">
                    <span class="fw-bold <?php if($trx->trx_type == '+'): ?> text--success <?php else: ?> text--danger <?php endif; ?>">
                        <?php echo e($trx->trx_type); ?> <?php echo e(showAmount($trx->amount)); ?> <?php echo e($general->cur_text); ?>

                    </span>
                </td>

                <td data-label="<?php echo app('translator')->get('Post Balance'); ?>" class="budget">
                    <?php echo e(showAmount($trx->post_balance)); ?> <?php echo e(__($general->cur_text)); ?>

                </td>

                <td data-label="<?php echo app('translator')->get('Detail'); ?>">
                    <?php echo e(__($trx->details)); ?>

                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td class="justify-content-center text-center" colspan="100%">
                    <i class="la la-4x la-frown"></i>
                    <br>
                    <?php echo e(__($emptyMessage)); ?>

                </td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/user/dashboard.blade.php ENDPATH**/ ?>