<?php $__env->startSection('content'); ?>
    <div class="dashboard-section">
        <div class="container">
            <div class="row gy-4 gy-sm-5">
                <div class="col-lg-12">
                    <div class="dashboard-body">
                        <div class="card custom--card influencer-profile-edit d-none">
                            <div class="card-body has-select2">
                                <form action="" method="post" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <div class="row gy-3">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <div class="profile-thumb text-center">
                                                    <div class="thumb">
                                                        <img id="upload-img" src="<?php echo e(getImage(getFilePath('influencerProfile') . '/' . $influencer->image, getFileSize('influencerProfile'), true)); ?>" alt="userProfile">
                                                        <label class="badge badge--icon badge--fill-base update-thumb-icon" for="update-photo"><i class="las la-pen"></i></label>
                                                    </div>
                                                    <div class="profile__info">
                                                        <input type="file" name="image" class="form-control d-none" id="update-photo">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="row">
                                                <div class="form-group col-sm-6">
                                                    <label for="firstname" class="col-form-label"><?php echo app('translator')->get('First Name'); ?></label>
                                                    <input type="text" class="form-control form--control" id="firstname" name="firstname" value="<?php echo e(__($influencer->firstname)); ?>">
                                                </div>
                                                <div class="form-group col-sm-6">
                                                    <label for="lastname" class="col-form-label"><?php echo app('translator')->get('Last Name'); ?></label>
                                                    <input type="text" class="form-control form--control" id="lastname" name="lastname" value="<?php echo e(__($influencer->lastname)); ?>">
                                                </div>

                                                <div class="form-group col-sm-12">
                                                    <label for="professional-headline" class="col-form-label"><?php echo app('translator')->get('Profession'); ?></label>
                                                    <input type="text" class="form-control form--control" id="professional-headline" name="profession" value="<?php echo e(__($influencer->profession)); ?>">
                                                </div>


                                                <?php
                                                    $categoryId = [];
                                                    foreach (@$influencer->categories as $category) {
                                                        $categoryId[] = $category->id;
                                                    }
                                                ?>

                                                <div class="form-group col-sm-12">
                                                    <label for="professional-headline" class="col-form-label"><?php echo app('translator')->get('Category'); ?></label>
                                                    <select name="category[]" class="from--control form-control select2-multi-select form-select" multiple>

                                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($category->id); ?>" <?php if(in_array($category->id, $categoryId)): ?> selected <?php endif; ?>><?php echo e(__($category->name)); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>

                                                <div class="form-group col-sm-12">
                                                    <label for="summary" class="col-form-label"><?php echo app('translator')->get('Summary'); ?></label>
                                                    <textarea name="summary" id="summary" class="form-control form--control"><?php echo e(br2nl($influencer->summary)); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-12 text-end mt-3">
                                        <button type="button" class="btn btn--dark btn--md cancelBtn"><?php echo app('translator')->get('Cancel'); ?></button>
                                        <button type="submit" class="btn btn--base btn--md"><?php echo app('translator')->get('Submit'); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="influencer-profile-wrapper influencer-profile">
                            <div class="d-flex justify-content-between flex-wrap gap-4">
                                <div class="left">
                                    <div class="profile">
                                        <div class="thumb">
                                            <img src="<?php echo e(getImage(getFilePath('influencerProfile') . '/' . $influencer->image, getFileSize('influencerProfile'), true)); ?>" alt="profile thumb">
                                        </div>
                                        <div class="content">
                                            <h5 class="fw-medium name account-status d-inline-block"><?php echo e(__($influencer->fullname)); ?></h5>
                                            <h3 class="title fw-normal"><?php echo e(__($influencer->profession)); ?></h3>

                                            <ul class="list d-flex flex-wrap">
                                                <li><span><i class="las la-user-alt"></i></span><?php echo e(__($influencer->username)); ?></li>
                                                <li><i class="las la-envelope"></i> <?php echo e(__($influencer->email)); ?></li>
                                            </ul>

                                            <ul class="list d-flex flex-wrap">
                                                <li><?php echo app('translator')->get('Member Since'); ?> <?php echo e($influencer->created_at->format('d M Y')); ?></li>
                                                <li>
                                                    <div class="rating-wrapper">
                                                        <span class="text--warning service-rating">
                                                            <?php
                                                                echo showRatings($influencer->rating);
                                                            ?>
                                                            (<?php echo e(getAmount($influencer->total_review)); ?>)
                                                        </span>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="right">
                                    <button type="button" class="btn--no-border editbtn border-0"> <i class="la la-edit"></i> <?php echo app('translator')->get('Edit'); ?></button>
                                </div>
                            </div>
                            <ul class="info d-flex justify-content-between border-top mt-4 flex-wrap gap-3 pt-4">
                                <li class="d-flex align-items-center gap-2">
                                    <h4 class="text--warning d-inline-block"><?php echo e($data['pending_orders']); ?></h4>
                                    <span><?php echo app('translator')->get('Pending Orders'); ?></span>
                                </li>
                                <li class="d-flex align-items-center gap-2">
                                    <h4 class="text--base d-inline-block"><?php echo e($data['ongoing_orders']); ?></h4>
                                    <span><?php echo app('translator')->get('Ongoing Orders'); ?></span>
                                </li>
                                <li class="d-flex align-items-center gap-2">
                                    <h4 class="text--success d-inline-block"><?php echo e($data['completed_orders']); ?></h4>
                                    <span><?php echo app('translator')->get('Completed Orders'); ?></span>
                                </li>
                                <li class="d-flex align-items-center gap-2">
                                    <h4 class="text--info d-inline-block"><?php echo e($data['total_services']); ?></h4>
                                    <span><?php echo app('translator')->get('Total Services'); ?></span>
                                </li>
                            </ul>

                            <?php if($influencer->categories): ?>
                                <?php $__currentLoopData = @$influencer->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="justify-content-between skill-card mt-3">
                                        <span><?php echo e(__(@$category->name)); ?></span>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <p class="mt-3">
                                <?php if($influencer->summary): ?>
                                    <?php
                                        echo $influencer->summary;
                                    ?>
                                <?php else: ?>
                                    <?php echo app('translator')->get('No summary added yet.'); ?>
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card custom--card skill-edit d-none mt-5">
                <div class="card-header d-flex justify-content-between align-items-center flex-wrap border-none">
                    <h6 class="card-title"><?php echo app('translator')->get('Skills'); ?></h6>
                    <button type="button" class="btn btn--outline-base btn--sm skillBtn"> <i class="la la-plus"></i> <?php echo app('translator')->get('Add New'); ?></button>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('influencer.skill')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div id="skillContainer">
                            <?php if($influencer->skills): ?>
                                <?php $__currentLoopData = $influencer->skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="add-skill d-flex gap-2 mb-2">
                                        <input type="text" name="skills[]" class="form-control form--control" value="<?php echo e($skill); ?>" required />
                                        <button class="btn btn--danger <?php if($loop->first): ?> remove-disable-btn <?php else: ?> remove-btn <?php endif; ?>" type="button"><i class="las la-times"></i></button>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <div class="add-skill d-flex gap-2  mb-2">
                                    <input type="text" name="skills[]" class="form-control form--control" placeholder="<?php echo app('translator')->get('Enter your skill'); ?>" required />
                                    <button class="btn btn--danger remove-disable-btn" type="button"><i class="las la-times"></i></button>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="text-end mt-3">
                            <button type="button" class="btn btn--dark btn--md cancelSkillBtn"><?php echo app('translator')->get('Cancel'); ?></button>
                            <button class="btn btn--base btn--md"><?php echo app('translator')->get('Submit'); ?></button>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card custom--card influencer-skill mt-5">
                <div class="card-header d-flex justify-content-between align-items-center flex-wrap border-none">
                    <h6 class="card-title"><?php echo app('translator')->get('Skills'); ?></h6>
                    <button type="button" class="btn--no-border editSkillbtn border-0"> <i class="la la-edit"></i> <?php echo app('translator')->get('Edit'); ?></button>
                </div>
                <div class="card-body">
                    <?php if($influencer->skills): ?>
                        <?php $__currentLoopData = @$influencer->skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="justify-content-between skill-card my-1">
                                <span><?php echo e(__(@$skill)); ?></span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="justify-content-center noSkill">
                            <span><?php echo app('translator')->get('No skill added yet'); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="card custom--card mt-5">
                <div class="card-header d-flex justify-content-between align-items-center flex-wrap border-none">
                    <h6 class="card-title"><?php echo app('translator')->get('Language'); ?></h6>
                    <button type="button" class="btn btn--outline-base btn--sm languageBtn"> <i class="la la-plus"></i> <?php echo app('translator')->get('Add New'); ?></button>
                </div>
                <div class="card-body py-0">
                    <div class="row">
                        <?php if($influencer->languages): ?>
                            <?php $__currentLoopData = @$influencer->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $profiencies): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-12">
                                    <div class="education-content py-3">
                                        <div class="d-flex justify-content-between align-items-center mb-2 gap-3">
                                            <h6><?php echo e(__($key)); ?></h6>
                                            <div class="d-flex gap-sm-2 gap-1">
                                                <button type="button" class="btn--no-border confirmationBtn border-0" data-action="<?php echo e(route('influencer.language.remove', $key)); ?>" data-question="<?php echo app('translator')->get('Are you sure to removed this language?'); ?>" data-btn_class="btn btn--base btn--md"><span class="text--danger"><i class="las la-trash"></i> <?php echo app('translator')->get('Delete'); ?></span></button>
                                            </div>

                                        </div>
                                        <div class="d-flex my-2 flex-wrap gap-2">
                                            <?php $__currentLoopData = $profiencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $profiency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="me-3 py-1">
                                                    <span class="fw-medium"><?php echo e(keyToTitle($key)); ?></span>: <?php echo e($profiency); ?>

                                                </span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="col-12 py-3">
                                <div class="justify-content-center">
                                    <span><?php echo app('translator')->get('No language added yet'); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>


            <div class="card custom--card mt-5">
                <div class="card-header d-flex justify-content-between align-items-center flex-wrap border-none">
                    <h6 class="card-title"><?php echo app('translator')->get('Social Links'); ?></h6>
                    <button type="button" class="btn btn--outline-base btn--sm socialBtn"><i class="la la-plus"></i> <?php echo app('translator')->get('Add New'); ?></button>
                </div>
                <div class="card-body py-0">
                    <?php $__empty_1 = true; $__currentLoopData = @$influencer->socialLink; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="education-content py-3">
                            <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                                <div class="d-flex flex-wrap">
                                    <span class="text--base me-2"><?php  echo $social->social_icon ?></span>
                                    <span class="text-break"><?php echo e(__($social->url)); ?></span>
                                </div>
                                <div class="d-flex flex-wrap">
                                    <span><?php echo e(__($social->followers)); ?></span>
                                    <span class="ms-2"><?php echo app('translator')->get('Followers'); ?></span>
                                </div>
                                <div class="d-flex gap-sm-2 gap-1">
                                    <button type="button" class="btn--no-border editSocialBtn border-0" data-url="<?php echo e($social->url); ?>" data-social_icon="<?php echo e($social->social_icon); ?>" data-followers="<?php echo e($social->followers); ?>" data-action="<?php echo e(route('influencer.add.socialLink', $social->id)); ?>"><span class="text--base"><i class="lar la-edit"></i> <?php echo app('translator')->get('Edit'); ?></span></button>
                                    <button type="button" class="btn--no-border confirmationBtn border-0" data-action="<?php echo e(route('influencer.remove.socialLink', $social->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to removed this social link?'); ?>" data-btn_class="btn btn--base btn--md"><span class="text--danger"><i class="las la-trash"></i> <?php echo app('translator')->get('Delete'); ?></span></button>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="justify-content-center py-3">
                            <span><?php echo app('translator')->get('No social link added yet'); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="card custom--card mt-5">
                <div class="card-header d-flex justify-content-between align-items-center flex-wrap border-none">
                    <h6 class="card-title"><?php echo app('translator')->get('Education'); ?></h6>
                    <button type="button" class="btn btn--outline-base btn--sm educationBtn"> <i class="la la-plus"></i> <?php echo app('translator')->get('Add New'); ?></button>
                </div>
                <div class="card-body py-0">
                    <?php $__empty_1 = true; $__currentLoopData = @$influencer->education; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $education): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="education-content py-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6><?php echo e(__($education->degree)); ?></h6>
                                <div class="d-flex gap-sm-2 gap-1">

                                    <button type="button" class="btn--no-border editEduBtn border-0" data-degree="<?php echo e($education->degree); ?>" data-institute="<?php echo e($education->institute); ?>" data-country="<?php echo e($education->country); ?>" data-start_year="<?php echo e($education->start_year); ?>" data-end_year="<?php echo e($education->end_year); ?>" data-action="<?php echo e(route('influencer.add.education', $education->id)); ?>"><span class="text--base"><i class="lar la-edit"></i> <?php echo app('translator')->get('Edit'); ?></span></button>

                                    <button type="button" class="btn--no-border confirmationBtn border-0" data-question="<?php echo app('translator')->get('Are you sure to remove this education?'); ?>" data-action="<?php echo e(route('influencer.remove.education', $education->id)); ?>" data-btn_class="btn btn--base btn--md"><span class="text--danger"><i class="las la-trash"></i> <?php echo app('translator')->get('Delete'); ?></span></button>

                                </div>
                            </div>
                            <p>
                                <?php echo e(__($education->institute)); ?>, <span><?php echo e(__($education->country)); ?></span>
                            </p>
                            <p><?php echo e($education->start_year); ?> - <?php echo e($education->end_year); ?></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="justify-content-center py-3">
                            <span><?php echo app('translator')->get('No education added yet'); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="card custom--card mt-5">
                <div class="card-header d-flex justify-content-between align-items-center flex-wrap gap-2 border-none">
                    <h6 class="card-title"><?php echo app('translator')->get('Qualifications'); ?></h6>
                    <button type="button" class="btn btn--outline-base btn--sm qualificationBtn"> <i class="la la-plus"></i> <?php echo app('translator')->get('Add New'); ?></button>
                </div>
                <div class="card-body py-0">
                    <?php $__empty_1 = true; $__currentLoopData = @$influencer->qualification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $qualification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="education-content py-3">
                            <div class="d-flex justify-content-between align-items-center gap-3">
                                <h6><?php echo e(__($qualification->certificate)); ?></h6>
                                <div class="d-flex gap-sm-2 gap-1">

                                    <button type="button" class="btn--no-border editQualifyBtn border-0" data-certificate="<?php echo e($qualification->certificate); ?>" data-organization="<?php echo e($qualification->organization); ?>" data-year="<?php echo e($qualification->year); ?>" data-summary="<?php echo e($qualification->summary); ?>" data-action="<?php echo e(route('influencer.add.qualification', $qualification->id)); ?>"><span class="text--base"><i class="lar la-edit"></i> <?php echo app('translator')->get('Edit'); ?></span></button>

                                    <button type="button" class="btn--no-border confirmationBtn border-0" data-question="<?php echo app('translator')->get('Are you sure to remove this qualification?'); ?>" data-action="<?php echo e(route('influencer.remove.qualification', $qualification->id)); ?>" data-btn_class="btn btn--base btn--md"><span class="text--danger"><i class="las la-trash"></i> <?php echo app('translator')->get('Delete'); ?></span></button>

                                </div>
                            </div>
                            <p class="fw-medium my-2">
                                <?php echo e(__($qualification->organization)); ?>, <span><?php echo e(__($qualification->year)); ?></span>
                            </p>
                            <p><?php echo e($qualification->summary); ?></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="justify-content-center py-3">
                            <span><?php echo app('translator')->get('No qualification added yet'); ?></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div id="socialLinkModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Add New Social Link'); ?></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <form action="" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="skill" class="col-form-label"><?php echo app('translator')->get('Social Icon'); ?></label>
                            <div class="input-group">
                                <input type="text" class="form-control form--control iconPicker icon" autocomplete="off" name="social_icon" required>
                                <span class="input-group-text input-group-addon" data-icon="las la-home" role="iconpicker"></span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="skill" class="col-form-label"><?php echo app('translator')->get('Follower\'s'); ?></label>
                            <div class="input-group">
                                <input type="text" name="followers" class="form-control form--control" value="<?php echo e(old('followers')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="skill" class="col-form-label"><?php echo app('translator')->get('Url'); ?></label>
                            <div class="input-group">
                                <input type="text" name="url" class="form-control form--control" value="<?php echo e(old('url')); ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--base btn--md w-100"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="languageModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Add Language'); ?></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <form action="" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="col-form-label"><?php echo app('translator')->get('Name'); ?></label>
                            <select name="name" class="form-control form--control form-select" required>
                                <option value="" selected disabled><?php echo app('translator')->get('Select One'); ?></option>
                                <?php $__currentLoopData = $languageData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($lang); ?>"><?php echo e(__($lang)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="from-group">
                            <label class="col-form-label"><?php echo app('translator')->get('Listening'); ?></label>
                            <div class="d-flex justify-content-between flex-wrap">
                                <div class="form-group custom--radio">
                                    <input type="radio" name="listening" id="basic-listening" value="Basic" required>
                                    <label for="basic-listening"><?php echo app('translator')->get('Basic'); ?></label>
                                </div>
                                <div class="form-group custom--radio">
                                    <input id="medium-listening" type="radio" name="listening" value="Medium" required>
                                    <label for="medium-listening"><?php echo app('translator')->get('Medium'); ?></label>
                                </div>
                                <div class="form-group custom--radio">
                                    <input id="fluent-listening" type="radio" name="listening" value="Fluent" required>
                                    <label for="fluent-listening"><?php echo app('translator')->get('Fluent'); ?></label>
                                </div>
                            </div>
                        </div>
                        <div class="from-group">
                            <label class="col-form-label"><?php echo app('translator')->get('Speaking'); ?></label>
                            <div class="d-flex justify-content-between flex-wrap">
                                <div class="form-group custom--radio">
                                    <input type="radio" name="speaking" id="basic-speaking" value="Basic" required>
                                    <label for="basic-speaking"><?php echo app('translator')->get('Basic'); ?></label>
                                </div>
                                <div class="form-group custom--radio">
                                    <input id="medium-speaking" type="radio" name="speaking" value="Medium" required>
                                    <label for="medium-speaking"><?php echo app('translator')->get('Medium'); ?></label>
                                </div>
                                <div class="form-group custom--radio">
                                    <input id="fluent-speaking" type="radio" name="speaking" value="Fluent" required>
                                    <label for="fluent-speaking"><?php echo app('translator')->get('Fluent'); ?></label>
                                </div>
                            </div>
                        </div>
                        <div class="from-group">
                            <label class="col-form-label"><?php echo app('translator')->get('Writing'); ?></label>
                            <div class="d-flex justify-content-between flex-wrap">
                                <div class="form-group custom--radio">
                                    <input type="radio" name="writing" id="basic-writing" value="Basic" required>
                                    <label for="basic-writing"><?php echo app('translator')->get('Basic'); ?></label>
                                </div>
                                <div class="form-group custom--radio">
                                    <input id="medium-writing" type="radio" name="writing" value="Medium" required>
                                    <label for="medium-writing"><?php echo app('translator')->get('Medium'); ?></label>
                                </div>
                                <div class="form-group custom--radio">
                                    <input id="fluent-writing" type="radio" name="writing" value="Fluent" required>
                                    <label for="fluent-writing"><?php echo app('translator')->get('Fluent'); ?></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--base btn--md w-100"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="educationModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <form action="" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row gy-3">
                            <div class="form-group col-md-6">
                                <label for="skill" class="col-form-label"><?php echo app('translator')->get('Country'); ?></label>
                                <select name="country" class="form-control form--control form-select" required>
                                    <option value="" selected disabled><?php echo app('translator')->get('Select Country'); ?></option>
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($country->country); ?>"><?php echo e(__($country->country)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="col-form-label"><?php echo app('translator')->get('University/College'); ?></label>
                                <input type="text" name="institute" class="form-control form--control" value="<?php echo e(old('institute')); ?>" required>
                            </div>
                            <div class="form-group col-md-12">
                                <label class="col-form-label"><?php echo app('translator')->get('Degree'); ?></label>
                                <input type="text" name="degree" class="form-control form--control" value="<?php echo e(old('degree')); ?>" required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="col-form-label"><?php echo app('translator')->get('Start Year'); ?></label>
                                <select name="start_year" class="form-control form--control form-select start-year" required></select>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="col-form-label"><?php echo app('translator')->get('End Year'); ?></label>
                                <select name="end_year" class="form-control form--control form-select end-year" required></select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--base btn--md w-100"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="qualificationModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <form action="" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row gy-3">
                            <div class="form-group col-md-6">
                                <label class="col-form-label"><?php echo app('translator')->get('Professional Certificate or Award'); ?></label>
                                <input type="text" name="certificate" class="form-control form--control" value="<?php echo e(old('certificate')); ?>" required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="col-form-label"><?php echo app('translator')->get('Conferring Organization'); ?></label>
                                <input type="text" name="organization" class="form-control form--control" value="<?php echo e(old('organization')); ?>" required>
                            </div>
                            <div class="form-group col-md-12">
                                <label class="col-form-label"><?php echo app('translator')->get('Summary'); ?></label>
                                <textarea name="summary" class="form-control form--control"><?php echo e(old('summary')); ?></textarea>
                            </div>
                            <div class="form-group col-md-12">
                                <label class="col-form-label"><?php echo app('translator')->get('Year'); ?></label>
                                <select name="year" class="form-control form--control form-select year" required></select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--base btn--md w-100"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ConfirmationModal::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link href="<?php echo e(asset('assets/global/css/fontawesome-iconpicker.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/fontawesome-iconpicker.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .badge.badge--icon {
            border-radius: 5px 0 0 0;
        }

        .select2-container--open {
            z-index: 99999;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            const inputField = document.querySelector('#update-photo'),
                uploadImg = document.querySelector('#upload-img');
            inputField.addEventListener('change', function() {
                const file = this.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function() {
                        const result = reader.result;
                        uploadImg.src = result;
                    }
                    reader.readAsDataURL(file);
                }
            });

            let presentYear = new Date().getFullYear();
            let options = "";
            for (var year = presentYear; year >= 1970; year--) {
                options += `<option value="${year}">${year}</option>`;
            }

            $('.start-year').html(options)
            $('.end-year').html(options)
            $('.year').html(options)

            $('.skillBtn').on('click', function() {
                $('.noSkill').addClass('d-none');
                $("#skillContainer").append(`
                    <div class="add-skill d-flex gap-2 mb-2">
                        <input type="text" name="skills[]" class="form-control form--control" placeholder="<?php echo app('translator')->get('Enter your skill'); ?>" require />
                        <button class="btn btn--danger remove-btn" type="button"><i class="las la-times"></i></button>
                    </div>
                `)
            });
            $(document).on('click', '.remove-btn', function() {
                $(this).closest('.add-skill').remove();
                if ($("#skillContainer").children().length == 0) {
                    $('.noSkill').removeClass('d-none');
                }
            });

            $('.socialBtn').on('click', function() {
                var modal = $('#socialLinkModal');
                modal.find('form').attr('action', `<?php echo e(route('influencer.add.socialLink')); ?>`);
                modal.modal('show')
            });

            $('.editSocialBtn').on('click', function() {
                var modal = $('#socialLinkModal');
                modal.find('.modal-title').text('Update Social Link');
                var action = $(this).data('action');
                modal.find('form').attr('action', `${action}`);
                modal.find('[name=social_icon]').val($(this).data('social_icon'));
                modal.find('[name=url]').val($(this).data('url'));
                modal.find('[name=followers]').val($(this).data('followers'));
                modal.modal('show')
            });

            $('.languageBtn').on('click', function() {
                var modal = $('#languageModal');
                modal.find('form').attr('action', `<?php echo e(route('influencer.language.add')); ?>`);
                modal.modal('show')
            });

            $('.editLangBtn').on('click', function() {
                var modal = $('#languageModal');
                modal.find('.modal-title').text('Update Language');
                var action = $(this).data('action');
                modal.find('form').attr('action', `${action}`);
                modal.find('[name=name]').val($(this).data('name'));
                modal.find('select[name=label]').val($(this).data('label'));
                modal.modal('show')
            });

            $('.educationBtn').on('click', function() {
                var modal = $('#educationModal');
                modal.find('.modal-title').text('Add New Education');
                modal.find('form').attr('action', `<?php echo e(route('influencer.add.education', '')); ?>`);
                modal.modal('show')
            });
            $('.editEduBtn').on('click', function() {
                var modal = $('#educationModal');
                modal.find('.modal-title').text('Update Education');
                var action = $(this).data('action');
                modal.find('form').attr('action', `${action}`);
                modal.find('select[name=country]').val($(this).data('country'));
                modal.find('[name=institute]').val($(this).data('institute'));
                modal.find('[name=degree]').val($(this).data('degree'));
                modal.find('select[name=start_year]').val($(this).data('start_year'));
                modal.find('select[name=end_year]').val($(this).data('end_year'));
                modal.modal('show')
            });

            $('.qualificationBtn').on('click', function() {
                var modal = $('#qualificationModal');
                modal.find('.modal-title').text('Add New Qualification');
                modal.find('form').attr('action', `<?php echo e(route('influencer.add.qualification', '')); ?>`);
                modal.modal('show')
            });

            $('.editQualifyBtn').on('click', function() {
                var modal = $('#qualificationModal');
                modal.find('.modal-title').text('Update Qualification');
                var action = $(this).data('action');
                modal.find('form').attr('action', `${action}`);
                modal.find('[name=certificate]').val($(this).data('certificate'));
                modal.find('[name=organization]').val($(this).data('organization'));
                modal.find('[name=summary]').val($(this).data('summary'));
                modal.find('select[name=year]').val($(this).data('year'));
                modal.modal('show')
            });

            $('.editbtn').on('click', function() {
                $('.influencer-profile-edit').removeClass('d-none');
                $('.influencer-profile').addClass('d-none');
            });
            $('.cancelBtn').on('click', function() {
                $('.influencer-profile-edit').addClass('d-none');
                $('.influencer-profile').removeClass('d-none');

            });

            $('.editSkillbtn').on('click', function() {
                $('.skill-edit').removeClass('d-none');
                $('.influencer-skill').addClass('d-none');
            });

            $('.cancelSkillBtn').on('click', function() {
                $('.skill-edit').addClass('d-none');
                $('.influencer-skill').removeClass('d-none');
            });


            $('.iconPicker').iconpicker().on('iconpickerSelected', function(e) {
                $(this).closest('.form-group').find('.iconpicker-input').val(`<i class="${e.iconpickerValue}"></i>`);
            });

            $('#educationModal').on('hidden.bs.modal', function() {
                $('#educationModal form')[0].reset();
            });

            $('#qualificationModal').on('hidden.bs.modal', function() {
                $('#qualificationModal form')[0].reset();
            });

            $('#socialLinkModal').on('hidden.bs.modal', function() {
                $('#socialLinkModal form')[0].reset();
            });

            $(".select2-multi-select").select2({
                dropdownParent: $('.has-select2')
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/influencer/profile_setting.blade.php ENDPATH**/ ?>