<?php
    $kycContent = getContent('influencer_kyc.content', true);
?>

<?php $__env->startSection('content'); ?>
    <?php if(authInfluencer()->kv == 0): ?>
        <div class="alert alert-info" role="alert">
            <h4 class="alert-heading"><?php echo app('translator')->get('KYC Verification required'); ?></h4>
            <hr>
            <p class="mb-0"><?php echo e(__($kycContent->data_values->verification_content)); ?>

                <a href="<?php echo e(route('influencer.kyc.form')); ?>" class="text--base"><?php echo app('translator')->get('Click Here to Verify'); ?></a>
            </p>
        </div>
    <?php elseif(authInfluencer()->kv == 2): ?>
        <div class="alert alert-warning" role="alert">
            <h4 class="alert-heading"><?php echo app('translator')->get('KYC Verification pending'); ?></h4>
            <hr>
            <p class="mb-0"><?php echo e(__($kycContent->data_values->pending_content)); ?>

                <a href="<?php echo e(route('influencer.kyc.data')); ?>" class="text--base"><?php echo app('translator')->get('See KYC Data'); ?></a>
            </p>
        </div>
    <?php endif; ?>
    <div class="wrapper">
        <div class="preloader"></div>


        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    <?php echo $__env->make($activeTemplate . 'influencer.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <div class="row pb40">
                         
                            <div class="col-lg-12">
                                <div class="dashboard_title_area">
                                    <h2>Retrage Fonduri</h2>
                                    
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                    <div class="card-body">
                                        <form action="<?php echo e(route('influencer.withdraw.money')); ?>" method="post"
                                            class="from row gy-2">
                                            <?php echo csrf_field(); ?>
                                            <div class="form-group">
                                                
                                                <label class="form-label
                                                    text--base"><?php echo app('translator')->get('Your Balance'); ?> : <span
                                                        class="text--success"><?php echo e(showAmount(authInfluencer()->balance)); ?>

                                                        <?php echo e(__($general->cur_text)); ?></span></label>
                                                <input type="hidden" name="balance"
                                                    value="<?php echo e(authInfluencer()->balance); ?>">
                                            </div>
                                                <label class="form-label"><?php echo app('translator')->get('Withdraw Method'); ?></label>
                                                <select class="form-control form--control form-select" name="method_code"
                                                    required>
                                                    <option value=""><?php echo app('translator')->get('Select Gateway'); ?></option>
                                                    <?php $__currentLoopData = $withdrawMethod; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($data->id); ?>"
                                                            data-resource="<?php echo e($data); ?>">
                                                            <?php echo e(__($data->name)); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label"><?php echo app('translator')->get('Amount'); ?></label>
                                                <div class="input-group">
                                                    <input type="number" step="any" name="amount"
                                                        value="<?php echo e(old('amount')); ?>" class="form-control form--control"
                                                        required>
                                                    <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                                                </div>
                                            </div>
                                            <div class="preview-details d-none my-3">
                                                <ul class="list-group-flush text-center">
                                                    <li class="list-group-item d-flex justify-content-between">
                                                        <span><?php echo app('translator')->get('Limit'); ?></span>
                                                        <span><span class="min fw-bold">0</span>
                                                            <?php echo e(__($general->cur_text)); ?> - <span
                                                                class="max fw-bold">0</span>
                                                            <?php echo e(__($general->cur_text)); ?></span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between">
                                                        <span><?php echo app('translator')->get('Charge'); ?></span>
                                                        <span><span class="charge fw-bold">0</span>
                                                            <?php echo e(__($general->cur_text)); ?></span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between">
                                                        <span><?php echo app('translator')->get('Receivable'); ?></span> <span><span
                                                                class="receivable fw-bold"> 0</span>
                                                            <?php echo e(__($general->cur_text)); ?> </span>
                                                    </li>
                                                    <li class="list-group-item d-none justify-content-between rate-element">

                                                    </li>
                                                    <li class="list-group-item d-none justify-content-between in-site-cur">
                                                        <span><?php echo app('translator')->get('In'); ?> <span class="base-currency"></span></span>
                                                        <strong class="final_amo">0</strong>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div
                                                style="align-items: center; display: flex; justify-content: space-between; flex-direction: column; margin-top: 20px;">
                                                <button type="submit"
                                                    class="ud-btn btn-dark default-box-shadow2"><?php echo app('translator')->get('Submit'); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    </footer>
                </div>
            </div>
        </div>
        <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/influencer/withdraw/methods2.blade.php ENDPATH**/ ?>