<?php $__env->startSection('content'); ?>
    <div class="card custom--card">
        <div class="card-body">
            <form action="<?php echo e(route('influencer.service.store', @$service->id)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-lg-4">
                        <label class="form-label" for="title"><?php echo app('translator')->get('Image'); ?><span class="text--danger">*</span></label>
                        <div class="profile-thumb p-0 text-center shadow-none">
                            <div class="thumb">
                                <img id="upload-img" src="<?php echo e(getImage(getFilePath('service') . '/' . @$service->image, getFileSize('service'))); ?>" alt="userProfile">
                                <label class="badge badge--icon badge--fill-base update-thumb-icon" for="update-photo"><i class="las la-pen"></i></label>
                            </div>
                            <div class="profile__info">
                                <input type="file" name="image" class="form-control d-none" id="update-photo" <?php if(!@$service): ?> required <?php endif; ?>>
                            </div>
                        </div>
                        <small class="text--warning"><?php echo app('translator')->get('Supported files'); ?>: <?php echo app('translator')->get('jpeg'); ?>, <?php echo app('translator')->get('jpg'); ?>, <?php echo app('translator')->get('png'); ?>. <?php echo app('translator')->get('| Will be resized to'); ?>: <?php echo e(getFileSize('service')); ?><?php echo app('translator')->get('px'); ?>.</small>
                    </div>
                    <?php
                        if (@$service) {
                            $categoryId = $service->category_id;
                        } else {
                            $categoryId = old('category_id');
                        }
                    ?>
                    <div class="col-lg-8">
                        <div class="form-group">
                            <label class="form-label" for="category_id"><?php echo app('translator')->get('Category'); ?></label>
                            <select class="form-select form--control" name="category_id" id="category_id" required>
                                <option value="" selected disabled><?php echo app('translator')->get('Select category'); ?></option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>" <?php if($categoryId == $category->id): ?> selected="selected" <?php endif; ?>>
                                        <?php echo e(__($category->name)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label" for="title"><?php echo app('translator')->get('Title'); ?></label>
                            <input type="text" class="form-control form--control" name="title" id="title" value="<?php if(@$service): ?> <?php echo e(@$service->title); ?><?php else: ?><?php echo e(old('title')); ?> <?php endif; ?>" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label" for="price"><?php echo app('translator')->get('Price'); ?></label>
                            <div class="input-group">
                                <input type="number" step="any" class="form-control form--control" name="price" id="price" value="<?php if(@$service): ?> <?php echo e(getAmount(@$service->price)); ?><?php else: ?><?php echo e(old('price')); ?> <?php endif; ?>" required>
                                <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group skill-body">
                    <label for="skill" class="form-label"><?php echo app('translator')->get('Service Tags'); ?></label>
                    <select class="select2-auto-tokenize form-control form--control" multiple="multiple" name="tags[]" required>
                        <?php if(@$service): ?>
                            <?php $__currentLoopData = @$service->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e(@$tag->name); ?>" selected><?php echo e(__(@$tag->name)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label class="form-label required" for="description"><?php echo app('translator')->get('Description'); ?></label>
                    <textarea rows="4" class="form-control form--control nicEdit" name="description" id="description" placeholder="<?php echo app('translator')->get('Write here'); ?>">
<?php if(@$service): ?>
<?php echo $service->description ?>
<?php else: ?>
<?php echo e(old('description')); ?>

<?php endif; ?>
</textarea>
                </div>

                <div class="content w-100 ps-0">
                    <div class="d-flex justify-content-between align-items-end mb-3">
                        <div class="form-label mb-0">
                            <p><?php echo app('translator')->get('Key Points'); ?><span class="text--danger">*</span></p>
                        </div>
                        <button type="button" class="btn btn--outline-custom btn--sm pointBtn">
                            <i class="las la-plus"></i><?php echo app('translator')->get('Add More'); ?>
                        </button>
                    </div>
                </div>

                <?php if(@$service->key_points): ?>
                    <?php $__currentLoopData = @$service->key_points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="key-point d-flex mb-3 gap-2">
                            <input type="text" class="form-control form--control" name="key_points[]" value="<?php echo e(__($point)); ?>" required>
                            <button class="btn btn--danger remove-button <?php if($loop->first): ?> disabled <?php endif; ?> border-0" type="button"><i class="fas fa-times"></i></button>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="d-flex mb-3 gap-2">
                        <input type="text" class="form-control form--control" name="key_points[]" required>
                        <button class="btn btn--danger disabled border-0" type="button">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                <?php endif; ?>
                <div id="more-keyPoint">

                </div>

                <div class="form-group">
                    <label class="form-label"><?php echo app('translator')->get('Images'); ?></label>
                    <div class="input-images"></div>
                </div>


                <button type="submit" class="btn btn--base w-100 mt-3"><?php echo app('translator')->get('Submit'); ?></button>
        </div>
        </form>
    </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .badge.badge--icon {
            border-radius: 5px 0 0 0;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/lib/image-uploader.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/lib/image-uploader.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            const inputField = document.querySelector('#update-photo'),
                uploadImg = document.querySelector('#upload-img');
            inputField.addEventListener('change', function() {
                const file = this.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function() {
                        const result = reader.result;
                        uploadImg.src = result;
                    }
                    reader.readAsDataURL(file);
                }
            });


            <?php if(isset($images)): ?>
                let preloaded = <?php echo json_encode($images, 15, 512) ?>;
            <?php else: ?>
                let preloaded = [];
            <?php endif; ?>

            $('.input-images').imageUploader({
                preloaded: preloaded,
                imagesInputName: 'images',
                preloadedInputName: 'old',
                maxSize: 2 * 1024 * 1024,
            });

            $('.pointBtn').on('click', function() {
                var html = `
                <div class="key-point d-flex gap-2 mb-3">
                    <input type="text" class="form-control form--control" name="key_points[]" required>
                    <button class="btn btn--danger remove-button border-0" type="button"><i class="fas fa-times"></i></button>
                </div>`;
                $('#more-keyPoint').append(html);
            });

            $(document).on('click', '.remove-button', function() {
                $(this).closest('.key-point').remove();
            });


            $(".select2-auto-tokenize").select2({
                tags: true,
                tokenSeparators: [","],
                dropdownParent: $(".skill-body"),
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/influencer/service/create.blade.php ENDPATH**/ ?>