
<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Influencer'); ?></th>
                                    <th><?php echo app('translator')->get('Category'); ?></th>
                                    <th><?php echo app('translator')->get('Title'); ?></th>
                                    <th><?php echo app('translator')->get('Order'); ?></th>
                                    <?php if(request()->routeIs('admin.service.index')): ?>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <?php endif; ?>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td data-label="<?php echo app('translator')->get('Influencer'); ?>">
                                        <span class="fw-bold"><?php echo e(@$service->influencer->fullname); ?></span>
                                        <br>
                                        <span class="small">
                                        <a href="<?php echo e(route('admin.influencers.detail', @$service->influencer->id)); ?>"><span>@</span><?php echo e(@$service->influencer->username); ?></a>
                                        </span>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Category'); ?>">
                                        <span class="fw-bold"><?php echo e(@$service->category->name); ?></span>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Title'); ?>">
                                        <span><?php echo e(strLimit($service->title,40)); ?></span>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Order'); ?>">
                                        <span> <?php echo app('translator')->get('Total'); ?> : <?php echo e(getAmount($service->total_order_count)); ?></span><br>
                                        <span> <?php echo app('translator')->get('Done'); ?> : <?php echo e(getAmount($service->complete_order_count)); ?></span><br>
                                    </td>

                                    <?php if(request()->routeIs('admin.service.index')): ?>
                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                        <?php echo $service->statusBadge ?>
                                    </td>
                                    <?php endif; ?>

                                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                        <a href="<?php echo e(route('admin.service.detail', $service->id)); ?>" class="btn btn-sm btn-outline--primary">
                                            <i class="las la-desktop text--shadow"></i> <?php echo app('translator')->get('Details'); ?>
                                        </a>
                                    </td>

                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($services->hasPages()): ?>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($services)); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>


    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('breadcrumb-plugins'); ?>
    <div class="d-flex flex-wrap justify-content-end">
        <form action="" method="GET" class="form-inline">
            <div class="input-group justify-content-end">
                <input type="text" name="search" class="form-control bg--white" placeholder="<?php echo app('translator')->get('Search here'); ?>" value="<?php echo e(request()->search); ?>">
                <button class="btn btn--primary input-group-text" type="submit"><i class="fa fa-search"></i></button>
            </div>
        </form>
    </div>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/admin/service/list.blade.php ENDPATH**/ ?>