<?php
$socialIcons = getContent('social_icon.element', false, null, true);
$policyPages = getContent('policy_pages.element', false, null, true);
$contact = getContent('contact_us.content', true);
$footer = getContent('footer.content', true);
?>
<footer class="bg--accent footer pt-80">
    <div class="container">
        <div class="row gy-4 justify-content-between">
            <div class="col-lg-3 col-sm-6 col-md-5">
                <div class="footer-widget">
                    <a class="logo mb-4" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo.png')); ?>" alt="Logo"></a>
                    <p><?php echo e(__(@$footer->data_values->description)); ?></p>
                    <ul class="social-links d-flex mt-4 flex-wrap gap-3">
                        <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(@$social->data_values->url); ?>">
                                    <?php
                                        echo @$social->data_values->social_icon;
                                    ?>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
            <div class="col-lg-2 col-sm-6 col-md-5">
                <div class="footer-widget">
                    <h5 class="footer-widget__title text--base mb-sm-3 mb-2 pb-1"><?php echo app('translator')->get('Link-uri Rapide'); ?></h5>
                    <ul class="footer-links">
                        <li>
                            <a href="<?php echo e(route('services')); ?>" class="<?php echo e(menuActive('services')); ?>"><?php echo app('translator')->get('Services'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('influencers')); ?>" class="<?php echo e(menuActive('influencers')); ?>"><?php echo app('translator')->get('Influencers'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('contact')); ?>" class="<?php echo e(menuActive('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-2 col-sm-6 col-md-5">
                <div class="footer-widget">
                    <h5 class="footer-widget__title text--base mb-sm-3 mb-2 pb-1"><?php echo app('translator')->get('Link-uri Utile'); ?></h5>
                    <ul class="footer-links">
                        <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(route('policy.pages', [slug($policy->data_values->title), $policy->id])); ?>">
                                    <?php echo e(__(@$policy->data_values->title)); ?>

                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6 col-md-5">
                <div class="footer-widget">
                    <h5 class="footer-widget__title text--base mb-sm-3 mb-2 pb-1"><?php echo app('translator')->get('Informatii Contact'); ?></h5>
                    <ul class="footer-links">
                        <li><a href="mailto:<?php echo e('contact@solveet-app.com'); ?>"><i class="las la-envelope-open"></i> <?php echo e(__('contact@solveet-app.com')); ?></a></li>
                        
                    </ul>
                </div>
            </div>
        </div>

        <p class="text-center border-top my-4 flex-wrap pt-4">
            <?php echo app('translator')->get('Copyright'); ?> &copy; <?php echo date('Y') ?>. <?php echo app('translator')->get('All Rights Reserved'); ?>
        </p>
    </div>
</footer>
<?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/partials/footer.blade.php ENDPATH**/ ?>