<?php $__env->startSection('content'); ?>
    <?php
    $policyPages = getContent('policy_pages.element', false, null, true);
    $register = getContent('influencer_register.content', true);
    $registerUser = getContent('user_register.content', true);
    ?>
    <div class="account-section pt-80 pb-80">
        <div class="container">
            <div class="account-wrapper">
                <div class="row gy-5 align-items-center">
                    <div class="col-lg-6">
                        <div class="account-thumb-wrapper">
                            <img src="<?php echo e(getImage('assets/images/frontend/influencer_register/' . @$register->data_values->image, '660x450')); ?>" class="mw-100 h-100">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="account-content">
                            <div class="d-flex justify-content-between flex-wrap gap-3 pb-5">
                                <div class="account-content-left">
                                    <h3 class="this-page-title"><?php echo e(__(@$register->data_values->title)); ?></h3>
                                </div>
                                <div class="account-content-right">
                                    <button type="button" class="btn btn--md btn--outline-base actionBtn" data-type="client"><?php echo app('translator')->get('Client'); ?></button>
                                    <button type="button" class="btn btn--md btn--outline-base actionBtn active" data-type="influencer"><?php echo app('translator')->get('Influencer'); ?></button>
                                </div>
                            </div>
                            <form action="<?php echo e(route('influencer.register')); ?>" method="POST" class="form verify-gcaptcha">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label" for="username"><?php echo app('translator')->get('Username'); ?></label>
                                            <input type="text" name="username" id="username" value="<?php echo e(old('username')); ?>" class="form-control form--control checkUser" required>
                                            <small class="text-danger usernameExist"></small>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label" for="email"><?php echo app('translator')->get('Email Address'); ?></label>
                                            <input type="email" name="email" id="email" value="<?php echo e(old('email')); ?>" class="form-control form--control checkUser" required>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label" for="email"><?php echo app('translator')->get('Country'); ?></label>
                                            <select name="country" class="form-select form--control" required>
                                                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option data-mobile_code="<?php echo e($country->dial_code); ?>" value="<?php echo e($country->country); ?>" data-code="<?php echo e($key); ?>">
                                                        <?php echo e(__($country->country)); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label" for="mobile"><?php echo app('translator')->get('Mobile'); ?></label>
                                            <div class="input-group">
                                                <span class="input-group-text mobile-code"></span>
                                                <input type="hidden" name="mobile_code">
                                                <input type="hidden" name="country_code">
                                                <input type="number" name="mobile" value="<?php echo e(old('mobile')); ?>" class="form-control form--control checkUser" required>
                                            </div>
                                            <small class="text-danger mobileExist"></small>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label" for="password"><?php echo app('translator')->get('Password'); ?></label>
                                            <input type="password" id="password" name="password" class="form-control form--control" required>
                                            <?php if($general->secure_password): ?>
                                                <div class="input-popup">
                                                    <p class="error lower"><?php echo app('translator')->get('1 small letter minimum'); ?></p>
                                                    <p class="error capital"><?php echo app('translator')->get('1 capital letter minimum'); ?></p>
                                                    <p class="error number"><?php echo app('translator')->get('1 number minimum'); ?></p>
                                                    <p class="error special"><?php echo app('translator')->get('1 special character minimum'); ?></p>
                                                    <p class="error minimum"><?php echo app('translator')->get('6 character password'); ?></p>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label" for="password_confirm"><?php echo app('translator')->get('Confirm Password'); ?></label>
                                            <input type="password" id="password_confirm" name="password_confirmation" class="form-control form--control" required>
                                        </div>
                                    </div>

                                    <?php if (isset($component)) { $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Captcha::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\Captcha::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243)): ?>
<?php $component = $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243; ?>
<?php unset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243); ?>
<?php endif; ?>

                                    <?php if($general->agree): ?>
                                        <div class="form-group custom--checkbox">
                                            <input type="checkbox" id="agree" <?php if(old('agree')): echo 'checked'; endif; ?> name="agree" required>
                                            <label for="agree" class="ms-2"><?php echo app('translator')->get('I agree with'); ?>
                                                <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <a href="<?php echo e(route('policy.pages', [slug($policy->data_values->title), $policy->id])); ?>" class="text--base">
                                                        <?php echo e(__(@$policy->data_values->title)); ?></a>
                                                    <?php if(!$loop->last): ?>
                                                        ,
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </label>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <button type="submit" id="recaptcha" class="btn btn--base w-100"><?php echo app('translator')->get('Submit'); ?></button>
                            </form>
                            <div class="text-center">
                                <p class="mt-3"><?php echo app('translator')->get('Have an account? '); ?>
                                    <a href="<?php echo e(route('influencer.login')); ?>" class="text--base login-url"><?php echo app('translator')->get('Login here'); ?></a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="existModalCenter" tabindex="-1" role="dialog" aria-labelledby="existModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="existModalLongTitle"><?php echo app('translator')->get('You are with us'); ?></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <h6 class="text-center"><?php echo app('translator')->get('You already have an account please Login '); ?></h6>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark btn--sm" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <a href="<?php echo e(route('influencer.login')); ?>" class="btn btn--base btn--sm"><?php echo app('translator')->get('Login'); ?></a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            <?php if($mobile_code): ?>
                $(`option[data-code=<?php echo e($mobile_code); ?>]`).attr('selected', '');
            <?php endif; ?>

            $('select[name=country]').change(function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            });
            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            <?php if($general->secure_password): ?>
                $('input[name=password]').on('input', function() {
                    secure_password($(this));
                });

                $('[name=password]').focus(function() {
                    $(this).closest('.form-group').addClass('hover-input-popup');
                });

                $('[name=password]').focusout(function() {
                    $(this).closest('.form-group').removeClass('hover-input-popup');
                });
            <?php endif; ?>

            $('.checkUser').on('focusout', function(e) {
                var url = '<?php echo e(route('influencer.checkUser')); ?>';
                var value = $(this).val();
                var token = '<?php echo e(csrf_token()); ?>';
                if ($(this).attr('name') == 'mobile') {
                    var mobile = `${$('.mobile-code').text().substr(1)}${value}`;
                    var data = {
                        mobile: mobile,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'email') {
                    var data = {
                        email: value,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }
                $.post(url, data, function(response) {
                    if (response.data != false && response.type == 'email') {
                        $('#existModalCenter').modal('show');
                    } else if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.type} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            });

            $('.actionBtn').on('click',function () {
                let action;
                let loginUrl;
                let pageTitle;

                if($(this).data('type') == 'client'){
                    action = `<?php echo e(route('user.register')); ?>`;
                    loginUrl = `<?php echo e(route('user.login')); ?>`;
                    pageTitle = `<?php echo e(__(@$registerUser->data_values->title)); ?>`;
                }else{
                    action = `<?php echo e(route('influencer.register')); ?>`;
                    loginUrl = `<?php echo e(route('influencer.login')); ?>`;
                    pageTitle = `<?php echo e(__(@$register->data_values->title)); ?>`;
                }
                $('form')[0].action = action;

                $(this).addClass('active');
                $('.login-url').attr('href',loginUrl);
                $('.this-page-title').text(pageTitle);
                $('.actionBtn').not($(this)).removeClass('active');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/influencer/auth/register.blade.php ENDPATH**/ ?>