<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            
            <table class="table table--responsive--lg">
                <thead>
                    <tr>
                        <th><?php echo app('translator')->get('Gateway | Transaction'); ?></th>
                        <th><?php echo app('translator')->get('Initiated'); ?></th>
                        <th><?php echo app('translator')->get('Amount'); ?></th>
                        <th><?php echo app('translator')->get('Conversion'); ?></th>
                        <th><?php echo app('translator')->get('Status'); ?></th>
                        
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td data-label="<?php echo app('translator')->get('Gateway | Transaction'); ?>">
                                <div>
                                    <span class="text--base"><?php echo e(__($deposit->gateway?->name)); ?></span>
                                    <br>
                                    <small> <?php echo e($deposit->trx); ?> </small>
                                </div>
                            </td>
    
                            <td data-label="<?php echo app('translator')->get('Initiated'); ?>">
                                <?php echo e(showDateTime($deposit->created_at)); ?><br><?php echo e(diffForHumans($deposit->created_at)); ?>

                            </td>
                            <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                <div>
                                    <?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($deposit->amount)); ?> + <span
                                        class="text-danger" title="<?php echo app('translator')->get('charge'); ?>"><?php echo e(showAmount($deposit->charge)); ?>

                                    </span>
                                    <br>
                                    <strong title="<?php echo app('translator')->get('Amount with charge'); ?>">
                                        <?php echo e(showAmount($deposit->amount + $deposit->charge)); ?> <?php echo e($general->cur_text); ?>

                                    </strong>
                                </div>
                            </td>
                            <td data-label="<?php echo app('translator')->get('Conversion'); ?>">
                                <div>
                                    1 <?php echo e(__($general->cur_text)); ?> = <?php echo e(showAmount($deposit->rate)); ?>

                                    <?php echo e(__($deposit->method_currency)); ?>

                                    <br>
                                    <strong><?php echo e(showAmount($deposit->final_amo)); ?>

                                        <?php echo e(__($deposit->method_currency)); ?></strong>
                                </div>
                            </td>
                            <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                <?php echo $deposit->statusBadge ?>
                            </td>
                            <?php
                                $details = $deposit->detail != null ? json_encode($deposit->detail) : null;
                            ?>
    
                          
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="justify-content-center text-center" colspan="100%">
                                <i class="la la-4x la-frown"></i>
                                <br>
                                <?php echo e(__($emptyMessage)); ?>

                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    
        
        <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                        <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </span>
                    </div>
                    <div class="modal-body">
                        <ul class="list-group-flush userData mb-2">
                        </ul>
                        <div class="feedback"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');

                var userData = $(this).data('info');
                var html = '';
                if (userData) {
                    userData.forEach(element => {
                        if (element.type != 'file') {
                            html += `
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>${element.name}</span>
                                <span">${element.value}</span>
                            </li>`;
                        }
                    });
                }

                modal.find('.userData').html(html);

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong><?php echo app('translator')->get('Admin Feedback'); ?></strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                modal.find('.feedback').html(adminFeedback);


                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/user/deposit_history.blade.php ENDPATH**/ ?>