<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center gy-4">
        <div class="col-md-5">
            <div class="card custom--card">
                <div class="card-header">
                    <h5 class="title"><?php echo app('translator')->get('Influencer Information'); ?></h5>
                </div>

                <div class="card-body p-3">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Name'); ?></span>
                            <span><?php echo e(__(@$order->influencer->fullname)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Email'); ?></span>
                            <span><?php echo e(__(@$order->influencer->email)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Country'); ?></span>
                            <span><?php echo e(__(@$order->influencer->address->country)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Member Since'); ?></span>
                            <span><?php echo e(showDateTime($order->influencer->created_at, 'd M, Y')); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Order Complted'); ?></span>
                            <span><?php echo e(getAmount($order->influencer->completed_order)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Visit Profile'); ?></span>
                            <span><a href="<?php echo e(route('influencer.profile', [slug($order->influencer->username), $order->influencer_id])); ?>" class="text--base"><i class="las la-external-link-alt"></i> <?php echo app('translator')->get('Link'); ?></a></span>
                        </li>


                    </ul>
                </div>
            </div>
            <?php if($order->status == 3): ?>
            <div class="card custom--card mt-4">
                <div class="card-header">
                    <h5 class="title"><?php echo app('translator')->get('Take Action'); ?></h5>
                </div>

                <div class="card-body">
                    <div class="d-flex flex-wrap gap-2">

                        <button type="button" class="btn btn--sm btn--outline-dark reportBtn" data-id="<?php echo e($order->id); ?>">
                            <i class="las la-gavel"></i> <?php echo app('translator')->get('Report to Admin'); ?>
                        </button>

                        <button type="button" class="btn btn--sm btn--outline-success confirmationBtn" data-action="<?php echo e(route('user.order.complete.status',$order->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to complete this order?'); ?>" data-btn_class="btn btn--base btn--md">
                            <i class="las la-check-double"></i> <?php echo app('translator')->get('Complete'); ?>
                        </button>


                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <div class="col-md-7">
            <div class="card custom--card">
                <div class="card-header">
                    <h5 class="title"><?php echo app('translator')->get('Order Information'); ?></h5>
                </div>
                <div class="card-body p-3">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Title'); ?></span>
                            <span><?php echo e($order->title); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Delivery Date'); ?></span>
                            <span><?php echo e($order->delivery_date); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Amount'); ?></span>
                            <span><?php echo e(showAmount($order->amount)); ?> <?php echo e($general->cur_text); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Order No'); ?></span>
                            <span><?php echo e($order->order_no); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Order Status'); ?></span>
                            <span> <?php echo $order->statusBadge ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Description'); ?></span>
                            <button class="btn btn--sm btn--outline-base descriptionBtn" data-description="<?php echo e($order->description); ?>"><?php echo app('translator')->get('View'); ?></button>
                        </li>
                        <?php if($order->status == 4): ?>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Reason of Report'); ?></span>
                            <button class="btn btn--sm btn--outline-dark reasonBtn" data-reason="<?php echo e($order->reason); ?>"><?php echo app('translator')->get('View'); ?></button>
                        </li>
                        <?php endif; ?>
                    </ul>

                </div>
            </div>
        </div>
    </div>
    <div id="reportModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Report to Admin'); ?></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <form action="" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group report-reason">
                            <label class="form-label"><?php echo app('translator')->get('Reason'); ?></label>
                            <textarea name="reason" class="form-control form--control"><?php echo e(old('reason')); ?></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark btn--md" data-bs-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                        <button type="submit" class="btn btn--base btn--md"><?php echo app('translator')->get('Yes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div id="descriptionModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <p class="description"></p>
                </div>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ConfirmationModal::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.descriptionBtn').on('click',function () {
                var modal = $("#descriptionModal");
                modal.find('.modal-title').text('Description');
                modal.find('.description').html($(this).data('description'));
                modal.modal('show');
            });
            $('.reasonBtn').on('click',function () {
                var modal = $("#descriptionModal");
                modal.find('.modal-title').text('Reason of Report')
                modal.find('.description').text($(this).data('reason'));
                modal.modal('show');
            });

            $('.reportBtn').on('click', function() {
                var modal = $('#reportModal');
                let id = $(this).data('id');
                modal.find('form').attr('action', `<?php echo e(route('user.order.report.status','')); ?>/${id}`);
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/user/order/detail.blade.php ENDPATH**/ ?>