<?php $__env->startSection('content'); ?>
<div class="inbox">
    <div class="card custom--card">
        <div class="card-body">
            <div class="tab-content">
                <div class="tab-pane show fade active" id="abc">
                    <div class="chat__msg" id="coversation_body">
                        <div class="chat__msg-header border-bottom">
                            <div class="post__creator align-items-center d-flex flex-wrap justify-content-between">
                                <div class="post__creator-content mb-3">
                                    <h5 class="name"><?php echo e(__(@$influencer->fullname)); ?></h5>
                                    <?php if($influencer->status == 0): ?>
                                        <span class="text--base"><?php echo app('translator')->get('Banned'); ?></span>
                                    <?php else: ?>
                                    <small>
                                        <?php if($influencer): ?>
                                            <?php if($influencer->isOnline()): ?>
                                            <span class="text--base"><?php echo app('translator')->get('Online'); ?></span>
                                            <?php else: ?>
                                            <span><?php echo app('translator')->get('Offline'); ?></span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </small>
                                    <?php endif; ?>
                                </div>
                                <div class="post__creator-content mb-3">
                                    <button class="btn btn--outline-custom btn--sm reloadBtn"><i class="las la-sync-alt"></i> <?php echo app('translator')->get('Reload'); ?></button>
                                </div>
                            </div>
                        </div>

                        <div class="chat__msg-body position-relative">
                            <div class="message-loader-wrapper">
                                <div class="message-loader mx-auto"></div>
                            </div>
                            <ul class="msg__wrapper mt-3" id="message">
                                <?php if($influencer): ?>
                                <?php echo $__env->make($activeTemplate.'user.conversation.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <?php if(!($order->status == 1 || $order->status == 5 || $order->status == 6)): ?>
                        <div class="chat__msg-footer">
                            <span class="file-count"></span>
                            <form action="" method="POST" class="send__msg" enctype="multipart/form-data" id="messageForm">
                                <div class="d-flex gap-2">
                                    <textarea type="text" class="form-control form--control messageVal" name="message" contenteditable="true" placeholder="<?php echo app('translator')->get('Write Message'); ?>..." required></textarea>
                                    <button class="btn btn--base px-3 send-btn flex-shrink-0" type="submit"><?php echo app('translator')->get('Send'); ?></button>
                                </div>
                                <label class="upload-file" for="upload-file">@ <?php echo app('translator')->get('Add Attachment'); ?></label>
                                <input id="upload-file" type="file" name="attachments[]" class="form-control d-none" accept=".png, .jpg, .jpeg, .pdf, .doc, .docx, .txt" multiple>
                            </form>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    (function($) {
            "use strict";
            $('.message-loader-wrapper').fadeOut(300);
            $('#upload-file').on('change', function() {
                var fileCount = $(this)[0].files.length;
                $('.file-count').text(`${fileCount} files upload`)
            });

            $(".reloadBtn").on('click',function () {
                loadMore(10);
            });

            var messageCount = 10
            $(".chat__msg-body").on('scroll',function () {
                if($(this).scrollTop() == 0) {
                    messageCount += 10;
                    loadMore(messageCount);
                }
            });

            function loadMore(messageCount){
                $('.message-loader-wrapper').fadeIn(300)
                $.ajax({
                    method: "GET",
                    data: {
                        order_id:`<?php echo e(@$order->id); ?>`,
                        messageCount:messageCount
                    },
                    url: "<?php echo e(route('user.order.conversation.message')); ?>",
                    success: function (response) {
                        $("#message").html(response);
                    }
                }).done(function() {
                    $('.message-loader-wrapper').fadeOut(500)
                });
            }

            $("#messageForm").submit(function (e) {
                e.preventDefault();
                var formData = new FormData($(this)[0]);

                $.ajax({
                    headers: {"X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>",},
                    url:"<?php echo e(route('user.order.conversation.store', @$order->id)); ?>",
                    method:"POST",
                    data:formData,
                    async:false,
                    processData: false,
                    contentType: false,
                    success:function(response)
                    {
                        if(response.error){
                            notify('error', response.error);
                        }else{
                            $('#messageForm')[0].reset();
                            $('.file-count').text('')
                            $("#message").append(response);
                            scrollHeight();
                        }
                    }
                });
            });
        })(jQuery);
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/user/order/conversation.blade.php ENDPATH**/ ?>