<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Order Number'); ?></th>
                                    <th><?php echo app('translator')->get('Reviewer'); ?></th>
                                    <th><?php echo app('translator')->get('Influencer'); ?></th>
                                    <th><?php echo app('translator')->get('Service'); ?></th>
                                    <th><?php echo app('translator')->get('Rating'); ?></th>
                                    <th><?php echo app('translator')->get('Created At'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td data-label="<?php echo app('translator')->get('Order Number'); ?>">
                                            <span class="fw-bold">
                                                <a href="<?php echo e(route('admin.order.detail', $review->order_id)); ?>"><?php echo e(@$review->order->order_no); ?> </a>
                                            </span>
                                        </td>

                                        <td data-label="<?php echo app('translator')->get('Reviewer'); ?>">
                                            <span class="fw-bold">
                                                <?php echo e(__(@$review->user->fullname)); ?><br>
                                                <a href="<?php echo e(route('admin.users.detail', $review->user_id)); ?>">
                                                    <span>@</span><?php echo e(@$review->user->username); ?>

                                                </a>
                                            </span>
                                        </td>

                                        <td data-label="<?php echo app('translator')->get('Influencer'); ?>">
                                            <span class="fw-bold">
                                                <?php echo e(__(@$review->influencer->fullname)); ?><br>
                                                <a href="<?php echo e(route('admin.influencers.detail', $review->influencer_id)); ?>">
                                                    <span>@</span><?php echo e(@$review->influencer->username); ?>

                                                </a>
                                            </span>
                                        </td>

                                        <td data-label="<?php echo app('translator')->get('Service'); ?>">
                                            <span class="small">
                                                <a href="<?php echo e(route('admin.service.detail', $review->service_id)); ?>"><?php echo e(strLimit(@$review->service->title, 30)); ?></a>
                                            </span>
                                        </td>

                                        <td data-label="<?php echo app('translator')->get('Rating'); ?>">
                                            <span><?php echo e($review->star); ?> <?php echo app('translator')->get('star'); ?></span>
                                        </td>

                                        <td data-label="<?php echo app('translator')->get('Created At'); ?>">
                                            <span><?php echo e(showDateTime($review->created_at)); ?> <br> <?php echo e(diffForHumans($review->created_at)); ?></span>
                                        </td>


                                        <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                            <button type="button" class="btn btn-sm btn-outline--info viewBtn"
                                                data-review="<?php echo e($review->review); ?>">
                                                <i class="las la-desktop text--shadow"></i> <?php echo app('translator')->get('View'); ?>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline--danger confirmationBtn" data-action="<?php echo e(route('admin.reviews.service.delete',$review->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure remove this review?'); ?>" data-btn_class="btn btn--primary">
                                                <i class="las la-desktop text--shadow"></i> <?php echo app('translator')->get('Delete'); ?>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($reviews->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($reviews)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>


    </div>

    <div class="modal fade" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo app('translator')->get('Review'); ?></h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><i class="las la-times"></i></button>
                </div>
                <div class="modal-body">
                    <p class="modal-detail"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark w-100" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                </div>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ConfirmationModal::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <div class="d-flex flex-wrap justify-content-end">
        <form action="" method="GET" class="form-inline">
            <div class="input-group justify-content-end">
                <input type="text" name="search" class="form-control bg--white" placeholder="<?php echo app('translator')->get('Search here'); ?>"
                    value="<?php echo e(request()->search); ?>">
                <button class="btn btn--primary input-group-text" type="submit"><i class="fa fa-search"></i></button>
            </div>
        </form>
    </div>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.viewBtn').on('click', function() {
                var modal = $('#viewModal');
                modal.find('.modal-detail').text($(this).data('review'));
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/admin/reviews/services.blade.php ENDPATH**/ ?>