<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center position-relative mb-4 flex-wrap gap-4">
    <span class="filter-toggle btn btn--base btn--sm h-100 d-none"> <i class="i las la-bars"></i></span>

    <div class="d-flex justify-content-between flex-wrap gap-3">

        <div class="d-flex align-items-start flex-wrap gap-2">
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.service.order.index')); ?>" aria-current="page" href="<?php echo e(route('influencer.service.order.index')); ?>"><?php echo app('translator')->get('All'); ?></a>
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.service.order.pending')); ?>" href="<?php echo e(route('influencer.service.order.pending')); ?>"><?php echo app('translator')->get('Pending'); ?> (<?php echo e($pendingOrder??0); ?>)</a>
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.service.order.inprogress')); ?>" href="<?php echo e(route('influencer.service.order.inprogress')); ?>"><?php echo app('translator')->get('Inprogessed'); ?></a>
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.service.order.jobDone')); ?>" href="<?php echo e(route('influencer.service.order.jobDone')); ?>"><?php echo app('translator')->get('Job Done'); ?></a>
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.service.order.completed')); ?>" href="<?php echo e(route('influencer.service.order.completed')); ?>"><?php echo app('translator')->get('Completed'); ?></a>
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.service.order.reported')); ?>" href="<?php echo e(route('influencer.service.order.reported')); ?>"><?php echo app('translator')->get('Reported'); ?></a>
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.service.order.cancelled')); ?>" href="<?php echo e(route('influencer.service.order.cancelled')); ?>"><?php echo app('translator')->get('Cancelled'); ?></a>
        </div>

        <form action="" class="ms-auto service-search-form">
            <div class="input-group">
                <input type="text" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Search here'); ?>">
                <button class="input-group-text bg--base border-0 text-white px-4">
                    <i class="las la-search"></i>
                </button>
            </div>
        </form>
    </div>

</div>
<div class="row mt-2">

    <div class="col-lg-12">
        <table class="table--responsive--lg table">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Order Number'); ?></th>
                    <th><?php echo app('translator')->get('Username'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Amount | Delivery'); ?></th>
                    <?php if(request()->routeIs('influencer.service.order.index')): ?>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <?php endif; ?>
                    <th class="text-center">Zoom Meet</th>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                    
                </tr>
            </thead>
            <tbody>

                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td data-label="<?php echo app('translator')->get('Order Number'); ?>">
                        <span><?php echo e($order->order_no); ?></span>
                    </td>

                    <td data-label="<?php echo app('translator')->get('User'); ?>">
                        <span class="fw-bold"><?php echo e(__(@$order->user->username)); ?></span>
                    </td>

                    <td data-label="<?php echo app('translator')->get('Amount | Delivery'); ?>" class="text-center">
                        <div>
                            <span class="fw-bold"><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($order->amount)); ?></span> <br>
                            <?php echo e($order->delivery_date); ?>

                        </div>
                    </td>

                    <?php if(request()->routeIs('influencer.service.order.index')): ?>
                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                        <?php echo $order->statusBadge ?>
                    </td>
                    <?php endif; ?>
                    <td data-label="<?php echo app('translator')->get('Zoom Meet'); ?>" class="text-center">
                        <?php if($order->zoom_link): ?>
                        <a href="<?php echo e($order->zoom_link); ?>" target="_blank" class="btn btn-sm btn-outline-success">
                            <i class="las la-video"></i> <?php echo app('translator')->get('Join'); ?>
                           
                        </a>
                    </br>
                    Password:<br>
                        <span class="badge bg-success"><?php echo e($order->password ?? ''); ?></span>
                        <?php else: ?>
                        <span class="badge bg-warning"><?php echo app('translator')->get('Not Available'); ?></span>
                        <?php endif; ?>
                    </td>

                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                        <div class="d-flex flex-wrap gap-2 justify-content-end">
                            <a href="<?php echo e(route('influencer.service.order.detail',$order->id)); ?>" class="btn btn-sm btn-outline-base">
                                <i class="las la-desktop"></i> <?php echo app('translator')->get('Detail'); ?>
                            </a>
                            <a href="<?php echo e(route('influencer.service.order.conversation.view',$order->id)); ?>" class="btn btn-sm btn-outline-info">
                                <i class="las la-sms"></i> <?php echo app('translator')->get('Chat'); ?>
                            </a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td class="justify-content-center text-center" colspan="100%">
                        <i class="la la-4x la-frown"></i>
                        <br>
                        <?php echo e(__($emptyMessage)); ?>

                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <?php echo e($orders->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/influencer/order/list.blade.php ENDPATH**/ ?>