<?php $__env->startSection('content'); ?>
<div class="wrapper">
    <div class="preloader"></div>

    <div class="dashboard_content_wrapper">
        <div class="dashboard dashboard_wrapper pr30 pr0-xl">
            <div class="dashboard__sidebar d-none d-lg-block">
                <?php echo $__env->make($activeTemplate . 'user.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="dashboard__main pl0-md">
                <div class="dashboard__content hover-bgc-color">
                    <div class="row pb40">
                        <div class="col-lg-6">
                            <div class="dashboard_title_area">
                                <h2><?php echo app('translator')->get('Crează Tichet Nou'); ?></h2>
                            </div>
                        </div>
                        <div class="col-lg-6 d-flex justify-content-end">
                            <a href="<?php echo e(route('influencer.ticket')); ?>"
                                    class="table-action fz15 fw500 text-thm2"><?php echo app('translator')->get('Tichete Deschise'); ?></a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                <div class="col-lg-12">
                                    <form class="form-style1" action="<?php echo e(route('influencer.ticket.store')); ?>"
                                        method="post" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="name" value="<?php echo e(@$user->fullname); ?>">
                                        <input type="hidden" name="email" value="<?php echo e(@$user->email); ?>">

                                        <div class="row justify-content-between">
                                            <div class="col-lg-12 mb10">
                                                <div class="form-group">
                                                    <label for="subject" class="form-label"><?php echo app('translator')->get('Subiect'); ?></label>
                                                    <input type="text" id="subject" name="subject"
                                                        value="<?php echo e(old('subject')); ?>" class="form-control form--control"
                                                        required>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb10">
                                                <div class="form-group">
                                                    <label class="form-label"><?php echo app('translator')->get('Prioritate'); ?></label>
                                                    <select name="priority"
                                                        class="form-control form--control form-select" required>
                                                        <option value="1"><?php echo app('translator')->get('Low'); ?></option>
                                                        <option value="2"><?php echo app('translator')->get('Medium'); ?></option>
                                                        <option value="3"><?php echo app('translator')->get('High'); ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb10">
                                                <div class="form-group">
                                                    <label for="message" class="form-label"><?php echo app('translator')->get('Message'); ?></label>
                                                    <textarea id="message" name="message" class="form-control form--control" required><?php echo e(old('message')); ?></textarea>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb10">
                                                <div class="form-group">
                                                    <label class="form-label"><?php echo app('translator')->get('Attachments'); ?></label>
                                                    <div class="form-group d-flex gap-2">
                                                        <input type="file" class="form-control form--control"
                                                            name="attachments[]" id="file2">
                                                        <button class="btn btn--base addFile border-0" type="button">
                                                            <i class="las la-plus"></i>
                                                        </button>
                                                    </div>
                                                    <div id="more-attachment"></div>
                                                    <span class="info fs-sm">
                                                        <?php echo app('translator')->get('Allowed File Extensions'); ?>: .<?php echo app('translator')->get('jpg'); ?>,
                                                        .<?php echo app('translator')->get('jpeg'); ?>, .<?php echo app('translator')->get('png'); ?>,
                                                        .<?php echo app('translator')->get('pdf'); ?>, .<?php echo app('translator')->get('doc'); ?>,
                                                        .<?php echo app('translator')->get('docx'); ?>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb10">
                                                <button type="submit" class="table-action w-100">
                                                    <i class="fa fa-reply"></i> <?php echo app('translator')->get('Trimite'); ?>
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            </footer>
                        </div>
                    </div>
                </div>
                <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .input-group-text:focus {
            box-shadow: none !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addFile').on('click', function() {
                if (fileAdded >= 4) {
                    notify('error', 'You\'ve added maximum number of file');
                    return false;
                }
                fileAdded++;
                $("#more-attachment").append(`
                    <div class="form-group d-flex gap-2 mt-3">
                        <input type="file" class="form-control form--control " name="attachments[]" id="file2">
                        <button class="btn btn--danger border-0 remove-btn" type="button"><i class="las la-times"></i></button>
                    </div>
                `)
            });
            $(document).on('click', '.remove-btn', function() {
                fileAdded--;
                $(this).closest('.form-group').remove();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/user/support/create2.blade.php ENDPATH**/ ?>