
<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Order Number'); ?></th>
                                <th><?php echo app('translator')->get('User'); ?></th>
                                <th><?php echo app('translator')->get('Influencer'); ?></th>
                                <th><?php echo app('translator')->get('Amount'); ?></th>
                                <th><?php echo app('translator')->get('Delivery Date'); ?></th>
                                <?php if(request()->routeIs('admin.order.index')): ?>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <?php endif; ?>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td data-label="<?php echo app('translator')->get('Order Number'); ?>">
                                        <span class="fw-bold"><?php echo e($order->order_no); ?></span>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('User'); ?>">
                                        <span class="small">
                                            <a href="<?php echo e(route('admin.users.detail', $order->user_id)); ?>"><span>@</span><?php echo e(@$order->user->username); ?></a>
                                        </span>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Influencer'); ?>">
                                        <span class="small">
                                            <a href="<?php echo e(route('admin.influencers.detail', $order->influencer_id)); ?>"><span>@</span><?php echo e(@$order->influencer->username); ?></a>
                                        </span>
                                    </td>
                                    
                                    <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                        <span class="fw-bold"><?php echo e(showAmount($order->amount)); ?> <?php echo e($general->cur_text); ?></span>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Delivery Date'); ?>">
                                        <span><?php echo e($order->delivery_date); ?></span>
                                    </td>
                                    <?php if(request()->routeIs('admin.order.index')): ?>
                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                        <?php echo $order->statusBadge ?>
                                    </td>
                                    <?php endif; ?>

                                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                        <a href="<?php echo e(route('admin.order.detail', $order->id)); ?>" class="btn btn-sm btn-outline--primary">
                                            <i class="las la-desktop text--shadow"></i> <?php echo app('translator')->get('Details'); ?>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($orders->hasPages()): ?>
                <div class="card-footer py-4">
                    <?php echo e(paginateLinks($orders)); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>


    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('breadcrumb-plugins'); ?>
    <div class="d-flex flex-wrap justify-content-end">
        <form action="" method="GET" class="form-inline">
            <div class="input-group justify-content-end">
                <input type="text" name="search" class="form-control bg--white" placeholder="<?php echo app('translator')->get('Search influencer or category'); ?>" value="<?php echo e(request()->search); ?>">
                <button class="btn btn--primary input-group-text" type="submit"><i class="fa fa-search"></i></button>
            </div>
        </form>
    </div>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/admin/order/list.blade.php ENDPATH**/ ?>