<?php
    $kycContent = getContent('influencer_kyc.content', true);
?>

<?php $__env->startSection('content'); ?>
    <?php if(authInfluencer()->kv == 0): ?>
        <div class="alert alert-info" role="alert">
            <h4 class="alert-heading"><?php echo app('translator')->get('KYC Verification required'); ?></h4>
            <hr>
            <p class="mb-0"><?php echo e(__($kycContent->data_values->verification_content)); ?>

                <a href="<?php echo e(route('influencer.kyc.form')); ?>" class="text--base"><?php echo app('translator')->get('Click Here to Verify'); ?></a>
            </p>
        </div>
    <?php elseif(authInfluencer()->kv == 2): ?>
        <div class="alert alert-warning" role="alert">
            <h4 class="alert-heading"><?php echo app('translator')->get('KYC Verification pending'); ?></h4>
            <hr>
            <p class="mb-0"><?php echo e(__($kycContent->data_values->pending_content)); ?>

                <a href="<?php echo e(route('influencer.kyc.data')); ?>" class="text--base"><?php echo app('translator')->get('See KYC Data'); ?></a>
            </p>
        </div>
    <?php endif; ?>
    <div class="wrapper">
        <div class="preloader"></div>

        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    <?php echo $__env->make($activeTemplate . 'influencer.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <div class="row pb40">
                            <div class="col-lg-9">
                                <div class="dashboard_title_area">

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                    <div class="row mb10">
                                        <div class="col-lg-6 d-flex justify-content-start">
                                            <h4> [<?php echo app('translator')->get('Ticket'); ?>#<?php echo e($myTicket->ticket); ?>]
                                                <?php echo e($myTicket->subject); ?>

                                                <?php if($myTicket->status == 0): ?>
                                                <span class="pending-style style1"><?php echo app('translator')->get('Deschis'); ?></span>
                                              <?php elseif($myTicket->status == 1): ?>
                                                <span class="pending-style style2"><?php echo app('translator')->get('Raspuns'); ?></span>
                                              <?php elseif($myTicket->status == 2): ?>
                                                <span class="pending-style style2"><?php echo app('translator')->get('Trimis'); ?></span>
                                                <?php elseif($myTicket->status == 3): ?>
                                                <span class="pending-style style3"><?php echo app('translator')->get('Închis'); ?></span>
                                              <?php endif; ?></h4>
                                                
                                        </div>
                                        <div class="col-lg-6 d-flex justify-content-end">
                                            <?php if($myTicket->status != 3 && $myTicket->influencer): ?>
                                                <a href="<?php echo e(route('influencer.ticket.close', $myTicket->id)); ?>" 
                                                    class="pending-style style3 d-inline-flex align-items-center"
                                                    data-question="<?php echo app('translator')->get('Ești sigur că vrei să anulezi tichetul?'); ?>">
                                                     <i class="fa-regular fa-times-circle mr5"></i> <?php echo app('translator')->get('Anulează Tichetul'); ?> 
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <?php if($myTicket->status != 4): ?>
                                            <form class="form-style1" action="<?php echo e(route('ticket.reply', $myTicket->id)); ?>"
                                                method="post" enctype="multipart/form-data">
                                                <?php echo csrf_field(); ?>
                                                <div class="row justify-content-between">
                                                    <div class="col-lg-12">
                                                        <div class="form-group">
                                                            <textarea name="message" class="form-control form--control shadow-none" id="inputMessage"
                                                                placeholder="<?php echo app('translator')->get('Mesajul'); ?>" rows="4" cols="10"><?php echo e(old('message')); ?></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12">
                                                        <div class="form-group">
                                                            <label for="inputAttachments"
                                                                class="form-label"><?php echo app('translator')->get('Attachments'); ?></label>
                                                            <small class="text-danger"><?php echo app('translator')->get('Max 5 files can be uploaded'); ?>. <?php echo app('translator')->get('Maximum upload size is'); ?>
                                                                <?php echo e(ini_get('upload_max_filesize')); ?></small>
                                                            <div class="d-flex gap-2">
                                                                <input type="file" name="attachments[]"
                                                                    id="inputAttachments"
                                                                    class="form--control form-control radius-5">
                                                                <a href="javascript:void(0)"
                                                                    class="btn btn--base d-flex align-items-center addFile">
                                                                    <i class="las la-plus"></i>
                                                                </a>
                                                            </div>
                                                            <div id="fileUploadsContainer"></div>
                                                            <p class="ticket-attachments-message text-muted mt-1">
                                                                <?php echo app('translator')->get('Allowed File Extensions'); ?>: .<?php echo app('translator')->get('jpg'); ?>,
                                                                .<?php echo app('translator')->get('jpeg'); ?>, .<?php echo app('translator')->get('png'); ?>,
                                                                .<?php echo app('translator')->get('pdf'); ?>,
                                                                .<?php echo app('translator')->get('doc'); ?>, .<?php echo app('translator')->get('docx'); ?>
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12">
                                                        <button type="submit" class="table-action fz15 fw500 text-thm2">
                                                            <i class="fa fa-reply"></i> <?php echo app('translator')->get('Trimite'); ?>
                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                </footer>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-12">
                                <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($message->admin_id == 0): ?>
                                        <div
                                            class="row border-primary border-radius-3 ticket-reply-user my-sm-3 mx-sm-2 my-2 mx-0 border py-3">
                                            <div class="col-md-3 border--right text-right">
                                                <h5 class="text--base my-3"><?php echo e(@$message->ticket->name); ?></h5>
                                            </div>
                                            <div class="col-md-9 ps-2">
                                                <p class="text-muted fw-bold">
                                                    <?php echo app('translator')->get('Posted on'); ?>
                                                    <?php echo e($message->created_at->format('l, dS F Y @ H:i')); ?>

                                                </p>
                                                <p>
                                                    <?php echo e($message->message); ?>

                                                </p>
                                                <?php if($message->attachments->count() > 0): ?>
                                                    <div class="mt-2">
                                                        <?php $__currentLoopData = $message->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <a href="<?php echo e(route('influencer.ticket.download', encrypt($image->id))); ?>"
                                                                class="text--base mr-3"><i class="fa fa-file"></i>
                                                                <?php echo app('translator')->get('Attachment'); ?> <?php echo e(++$k); ?> </a>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div
                                            class="row border-warning border-radius-3 my-sm-3 mx-sm-2 my-2 mx-0 border py-3">
                                            <div class="col-md-3 border--right text-right">
                                                <h5 class="text--base my-3"><?php echo e(@$message->admin->name); ?></h5>
                                            </div>
                                            <div class="col-md-9 ps-2">
                                                <p class="text-muted fw-bold"><?php echo app('translator')->get('Trimis la data'); ?>
                                                    <?php echo e($message->created_at->format('l, dS F Y @ H:i')); ?></p>
                                                <p><?php echo e($message->message); ?></p>
                                                <?php if($message->attachments->count() > 0): ?>
                                                    <div class="mt-2">
                                                        <?php $__currentLoopData = $message->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <a href="<?php echo e(route('influencer.ticket.download', encrypt($image->id))); ?>"
                                                                class="text--base mr-3"><i class="fa fa-file"></i>
                                                                <?php echo app('translator')->get('Attachment'); ?> <?php echo e(++$k); ?> </a>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                    <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/influencer/support/view2.blade.php ENDPATH**/ ?>