<?php $__env->startSection('content'); ?>
    <section class="story-section pt-80 pb-80" style="margin-top: 100px;">
        <div class="container">
            <div class="row">
                <div class="col-xl-3">
                    <div class="d-flex flex-wrap justify-content-between gap-4 dash-sidebar filter-sidebar p-xl-0 shadow-none">
                        
                        <div class="w-100 search-widget">
                            <div class="input-group">
                                <input type="text" name="" class="form-control form--control mySearch" placeholder="<?php echo app('translator')->get('Search here'); ?>" value="<?php echo e(request()->search); ?>">
                                <button class="input-group-text bg--base border--base border-0 searchBtn px-3 text-white" type="button"><i class="fas fa-search"></i></button>
                            </div>
                        </div>

                        <?php if(@$allCategory): ?>
                            <div class="sidebar-widget w-100">
                                <h6 class="sidebar-widget__title"><?php echo app('translator')->get('Categories'); ?></h6>
                                <div class="checkbox-wrapper">
                                    <div class="custom--checkbox">
                                        <input class="form-check-input sortCategory" type="checkbox" name="category" value="" id="category0" checked>
                                        <label class="form-check-label" for="category0"><?php echo app('translator')->get('All Categories'); ?></label>
                                    </div>
                                    <?php $__currentLoopData = $allCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="custom--checkbox my-2">
                                            <input class="form-check-input sortCategory" type="checkbox" name="category" value="<?php echo e($category->id); ?>" id="category<?php echo e($category->id); ?>">
                                            <label class="form-check-label" for="category<?php echo e($category->id); ?>"><?php echo e(__($category->name)); ?></label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="sidebar-widget">
                            <h6 class="sidebar-widget__title"><?php echo app('translator')->get('Sort by'); ?></h6>
                            <div class="radio-wrapper">
                                <div class="form-check custom--radio mb-2">
                                    <input class="form-check-input sortService" type="radio" value="id_desc" name="sort" id="service1" checked>
                                    <label class="form-check-label" for="service1">
                                        <?php echo app('translator')->get('Latest'); ?>
                                    </label>
                                </div>
                                <div class="form-check custom--radio mb-2">
                                    <input class="form-check-input sortService" type="radio" value="price_asc" name="sort" id="service2">
                                    <label class="form-check-label" for="service2">
                                        <?php echo app('translator')->get('Low to High Price'); ?>
                                    </label>
                                </div>
                                <div class="form-check custom--radio mb-2">
                                    <input class="form-check-input sortService" type="radio" value="price_desc" name="sort" id="service3">
                                    <label class="form-check-label" for="service3">
                                        <?php echo app('translator')->get('High to Low Price'); ?>
                                    </label>
                                </div>
                            </div>
                            <div class="input-group mt-3">
                                <input type="text" name="min" class="form--control form-control form-control-sm" placeholder="<?php echo app('translator')->get('Min'); ?>">
                                <input type="text" name="max" class="form--control form-control form-control-sm" placeholder="<?php echo app('translator')->get('Max'); ?>">
                                <button type="button" class="btn btn--base priceBtn px-3"><i class="las la-angle-right"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-9 position-relative">
                    
                    <div class="loader-wrapper">
                        <div class="loader-pre"></div>
                    </div>
                    <div class="row gy-4 justify-content-center" id="services">
                        <?php echo $__env->make($activeTemplate . 'service.filtered', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php if($sections->secs != null): ?>
        <?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make($activeTemplate . 'sections.' . $sec, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/custom.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            let page = null;
            $('.loader-wrapper').addClass('d-none');
            $('.sortCategory, .sortService').on('click', function() {
                $('#category0').removeAttr('checked','checked');
                if ($('#category0').is(':checked')) {
                    $("input[type='checkbox'][name='category']").not(this).prop('checked', false);
                }

                if($("input[type='checkbox'][name='category']:checked").length == 0){
                    $('#category0').attr('checked','checked');
                }
                fetchService();
            });

            $('.searchBtn').on('click', function() {
                $(this).attr('disabled', 'disabled');
                fetchService();
            });

            $('.priceBtn').on('click', function() {
                fetchService();
            });


            function fetchService() {
                $('.loader-wrapper').removeClass('d-none');
                let data = {};
                data.categories = [];

                $.each($("[name=category]:checked"), function() {
                    if ($(this).val()) {
                        data.categories.push($(this).val());
                    }
                });

                data.search = $('.mySearch').val();
                data.sort = $('.sortService:checked').val();
                data.min = $("[name=min]").val();
                data.max = $("[name=max]").val();
                data.tagId = "<?php echo e(@$id); ?>";

                let url = `<?php echo e(route('service.filter')); ?>`;

                if (page) {
                    url = `<?php echo e(route('service.filter')); ?>?page=${page}`;
                }

                $.ajax({
                    method: "GET",
                    url: url,
                    data: data,
                    success: function(response) {
                        $('#services').html(response);
                        $('.searchBtn').removeAttr('disabled');
                    }
                }).done(function() {
                    $('.loader-wrapper').addClass('d-none')
                });
            }

            $(document).on('click', '.pagination a', function(event) {
                event.preventDefault();
                page = $(this).attr('href').split('page=')[1];
                fetchService();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/service/list.blade.php ENDPATH**/ ?>