<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center position-relative mb-4 flex-wrap gap-4">
    <span class="filter-toggle btn btn--base btn--sm h-100 d-none"> <i class="i las la-bars"></i></span>

    <div class="d-flex justify-content-between flex-wrap gap-3">

        <div class="d-flex align-items-start flex-wrap gap-2">
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.hiring.index')); ?>" aria-current="page" href="<?php echo e(route('influencer.hiring.index')); ?>"><?php echo app('translator')->get('All'); ?></a>
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.hiring.pending')); ?>" href="<?php echo e(route('influencer.hiring.pending')); ?>"><?php echo app('translator')->get('Pending'); ?> (<?php echo e($pendingHiring??0); ?>)</a>
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.hiring.inprogress')); ?>" href="<?php echo e(route('influencer.hiring.inprogress')); ?>"><?php echo app('translator')->get('Inprogessed'); ?></a>
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.hiring.jobDone')); ?>" href="<?php echo e(route('influencer.hiring.jobDone')); ?>"><?php echo app('translator')->get('Job Done'); ?></a>
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.hiring.completed')); ?>" href="<?php echo e(route('influencer.hiring.completed')); ?>"><?php echo app('translator')->get('Completed'); ?></a>
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.hiring.reported')); ?>" href="<?php echo e(route('influencer.hiring.reported')); ?>"><?php echo app('translator')->get('Reported'); ?></a>
            <a class="btn btn--outline-custom <?php echo e(menuActive('influencer.hiring.cancelled')); ?>" href="<?php echo e(route('influencer.hiring.cancelled')); ?>"><?php echo app('translator')->get('Cancelled'); ?></a>
        </div>

        <form action="" class="ms-auto service-search-form">
            <div class="input-group">
                <input type="text" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Search here'); ?>">
                <button class="input-group-text bg--base border-0 text-white px-4">
                    <i class="las la-search"></i>
                </button>
            </div>
        </form>
    </div>

</div>
<div class="row mt-2">
    <div class="col-lg-12">
        <table class="table--responsive--lg table">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Hiring Number'); ?></th>
                    <th><?php echo app('translator')->get('Username'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Amount | Delivery'); ?></th>
                    <?php if(request()->routeIs('influencer.hiring.index')): ?>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <?php endif; ?>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $hirings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hiring): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td data-label="<?php echo app('translator')->get('Hiring Number'); ?>">
                        <?php echo e($hiring->hiring_no); ?>

                    </td>

                    <td data-label="<?php echo app('translator')->get('User'); ?>">
                        <span class="fw-bold"><?php echo e(__(@$hiring->user->username)); ?></span>
                    </td>

                    <td data-label="<?php echo app('translator')->get('Amount | Delivery'); ?>" class="text-center">
                        <div>
                            <span class="fw-bold"><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($hiring->amount)); ?></span><br>
                            <?php echo e($hiring->delivery_date); ?>

                        </div>
                    </td>

                    <?php if(request()->routeIs('influencer.hiring.index')): ?>
                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                        <?php echo $hiring->statusBadge ?>
                    </td>
                    <?php endif; ?>

                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                        <div class="d-flex flex-wrap gap-2 justify-content-end">
                            <a href="<?php echo e(route('influencer.hiring.detail',$hiring->id)); ?>" class="btn btn--sm btn--outline-base">
                                <i class="la la-desktop"></i> <?php echo app('translator')->get('Detail'); ?>
                            </a>

                            <a href="<?php echo e(route('influencer.hiring.conversation.view',$hiring->id)); ?>" class="btn btn--sm btn--outline-info">
                                <i class="las la-sms"></i> <?php echo app('translator')->get('Chat'); ?>
                            </a>

                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td class="justify-content-center text-center" colspan="100%">
                        <i class="la la-4x la-frown"></i>
                        <br>
                        <?php echo e(__($emptyMessage)); ?>

                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <?php echo e($hirings->links()); ?>

    </div>
</div>

<?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ConfirmationModal::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
<style>
    .status-square {
        background: #1ca0f278;
        border: #1ca0f278;
    }

    .status-times {
        background: #ea535378;
        border: #ea535378;
    }

    .nav-link {
        color: rgb(var(--base));
    }
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/influencer/hiring/list.blade.php ENDPATH**/ ?>