<?php
$favorite    = App\Models\Favorite::where('user_id', auth()->id())->select('influencer_id')->pluck('influencer_id');
$influencersId = json_decode($favorite);
$emptyMsgImage = getContent('empty_message.content', true);
?>
<?php if(request()->search): ?>
<p><?php echo app('translator')->get('Search Result For'); ?> <span class="text--base"><?php echo e(__(request()->search)); ?></span> : <?php echo app('translator')->get('Total'); ?> <span class="text--base"><?php echo e($influencers->count()); ?></span> <?php echo app('translator')->get('Influencers Found'); ?></p>
<?php endif; ?>
<?php $__empty_1 = true; $__currentLoopData = $influencers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $influencer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<div class="col-md-6 col-lg-4 col-xl-4 col-sm-9 col-xs-10">
    <div class="influencer-item">
        <?php if(auth()->guard()->check()): ?>
            <?php if(in_array($influencer->id, @$influencersId)): ?>
            <a href="javascript:void(0)" class="favoriteBtn active" data-influencer_id="<?php echo e($influencer->id); ?>"><i class="las la-heart"></i></a>
            <?php else: ?>
            <a href="javascript:void(0)" class="favoriteBtn" data-influencer_id="<?php echo e($influencer->id); ?>"><i class="lar la-heart"></i></a>
            <?php endif; ?>
        <?php endif; ?>
        <div class="influencer-thumb">
            <img src="<?php echo e(getImage(getFilePath('influencerProfile') . '/' . $influencer->image, getFileSize('influencerProfile'), true)); ?>" alt="cover">
            <span class="influencer-status <?php if($influencer->isOnline()): ?> active <?php endif; ?>"></span>
        </div>

        <div class="influencer-item__content">

            <h5 class="name text--muted"><?php echo e(__($influencer->fullname)); ?></h5>
            <p class="text--muted"><?php echo e(__($influencer->profession)); ?></p>

            <div class="rating d-flex justify-content-center align-items-center mt-2">

                <span class="me-1">
                    <?php
                    echo showRatings($influencer->rating);
                    ?>
                </span>
                (<?php echo e(getAmount($influencer->total_review) ?? 0); ?>)
            </div>


            <div class="d-flex justify-content-center mt-3 flex-wrap gap-4">
                <a href="<?php echo e(route('influencer.profile', [slug($influencer->username), $influencer->id])); ?>" class="btn btn--sm btn--outline-base radius-0"><?php echo app('translator')->get('View Profile'); ?></a>
            </div>

            <ul class="social-links d-flex justify-content-center flex-wrap">
                <?php $__currentLoopData = $influencer->socialLink; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><a href="<?php echo e($social->url); ?>" data-bs-toggle="tooltip" data-placement="top" title="<?php echo e(__($social->followers)); ?>"><?php echo $social->social_icon ?></a></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php
        $skills = array_slice($influencer->skills ?? [], 0, 4);
        ?>
        <div class="skills-wrapper">
            <?php if($influencer->skills): ?>
            <?php $__currentLoopData = @$skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <span class="skill"><?php echo e(__($skill)); ?></span>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
            <span class="skill m-auto"><?php echo app('translator')->get('No Specific Skill'); ?></span>
            <?php endif; ?>
        </div>


    </div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<div class="col-md-6 col-lg-8">
    <img src="<?php echo e(getImage('assets/images/frontend/empty_message/' . @$emptyMsgImage->data_values->image, '800x600')); ?>" alt="" class="w-100">
</div>
<?php endif; ?>
<?php echo e($influencers->links()); ?>


<script>
    try {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            })
    } catch (error) {

    }
</script>
<?php /**PATH /home/infu.nibiru-it.ro/public_html/core/resources/views/templates/basic/filtered_influencer.blade.php ENDPATH**/ ?>