<?php
$kycContent = getContent('influencer_kyc.content', true);
?>

<?php $__env->startSection('content'); ?>
<?php if(authInfluencer()->kv == 0): ?>
<div class="alert alert-info" role="alert">
    <h4 class="alert-heading"><?php echo app('translator')->get('KYC Verification required'); ?></h4>
    <hr>
    <p class="mb-0"><?php echo e(__($kycContent->data_values->verification_content)); ?>

        <a href="<?php echo e(route('influencer.kyc.form')); ?>" class="text--base"><?php echo app('translator')->get('Click Here to Verify'); ?></a>
    </p>
</div>
<?php elseif(authInfluencer()->kv == 2): ?>
<div class="alert alert-warning" role="alert">
    <h4 class="alert-heading"><?php echo app('translator')->get('KYC Verification pending'); ?></h4>
    <hr>
    <p class="mb-0"><?php echo e(__($kycContent->data_values->pending_content)); ?>

        <a href="<?php echo e(route('influencer.kyc.data')); ?>" class="text--base"><?php echo app('translator')->get('See KYC Data'); ?></a>
    </p>
</div>
<?php endif; ?>
<div class="row justify-content-center gy-4">
    <div class="col-xxl-4 col-md-6 col-sm-10">
        <div class="dashboard-widget widget--base">
            <div class="dashboard-widget__icon">
                <i class="las la-money-check"></i>
            </div>
            <div class="dashboard-widget__content">
                <p><?php echo app('translator')->get('Current Balance'); ?></p>
                <h4 class="title"><?php echo e(showAmount($data['current_balance'])); ?> <?php echo e($general->cur_text); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-md-6 col-sm-10">
        <div class="dashboard-widget widget--primary">
            <div class="dashboard-widget__icon">
                <i class="las la-wallet"></i>
            </div>
            <div class="dashboard-widget__content">
                <p><?php echo app('translator')->get('Total Withdrawn'); ?></p>
                <h4 class="title"><?php echo e(showAmount($data['withdraw_balance'])); ?> <?php echo e($general->cur_text); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-md-6 col-sm-10">
        <div class="dashboard-widget widget--secondary">
            <div class="dashboard-widget__icon">
                <i class="las la-exchange-alt"></i>
            </div>
            <div class="dashboard-widget__content">
                <p><?php echo app('translator')->get('Total Transaction'); ?></p>
                <h4 class="title"><?php echo e($data['total_transaction']); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-md-6 col-sm-10">
        <div class="dashboard-widget widget--info">
            <div class="dashboard-widget__icon">
                <i class="las la-list"></i>
            </div>
            <div class="dashboard-widget__content">
                <p><?php echo app('translator')->get('Total Hiring'); ?></p>
                <h4 class="title"><?php echo e($data['total_hiring']); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-md-6 col-sm-10">
        <div class="dashboard-widget widget--purple">
            <div class="dashboard-widget__icon">
                <i class="las la-list-ol"></i>
            </div>
            <div class="dashboard-widget__content">
                <p><?php echo app('translator')->get('Total Order'); ?></p>
                <h4 class="title"><?php echo e($data['total_order']); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-md-6 col-sm-10">
        <div class="dashboard-widget widget--warning">
            <div class="dashboard-widget__icon">
                <i class="las la-list-alt"></i>
            </div>
            <div class="dashboard-widget__content">
                <p><?php echo app('translator')->get('Total Service'); ?></p>
                <h4 class="title"><?php echo e($data['total_service']); ?></h4>
            </div>
        </div>
    </div>
</div>
<div class="row d-flex justify-content-center">
    <div class="col-md-6">
        <div class="job__completed my-4">
            <div class="job__completed-header d-flex align-items-center justify-content-between">
                <h5><?php echo app('translator')->get('Order Status'); ?></h5>
            </div>
            <div class="job__completed-body">
                <div id="orderChart"></div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="job__completed my-4">
            <div class="job__completed-header d-flex align-items-center justify-content-between">
                <h5><?php echo app('translator')->get('Hiring Status'); ?></h5>
            </div>
            <div class="job__completed-body">
                <div id="hiringChart"></div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function() {
            var options = {
                series: [
                    <?php echo e($data['pending_order']); ?>,
                    <?php echo e($data['completed_order']); ?>,
                    <?php echo e($data['inprogress_order']); ?>,
                    <?php echo e($data['cancelled_order']); ?>,
                    <?php echo e($data['job_done_order']); ?>,
                    <?php echo e($data['reported_order']); ?>,
                    <?php echo e($data['rejected_order']); ?>

                ],
                chart: {
                width: 380,
                type: 'pie',
                },
                labels: [
                    `Pending (<?php echo e(@$data['pending_order']); ?>)`,
                    `Completed (<?php echo e(@$data['completed_order']); ?>)`,
                    `Inprogress (<?php echo e(@$data['inprogress_order']); ?>)`,
                    `Cancelled (<?php echo e(@$data['cancelled_order']); ?>)`,
                    `Job Done (<?php echo e(@$data['job_done_order']); ?>)`,
                    `Reported (<?php echo e(@$data['reported_order']); ?>)`,
                    `Rejected (<?php echo e(@$data['rejected_order']); ?>)`
                ],
                colors: [
                    "#868e96",
                    "#28c76f",
                    "#4634ff",
                    "#071251",
                    "#1e9ff2",
                    "#ff9f43",
                    "#ea5455"
                ],
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 200
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }]
            };

            var chart = new ApexCharts(document.querySelector("#orderChart"), options);
            chart.render();

            var options = {
                series: [
                    <?php echo e($data['pending_hiring']); ?>,
                    <?php echo e($data['completed_hiring']); ?>,
                    <?php echo e($data['inprogress_hiring']); ?>,
                    <?php echo e($data['cancelled_hiring']); ?>,
                    <?php echo e($data['job_done_hiring']); ?>,
                    <?php echo e($data['reported_hiring']); ?>,
                    <?php echo e($data['rejected_hiring']); ?>

                ],
                chart: {
                width: 380,
                type: 'pie',
                },
                labels: [
                    `Pending (<?php echo e(@$data['pending_hiring']); ?>)`,
                    `Completed (<?php echo e(@$data['completed_hiring']); ?>)`,
                    `Inprogress (<?php echo e(@$data['inprogress_hiring']); ?>)`,
                    `Cancelled (<?php echo e(@$data['cancelled_hiring']); ?>)`,
                    `Job Done (<?php echo e(@$data['job_done_hiring']); ?>)`,
                    `Reported (<?php echo e(@$data['reported_hiring']); ?>)`,
                    `Rejected (<?php echo e(@$data['rejected_hiring']); ?>)`
                ],
                colors: [
                    "#868e96",
                    "#28c76f",
                    "#4634ff",
                    "#071251",
                    "#1e9ff2",
                    "#ff9f43",
                    "#ea5455"
                ],
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 200
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }]
            };

            var chart = new ApexCharts(document.querySelector("#hiringChart"), options);
            chart.render();

        });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/infu.nibiru-it.ro/public_html/core/resources/views/templates/basic/influencer/dashboard.blade.php ENDPATH**/ ?>