<?php $__env->startSection('content'); ?>
    <div class="card custom--card">
        <div class="card-header d-flex align-items-center justify-content-between flex-wrap">
            <h4 class="card-title m-0"><?php echo e($pageTitle); ?></h4>
            <a href="<?php echo e(route('ticket')); ?>" class="btn btn--outline-custom btn--sm"><?php echo app('translator')->get('My Tickets'); ?></a>
        </div>
        <div class="card-body">
            <form class="row gy-3" action="<?php echo e(route('ticket.store')); ?>" method="post" enctype="multipart/form-data" onsubmit="return submitUserForm();">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="name" value="<?php echo e(@$user->fullname); ?>">
                <input type="hidden" name="email" value="<?php echo e(@$user->email); ?>">

                <div class="form--group col-sm-12">
                    <label for="subject" class="form-label"><?php echo app('translator')->get('Subject'); ?></label>
                    <input type="text" id="subject" name="subject" value="<?php echo e(old('subject')); ?>"
                           class="form-control form--control" required>
                </div>
                <div class="form--group col-md-12">
                    <label class="form-label"><?php echo app('translator')->get('Priority'); ?></label>
                    <select name="priority" class="form-control form--control form-select" required>
                        <option value="3"><?php echo app('translator')->get('High'); ?></option>
                        <option value="2"><?php echo app('translator')->get('Medium'); ?></option>
                        <option value="1"><?php echo app('translator')->get('Low'); ?></option>
                    </select>
                </div>
                <div class="form--group col-sm-12">
                    <label for="message" class="form-label"><?php echo app('translator')->get('Message'); ?></label>
                    <textarea id="message" name="message" class="form-control form--control" required><?php echo e(old('message')); ?></textarea>
                </div>
                <div class="form--group col-sm-12">
                    <label class="form-label"><?php echo app('translator')->get('Attachments'); ?></label>
                    <div class="form-group d-flex gap-2">
                        <input type="file" class="form-control form--control" name="attachments[]" id="file2">
                        <button class="btn btn--base addFile border-0" type="button">
                            <i class="las la-plus"></i>
                        </button>
                    </div>
                    <div id="more-attachment">

                    </div>
                    <span class="info fs-sm">
                        <?php echo app('translator')->get('Allowed File Extensions'); ?>: .<?php echo app('translator')->get('jpg'); ?>, .<?php echo app('translator')->get('jpeg'); ?>, .<?php echo app('translator')->get('png'); ?>,
                        .<?php echo app('translator')->get('pdf'); ?>, .<?php echo app('translator')->get('doc'); ?>, .<?php echo app('translator')->get('docx'); ?>
                    </span>
                </div>
                <div class="col-sm-12">
                    <button class="btn btn--base w-100" type="submit" id="recaptcha"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .input-group-text:focus {
            box-shadow: none !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addFile').on('click', function() {
                if (fileAdded >= 4) {
                    notify('error', 'You\'ve added maximum number of file');
                    return false;
                }
                fileAdded++;
                $("#more-attachment").append(`
                    <div class="form-group d-flex gap-2 mt-3">
                        <input type="file" class="form-control form--control " name="attachments[]" id="file2">
                        <button class="btn btn--danger border-0 remove-btn" type="button"><i class="las la-times"></i></button>
                    </div>
                `)
            });
            $(document).on('click', '.remove-btn', function() {
                fileAdded--;
                $(this).closest('.form-group').remove();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/user/support/create.blade.php ENDPATH**/ ?>