<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center gy-4">
        <div class="col-md-5">
            <div class="card custom--card">
                <div class="card-header">
                    <h5 class="title"><?php echo app('translator')->get('Client Information'); ?></h5>
                </div>

                <div class="card-body p-3">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Name'); ?></span>
                            <span><?php echo e(__(@$order->user->fullname)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Email'); ?></span>
                            <span><?php echo e(__(@$order->user->email)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Country'); ?></span>
                            <span><?php echo e(__(@$order->user->address->country)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Member Since'); ?></span>
                            <span><?php echo e(showDateTime($order->user->created_at, 'd M, Y')); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Total Order Offered'); ?></span>
                            <span><?php echo e(__(@$order->user->orderCompleted()->count())); ?></span>
                        </li>
                    </ul>
                </div>
            </div>

            <?php if($order->status == 0 || $order->status == 2): ?>
                <div class="card custom--card mt-4">
                    <div class="card-header">
                        <h5 class="title"><?php echo app('translator')->get('Take Action'); ?></h5>
                    </div>

                    <div class="card-body">
                        <div class="d-flex flex-wrap gap-2">
                            <?php if($order->status == 0): ?>
                                <button type="button" class="btn btn-sm btn-outline-danger confirmationBtn"
                                    data-action="<?php echo e(route('influencer.service.order.cancel.status', $order->id)); ?>"
                                    data-question="<?php echo app('translator')->get('Are you sure to cancel this order?'); ?>" data-btn_class="btn btn-base btn-md">
                                    <i class="las la-times"></i> <?php echo app('translator')->get('Cancel'); ?>
                                </button>
                                <button id="generateZoom" type="button" class="btn btn-sm btn-outline-success"
                                    data-btn_class="btn btn-base btn-md">
                                    <i class="las la-check-square"></i> <?php echo app('translator')->get('Accept'); ?>
                                </button>
                                <script>
                                       function checkZoomTokenCookie() {
                                            const interval = setInterval(() => {
                                                console.log('Checking zoom_token_updated...');
                                                var value = localStorage.getItem('zoom_token_updated');
                                                
                                                if (value) {
                                                    console.log('zoom_token_updated:', value);
                                                    const date = new Date(value);
                                                    if (!isNaN(date.getTime()) && date > new Date()) {  
                                                        document.getElementById('confirmButton').click();
                                                        clearInterval(interval); 
                                                    }
                                                }
                                            }, 2000);
                                        }

                                        // Helper to read cookie by name
                                        function getCookie(name) {
                                            const match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
                                            return match ? decodeURIComponent(match[2]) : null;
                                        }
                                    document.getElementById('generateZoom').addEventListener('click', function() {
                                        const tokenExpire = localStorage.getItem('zoom_token_updated');
                                                
                                        if (tokenExpire) {
                                            const date = new Date(tokenExpire);
                                            if (!isNaN(date.getTime()) && date > new Date()) {  
                                                document.getElementById('confirmButton').click();
                                                return;
                                            }
                                        }

                                        var url = "/zoom/authorize";
                                        var win = window.open(url, '_blank');
                                        // we check if the window was blocked
                                        if (win) {
                                            checkZoomTokenCookie();
                                            win.focus();
                                        } else {
                                            // the window was blocked
                                            alert('Please allow popups for this website');
                                        }

                                     

                                        // Start checking
                                        


                                    });
                                </script>
                                <button id="confirmButton" type="button"
                                    class="btn btn-sm btn-outline-success d-none confirmationBtn"
                                    data-action="<?php echo e(route('influencer.service.order.accept.status', $order->id)); ?>"
                                    data-question="<?php echo app('translator')->get('Are you sure to accept this order request?'); ?>" data-btn_class="btn btn-base btn-md">
                                    <i class="las la-check-square"></i> <?php echo app('translator')->get('Accept'); ?>
                                </button>
                            <?php endif; ?>

                            <?php if($order->status == 2): ?>
                                <button type="button" class="btn btn-sm btn-outline-primary confirmationBtn"
                                    data-action="<?php echo e(route('influencer.service.order.jobDone.status', $order->id)); ?>"
                                    data-question="<?php echo app('translator')->get('Are you sure that the job is done successfully?'); ?>" data-btn_class="btn btn-base btn-md">
                                    <i class="las la-check-square"></i> <?php echo app('translator')->get('Job Done'); ?>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="col-md-7">
            <div class="card custom--card">
                <div class="card-header">
                    <h5 class="title"><?php echo app('translator')->get('Order Information'); ?></h5>
                </div>
                <div class="card-body p-3">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Title'); ?></span>
                            <span><?php echo e($order->title); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Delivery Date'); ?></span>
                            <span><?php echo e($order->delivery_date); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Amount'); ?></span>
                            <span><?php echo e(showAmount($order->amount)); ?> <?php echo e($general->cur_text); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Order No'); ?></span>
                            <span><?php echo e($order->order_no); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Order Status'); ?></span>
                            <span> <?php echo $order->statusBadge ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold"><?php echo app('translator')->get('Description'); ?></span>
                            <button class="btn btn--sm btn--outline-base descriptionBtn"
                                data-description="<?php echo e($order->description); ?>"><i class="las la-eye"></i>
                                <?php echo app('translator')->get('view'); ?></button>
                        </li>
                        <?php if($order->status == 4): ?>
                            <li class="list-group-item d-flex justify-content-between flex-wrap">
                                <span class="fw-bold"><?php echo app('translator')->get('Reason of Report'); ?></span>
                                <button class="btn btn--sm btn--outline-dark reasonBtn"
                                    data-reason="<?php echo e($order->reason); ?>"><i class="las la-gavel"></i>
                                    <?php echo app('translator')->get('view'); ?></button>
                            </li>
                        <?php endif; ?>
                    </ul>

                </div>
            </div>
            <?php if(@$order->review): ?>
                <div class="card custom--card mt-4">
                    <div class="card-header">
                        <h5 class="title"><?php echo app('translator')->get('Review'); ?></h5>
                    </div>
                    <div class="card-body p-3">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex justify-content-between flex-wrap">
                                <span class="fw-bold"><?php echo app('translator')->get('Rating'); ?></span>
                                <span class="service-rating text--warning">
                                    <?php
                                        echo showRatings(@$order->review->star);
                                    ?>
                                </span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between flex-wrap">
                                <span class="fw-bold"><?php echo app('translator')->get('Review'); ?></span>
                                <span><?php echo e(__(@$order->review->review)); ?></span>
                            </li>
                        </ul>

                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <div id="descriptionModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <p class="description"></p>
                </div>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ConfirmationModal::class, [] + (isset($attributes) ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.descriptionBtn').on('click', function() {
                var modal = $("#descriptionModal");
                modal.find('.modal-title').text('Description');
                modal.find('.description').html($(this).data('description'));
                modal.modal('show');
            });
            $('.reasonBtn').on('click', function() {
                var modal = $("#descriptionModal");
                modal.find('.modal-title').text('Reason of Report')
                modal.find('.description').text($(this).data('reason'));
                modal.modal('show');
            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nibiruit/public_html/infu.nibiru-it.ro/core/resources/views/templates/basic/influencer/order/detail.blade.php ENDPATH**/ ?>