<?php

use App\Lib\Router;
use App\Http\Controllers\ZoomController;
use App\Http\Controllers\Influencer\Auth\LoginController as InfluencerLoginController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\GoogleMeetController;


Route::get('/clear', function () {
    \Illuminate\Support\Facades\Artisan::call('optimize:clear');
});
Route::get('/zoom/authorize', [GoogleMeetController::class, 'authorizeGoogle'])
    ->name('zoom.authorize');
Route::get('/zoom/callback', [GoogleMeetController::class, 'handleGoogleCallback'])
    ->name('zoom.callback');
Route::get('/zoom/create-meeting', [GoogleMeetController::class, 'createMeeting'])
    ->name('zoom.create.meeting');



Route::get('/google/authorize', [GoogleMeetController::class, 'authorizeGoogle'])->name('google.authorize');
Route::get('/google/callback', [GoogleMeetController::class, 'handleGoogleCallback'])->name('google.callback');
Route::get('/google/meeting/create', [GoogleMeetController::class, 'createMeeting'])->name('google.meeting.create');
// we make


// User Support Ticket
Route::controller('TicketController')->prefix('ticket')->group(function () {
    Route::get('/', 'supportTicket')->name('ticket');
    Route::get('2/', 'supportTicket2')->name('ticket2');
    Route::get('/new', 'openSupportTicket')->name('ticket.open');
    Route::get('/new2', 'openSupportTicket2')->name('ticket.open2');
    Route::post('/create', 'storeSupportTicket')->name('ticket.store');
    Route::get('/view/{ticket}', 'viewTicket')->name('ticket.view');
    Route::get('/view/{ticket}', 'viewTicket2')->name('ticket.view2');
    Route::post('/reply/{ticket}', 'replyTicket')->name('ticket.reply');
    Route::post('/close/{ticket}', 'closeTicket')->name('ticket.close');
    Route::get('/download/{ticket}', 'ticketDownload')->name('ticket.download');
});



Route::get('app/deposit/confirm/{hash}', 'Gateway\PaymentController@appDepositConfirm')->name('deposit.app.confirm');


Route::controller('SiteController')->group(function () {
    Route::get('/contact', 'contact')->name('contact');
    Route::get('/about', 'about')->name('about');
    Route::post('/contact', 'contactSubmit');
    Route::get('/login', 'login')->name('login');
    Route::get('/change/{lang?}', 'changeLanguage')->name('lang');

    Route::get('cookie-policy', 'cookiePolicy')->name('cookie.policy');
    Route::get('/cookie/accept', 'cookieAccept')->name('cookie.accept');

    // Route::get('/services2', 'services')->name('services2');
    Route::get('service/tags/{id}/{name}', 'serviceByTag')->name('service.tag');

    Route::get('service/filtered', 'filterService')->name('service.filter');
    Route::get('service/{slug}/{id}/{order_id?}', 'serviceDetails')->name('service.details2');

    Route::get('influencers', 'influencers')->name('influencers');
    Route::get('influencers/category/{id}/{name}', 'influencerByCategory')->name('influencer.category');
    Route::get('influencer/filtered', 'filterInfluencer')->name('influencer.filter');

    Route::get('/influencer/profile/{name}/{id}', 'influencerProfile2')->name('influencer.profile');

    Route::get('policy/{slug}/{id}', 'policyPages')->name('policy.pages');

    Route::get('placeholder-image/{size}', 'placeholderImage')->name('placeholder.image');
    Route::get('attachment/download/{attachment}/{conversation_id}/{type?}', 'attachmentDownload')->name('attachment.download');
    Route::get('/', 'index2')->name('home');
    Route::get('/services', 'services2')->name('services');
    Route::get('service/{slug}/{id}/{order_id?}', 'serviceDetails2')->name('service.details');

    Route::get('/{slug}', 'pages')->name('pages');
    Route::get('/home2', 'index')->name('home2');
});


// become an influencer and switch to influencer routes
Route::controller('App\Http\Controllers\Influencer\Auth\LoginController')->group(function () {
    // Route::get('/influencer/become', 'becomeInfluencer')->name('influencer.become');
    Route::get('/influencer/become', 'becomeInfluencerSubmit')->name('influencer.become');
    Route::get('/influencer/switch', 'switchAccount')->name('influencer.switch');
});



