@extends($activeTemplate . 'layouts.dashboard')
@section('content')
    <div class="wrapper">
        <div class="preloader"></div>
        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    @include($activeTemplate . 'user.sidebar')
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <div class="row pb40">
                            {{-- <div class="col-lg-12">
                <div class="dashboard_navigationbar d-block d-lg-none">
                  <div class="dropdown">
                    <button onclick="myFunction()" class="dropbtn"><i class="fa fa-bars pr10"></i> Dashboard Navigation</button>
                    <ul id="myDropdown" class="dropdown-content">
                      <li><p class="fz15 fw400 ff-heading mt30 pl30">Start</p></li>
                      <li class="active"><a href="page-dashboard.html"><i class="flaticon-home mr10"></i>Dashboard</a></li>
                      <li><a href="page-dashboard-proposal.html"><i class="flaticon-document mr10"></i>My Proposals</a></li>
                      <li><a href="page-dashboard-save.html"><i class="flaticon-like mr10"></i>Saved</a></li>
                      <li><a href="page-dashboard-message.html"><i class="flaticon-chat mr10"></i>Message</a></li>
                      <li><a href="page-dashboard-reviews.html"><i class="flaticon-review-1 mr10"></i>Reviews</a></li>
                      <li><a href="page-dashboard-invoice.html"><i class="flaticon-receipt mr10"></i>Invoice</a></li>
                      <li><a href="page-dashboard-payouts.html"><i class="flaticon-dollar mr10"></i>Payouts</a></li>
                      <li><a href="page-dashboard-statement.html"><i class="flaticon-web mr10"></i>Statements</a></li>
                      <li><p class="fz15 fw400 ff-heading mt30 pl30">Organize and Manage</p></li>
                      <li><a href="page-dashboard-manage-service.html"><i class="flaticon-presentation mr10"></i>Manage Services</a></li>
                      <li><a href="page-dashboard-manage-jobs.html"><i class="flaticon-briefcase mr10"></i>Manage Jobs</a></li>
                      <li><a href="page-dashboard-manage-project.html"><i class="flaticon-content mr10"></i>Manage Project</a></li>
                      <li><p class="fz15 fw400 ff-heading mt30 pl30">Account</p></li>
                      <li><a href="page-dashboard-profile.html"><i class="flaticon-photo mr10"></i>My Profile</a></li>
                      <li><a href="page-login.html"><i class="flaticon-logout mr10"></i>Logout</a></li>
                    </ul>
                  </div>
                </div>
              </div> --}}
                            {{-- <div class="col-lg-12">
                                <div class="dashboard_title_area">
                                    <h2>Panou Principal</h2>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6 col-xxl-4">
                                <div class="d-flex align-items-center justify-content-between statistics_funfact">
                                    <div class="details">
                                        <div class="fz15">Programări</div>
                                        <div class="title">{{ $data['total_order'] }}</div>
                                        <div class="text fz14"><span class="text-thm">10</span> Programări Noi</div>
                                    </div>
                                    <div class="icon text-center"><i class="flaticon-contract"></i></div>
                                </div>
                            </div> --}}
                            {{-- <div class="col-sm-6 col-xxl-3">
                <div class="d-flex align-items-center justify-content-between statistics_funfact">
                  <div class="details">
                    <div class="fz15"></div>
                    <div class="title">1292</div>
                    <div class="text fz14"><span class="text-thm">80+</span> New Completed</div>
                  </div>
                  <div class="icon text-center"><i class="flaticon-success"></i></div>
                </div>
              </div> --}}
                            {{-- <div class="col-sm-6 col-xxl-4">
                                <div class="d-flex align-items-center justify-content-between statistics_funfact">
                                    <div class="details">
                                        <div class="fz15">Balanță Actuală</div>
                                        <div class="title">{{ showAmount($data['current_balance']) }}
                                            {{ $general->cur_text }}</div>
                                        <div class="text fz14"><span class="text-thm">35+</span> New Queue</div>
                                    </div>
                                    <div class="icon text-center"><i class="flaticon-review"></i></div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xxl-4">
                                <div class="d-flex align-items-center justify-content-between statistics_funfact">
                                    <div class="details">
                                        <div class="fz15">Recenzii Totale</div>
                                        <div class="title">0</div>
                                        <div class="text fz14"><span class="text-thm">290+</span> New Review</div>
                                    </div>
                                    <div class="icon text-center"><i class="flaticon-review-1"></i></div>
                                </div>
                            </div>
                        </div> --}}
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                        <div class="show-filter mb-3 text-end">
                                            <button type="button" class="sidebar_list_item showFilterBtn btn-sm"><i
                                                    class="las la-filter"></i>
                                                @lang('Filtrează')</button>
                                        </div>
                                        <div class="card custom--card responsive-filter-card mb-4">
                                            <div class="card-body">
                                                <form action="">
                                                    <div class="d-flex flex-wrap gap-4">
                                                        <div class="flex-grow-1">
                                                            <label>@lang('Număr Tranzacție')</label>
                                                            <input type="text" name="search"
                                                                value="{{ request()->search }}"
                                                                class="form-control form--control">
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <label>@lang('Tip')</label>
                                                            <select name="type"
                                                                class="form-control form--control form-select">
                                                                <option value="">@lang('Toate')</option>
                                                                <option value="+" @selected(request()->type == '+')>
                                                                    @lang('Adăugare')</option>
                                                                <option value="-" @selected(request()->type == '-')>
                                                                    @lang('Retragere')</option>
                                                            </select>
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <label>@lang('Remarcă')</label>
                                                            <select class="form-control form--control form-select"
                                                                name="remark">
                                                                <option value="">@lang('Orice')</option>
                                                                @foreach ($remarks as $remark)
                                                                    <option value="{{ $remark->remark }}"
                                                                        @selected(request()->remark == $remark->remark)>
                                                                        {{ __(keyToTitle($remark->remark)) }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="flex-grow-1 align-self-end">
                                                            <button class="form--control btn btn--base w-100 text-light"><i
                                                                    class="las la-filter"></i>
                                                                @lang('Filter')</button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <div class="packages_table table-responsive">
                                            <table class="table-style3 table at-savesearch">
                                                <thead class="thead">
                                                    <tr>
                                                        <th>@lang('ID')</th>
                                                        <th>@lang('Tranzacționat')</th>
                                                        <th>@lang('Sumă')</th>
                                                        <th>@lang('Balanță Ulterior')</th>
                                                        <th>@lang('Detalii')</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($transactions as $trx)
                                                        <tr>
                                                            <td data-label="@lang('Trx')">
                                                                <strong>{{ $trx->trx }}</strong>
                                                            </td>

                                                            <td data-label="@lang('Transactionat')">
                                                                {{ showDateTime($trx->created_at) }}<br>{{ diffForHumans($trx->created_at) }}
                                                            </td>

                                                            <td data-label="@lang('Suma')" class="budget">
                                                                <span
                                                                    class="fw-bold @if ($trx->trx_type == '+') text--success @else text--danger @endif">
                                                                    {{ $trx->trx_type }} {{ showAmount($trx->amount) }}
                                                                    {{ $general->cur_text }}
                                                                </span>
                                                            </td>

                                                            <td data-label="@lang('Suma Initiala')" class="budget">
                                                                {{ showAmount($trx->post_balance) }}
                                                                {{ __($general->cur_text) }}
                                                            </td>

                                                            <td data-label="@lang('Detalii')">
                                                                {{ __($trx->details) }}
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td class="justify-content-center text-center" colspan="100%">
                                                                <i class="la la-4x la-frown"></i>
                                                                <br>
                                                                {{ __($emptyMessage) }}
                                                            </td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                            <canvas id="myChartweave" style="height:230px;"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <footer class="dashboard_footer pt30 pb30">
                        <div class="container">
                            <div class="row align-items-center justify-content-center justify-content-md-between">
                                {{-- <div class="col-auto">
                  <div class="copyright-widget">
                    <p class="mb-md-0">© Freeio. 2023 CreativeLayers. All rights reserved.</p>
                  </div>
                </div> --}}
                                <div class="col-12">
                                    <div class="footer_bottom_right_btns at-home8 text-center text-lg-end">
                                        <ul class="p-0 m-0">
                                            <li class="list-inline-item bg-white">
                                                <select class="selectpicker show-tick">
                                                    <option>US$ USD</option>
                                                    <option>Euro</option>
                                                    <option>Pound</option>
                                                </select>
                                            </li>
                                            <li class="list-inline-item bg-white">
                                                <select class="selectpicker show-tick">
                                                    <option>English</option>
                                                    <option>Frenc</option>
                                                    <option>Italian</option>
                                                    <option>Spanish</option>
                                                    <option>Turkey</option>
                                                </select>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </footer>
                </div>
            </div>
        </div>
        <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
    </div>
@endsection
