@extends($activeTemplate . 'layouts.dashboard')
@section('content')
<div class="wrapper">
    <div class="preloader"></div>

    <div class="dashboard_content_wrapper">
        <div class="dashboard dashboard_wrapper pr30 pr0-xl">
            <div class="dashboard__sidebar d-none d-lg-block">
                @include($activeTemplate . 'user.sidebar')
            </div>
            <div class="dashboard__main pl0-md">
                <div class="dashboard__content hover-bgc-color">
                    <div class="row pb40">
                        <div class="col-lg-6">
                            <div class="dashboard_title_area">
                                <h2>@lang('Crează Tichet Nou')</h2>
                            </div>
                        </div>
                        <div class="col-lg-6 d-flex justify-content-end">
                            <a href="{{ route('influencer.ticket') }}"
                                    class="table-action fz15 fw500 text-thm2">@lang('Tichete Deschise')</a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                <div class="col-lg-12">
                                    <form class="form-style1" action="{{ route('influencer.ticket.store') }}"
                                        method="post" enctype="multipart/form-data">
                                        @csrf
                                        <input type="hidden" name="name" value="{{ @$user->fullname }}">
                                        <input type="hidden" name="email" value="{{ @$user->email }}">

                                        <div class="row justify-content-between">
                                            <div class="col-lg-12 mb10">
                                                <div class="form-group">
                                                    <label for="subject" class="form-label">@lang('Subiect')</label>
                                                    <input type="text" id="subject" name="subject"
                                                        value="{{ old('subject') }}" class="form-control form--control"
                                                        required>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb10">
                                                <div class="form-group">
                                                    <label class="form-label">@lang('Prioritate')</label>
                                                    <select name="priority"
                                                        class="form-control form--control form-select" required>
                                                        <option value="1">@lang('Low')</option>
                                                        <option value="2">@lang('Medium')</option>
                                                        <option value="3">@lang('High')</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb10">
                                                <div class="form-group">
                                                    <label for="message" class="form-label">@lang('Message')</label>
                                                    <textarea id="message" name="message" class="form-control form--control" required>{{ old('message') }}</textarea>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb10">
                                                <div class="form-group">
                                                    <label class="form-label">@lang('Attachments')</label>
                                                    <div class="form-group d-flex gap-2">
                                                        <input type="file" class="form-control form--control"
                                                            name="attachments[]" id="file2">
                                                        <button class="btn btn--base addFile border-0" type="button">
                                                            <i class="las la-plus"></i>
                                                        </button>
                                                    </div>
                                                    <div id="more-attachment"></div>
                                                    <span class="info fs-sm">
                                                        @lang('Allowed File Extensions'): .@lang('jpg'),
                                                        .@lang('jpeg'), .@lang('png'),
                                                        .@lang('pdf'), .@lang('doc'),
                                                        .@lang('docx')
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb10">
                                                <button type="submit" class="table-action w-100">
                                                    <i class="fa fa-reply"></i> @lang('Trimite')
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            </footer>
                        </div>
                    </div>
                </div>
                <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
    <style>
        .input-group-text:focus {
            box-shadow: none !important;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addFile').on('click', function() {
                if (fileAdded >= 4) {
                    notify('error', 'You\'ve added maximum number of file');
                    return false;
                }
                fileAdded++;
                $("#more-attachment").append(`
                    <div class="form-group d-flex gap-2 mt-3">
                        <input type="file" class="form-control form--control " name="attachments[]" id="file2">
                        <button class="btn btn--danger border-0 remove-btn" type="button"><i class="las la-times"></i></button>
                    </div>
                `)
            });
            $(document).on('click', '.remove-btn', function() {
                fileAdded--;
                $(this).closest('.form-group').remove();
            });
        })(jQuery);
    </script>
@endpush
