@extends($activeTemplate . 'layouts.dashboard')
@section('content')
    <div class="wrapper">
        <div class="preloader"></div>
        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    @include($activeTemplate . 'user.sidebar')
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <div class="row pb40">

                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                        <form action="{{ route('user.review.influencer.add', $hiring->id) }}" method="POST"
                                            class="row review-form rating gy-2">
                                          @csrf
                                          <div class="form-group col-md-6">
                                              <label class="form-label text-dark" for="description">@lang('Influencer Name')</label>
                                              <input type="text" class="form-control form--control" value="{{ __(@$hiring->influencer->fullname) }}"
                                                     readonly required>
                                          </div>
                                          <div class="form-group col-md-6">
                                              <label class="form-label text-dark" for="description">@lang('Email')</label>
                                              <input type="text" class="form-control form--control" value="{{ __(@$hiring->influencer->email) }}"
                                                     readonly required>
                                          </div>
                                          <div class="form-group col-md-6 d-flex mt-3 flex-wrap">
                                              <label class="form-label text-dark me-5">@lang('Rating')<span class="text--danger">*</span></label>
                                              <div class="rating-form-group">
                                                  <label class="star-label">
                                                      <input type="radio" name="star" value="1" @if(@$hiring->review) {{ $hiring->review->star == 1 ? 'checked': '' }} @endif/>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                  </label>
                                                  <label class="star-label">
                                                      <input type="radio" name="star" value="2" @if(@$hiring->review) {{ $hiring->review->star == 2 ? 'checked': '' }} @endif/>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                  </label>
                                                  <label class="star-label">
                                                      <input type="radio" name="star" value="3" @if(@$hiring->review) {{ $hiring->review->star == 3 ? 'checked': '' }} @endif/>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                  </label>
                                                  <label class="star-label">
                                                      <input type="radio" name="star" value="4" @if(@$hiring->review) {{ $hiring->review->star == 4 ? 'checked': '' }} @endif/>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                  </label>
                                                  <label class="star-label">
                                                      <input type="radio" name="star" value="5" @if(@$hiring->review) {{ $hiring->review->star == 5 ? 'checked': '' }} @endif/>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                      <span class="icon"><i class="las la-star"></i></span>
                                                  </label>
                                              </div>
                                          </div>
                                          <div class="form-group col-12 d-flex flex-wrap">
                                              <label class="form-label text-dark" for="review-comments">@lang('Review')</label>
                                              <textarea name="review" class="form-control form--control" id="review-comments"
                                                        placeholder="@lang('Write here')..." required>@if(@$hiring->review) {{ @$hiring->review->review }} @else {{ old('review') }} @endif</textarea>
                                          </div>
                                          <div class="col-lg-12 mt-3">
                                              <button type="submit" class="btn btn--base w-100">@lang('Trimite')</button>
                                          </div>
                                      </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <footer class="dashboard_footer pt30 pb30">
                            <div class="container">
                                <div class="row align-items-center justify-content-center justify-content-md-between">
                                    {{-- <div class="col-auto">
                  <div class="copyright-widget">
                    <p class="mb-md-0">© Freeio. 2023 CreativeLayers. All rights reserved.</p>
                  </div>
                </div> --}}
                                    <div class="col-12">
                                        <div class="footer_bottom_right_btns at-home8 text-center text-lg-end">
                                            <ul class="p-0 m-0">
                                                <li class="list-inline-item bg-white">
                                                    <select class="selectpicker show-tick">
                                                        <option>US$ USD</option>
                                                        <option>Euro</option>
                                                        <option>Pound</option>
                                                    </select>
                                                </li>
                                                <li class="list-inline-item bg-white">
                                                    <select class="selectpicker show-tick">
                                                        <option>English</option>
                                                        <option>Frenc</option>
                                                        <option>Italian</option>
                                                        <option>Spanish</option>
                                                        <option>Turkey</option>
                                                    </select>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>
                    </div>
                </div>
            </div>
            <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
        </div>
    </div>
@endsection
