@extends($activeTemplate . 'layouts.dashboard')
@section('content')
    <div class="wrapper">
        <div class="preloader"></div>
        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    @include($activeTemplate . 'user.sidebar')
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <div class="row pb40">
                            <div class="col-lg-12">
                                <div class="dashboard_title_area">
                                    <h2>Adauga Fonduri</h2>
                                    {{-- <p class="text">Lorem ipsum dolor sit amet, consectetur.</p> --}}
                                </div>
                            </div>
                            {{-- <div class="col-lg-3">
                                <div class="text-lg-end">
                                    <a href="{{ route('influencer.service.create') }}"
                                        class="ud-btn btn-dark default-box-shadow2">Adaugă Serviciu<i
                                            class="fal fa-arrow-right-long"></i></a>
                                </div>
                            </div> --}}
                        </div>
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                    <div class="card-body">
                                        <form action="{{ route('user.deposit.insert') }}" method="post"
                                            class="from row gy-2">
                                            @csrf
                                            <input type="hidden" name="method_code">
                                            <input type="hidden" name="currency">
                                            <div class="form-group">
                                                <label class="form-label">@lang('Selectează metoda de depunere')</label>
                                                <select class="form-control form--control form-select" name="gateway"
                                                    required>
                                                    <option value="">@lang('Selectează metoda de depunere')</option>
                                                    @foreach ($gatewayCurrency as $data)
                                                        <option value="{{ $data->method_code }}"
                                                            @selected(old('gateway') == $data->method_code) selected data-gateway="{{ $data }}">
                                                            {{ $data->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label">@lang('Suma')</label>
                                                <div class="input-group">
                                                    <input type="number" step="any" name="amount"
                                                        value="{{ old('amount', @$amount) }}" @isset($amount) readonly @endisset class="form-control form--control"
                                                        required>
                                                    <span class="input-group-text">{{ $general->cur_text }}</span>
                                                </div>
                                            </div>
                                            
                                            <div class="preview-details d-none my-3">
                                                <ul class="list-group-flush text-center">
                                                    <li class="list-group-item d-flex justify-content-between">
                                                        <span>@lang('Limită')</span>
                                                        <span><span class="min fw-bold">0</span>
                                                            {{ __($general->cur_text) }} - <span
                                                                class="max fw-bold">0</span>
                                                            {{ __($general->cur_text) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between">
                                                        <span>@lang('Comision')</span>
                                                        <span><span class="charge fw-bold">0</span>
                                                            {{ __($general->cur_text) }}</span>
                                                    </li>
                                                    <li class="list-group-item d-flex justify-content-between">
                                                        <span>@lang('Suma depusă')</span> <span><span
                                                                class="receivable fw-bold"> 0</span>
                                                            {{ __($general->cur_text) }} </span>
                                                    </li>
                                                    <li class="list-group-item d-none justify-content-between rate-element">

                                                    </li>
                                                    <li class="list-group-item justify-content-between d-none in-site-cur">
                                                        <span>@lang('Total in') <span class="base-currency"></span></span>
                                                        <span class="final_amo fw-bold">0</span>
                                                    </li>
                                                    <li class="list-group-item d-none justify-content-between in-site-cur">
                                                        <span>@lang('Conversion with') <span class="method_currency"></span> @lang('and final value will Show on next step')</span>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div
                                                style="align-items: center; display: flex; justify-content: space-between; flex-direction: column; margin-top: 20px;">
                                                <button type="submit"
                                                    class="ud-btn btn-dark default-box-shadow2 w100">@lang('Depune')</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    </footer>
                </div>
            </div>
        </div>
        <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";
            $('select[name=gateway]').change(function() {
                if (!$('select[name=gateway]').val()) {
                    $('.preview-details').addClass('d-none');
                    return false;
                }
                var resource = $('select[name=gateway] option:selected').data('gateway');
                var fixed_charge = parseFloat(resource.fixed_charge);
                var percent_charge = parseFloat(resource.percent_charge);
                var rate = parseFloat(resource.rate)
                if (resource.method.crypto == 1) {
                    var toFixedDigit = 8;
                    $('.crypto_currency').removeClass('d-none');
                } else {
                    var toFixedDigit = 2;
                    $('.crypto_currency').addClass('d-none');
                }
                $('.min').text(parseFloat(resource.min_amount).toFixed(2));
                $('.max').text(parseFloat(resource.max_amount).toFixed(2));
                var amount = parseFloat($('input[name=amount]').val());
                if (!amount) {
                    amount = 0;
                }
                if (amount <= 0) {
                    $('.preview-details').addClass('d-none');
                    return false;
                }
                $('.preview-details').removeClass('d-none');
                var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
                $('.charge').text(charge);
                var payable = parseFloat((parseFloat(amount) + parseFloat(charge))).toFixed(2);
                $('.payable').text(payable);
                var final_amo = (parseFloat((parseFloat(amount) + parseFloat(charge))) * rate).toFixed(
                    toFixedDigit);
                $('.final_amo').text(final_amo);
                if (resource.currency != '{{ $general->cur_text }}') {
                    var rateElement =
                        `<span>@lang('Conversion Rate')</span> <span><span  class="fw-bold">1 {{ __($general->cur_text) }} = <span class="rate">${rate}</span>  <span class="base-currency">${resource.currency}</span></span></span>`;
                    $('.rate-element').html(rateElement)
                    $('.rate-element').removeClass('d-none');
                    $('.in-site-cur').removeClass('d-none');
                    $('.rate-element').addClass('d-flex');
                    $('.in-site-cur').addClass('d-flex');
                } else {
                    $('.rate-element').html('')
                    $('.rate-element').addClass('d-none');
                    $('.in-site-cur').addClass('d-none');
                    $('.rate-element').removeClass('d-flex');
                    $('.in-site-cur').removeClass('d-flex');
                }
                $('.base-currency').text(resource.currency);
                $('.method_currency').text(resource.currency);
                $('input[name=currency]').val(resource.currency);
                $('input[name=method_code]').val(resource.method_code);
                $('input[name=amount]').on('input');
            });
            $('input[name=amount]').on('input', function() {
                $('select[name=gateway]').change();
                $('.amount').text(parseFloat($(this).val()).toFixed(2));
            });
        })(jQuery);


        // on load we will trigger the change event
        // to show the default selected gateway
        $(document).ready(function() {
            $('select[name=gateway]').change();
        });
    </script>
@endpush