@extends($activeTemplate . 'layouts.dashboard')
@section('content')
    <div class="wrapper">
        <div class="preloader"></div>
        <div class="dashboard_content_wrapper">
            <div class="dashboard dashboard_wrapper pr30 pr0-xl">
                <div class="dashboard__sidebar d-none d-lg-block">
                    @include($activeTemplate . 'user.sidebar')
                </div>
                <div class="dashboard__main pl0-md">
                    <div class="dashboard__content hover-bgc-color">
                        <div class="row pb40">

                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="ps-widget bgc-white bdrs4 p30 mb30 overflow-hidden position-relative">
                                        <div class="packages_table table-responsive">
                                            <table class="table-style3 table at-savesearch">
                                                <thead class="thead">
                                                    <tr>
                                                        <th>@lang('Numar Programare')</th>
                                                        <th>@lang('Nume Mentor')</th>
                                                        <th>@lang('Suma')</th>
                                                        <th>@lang('Status')</th>
                                                        <th>@lang('Link Zoom')</th>
                                                        <th>@lang('Actiuni')</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($orders as $order)
                                                        <tr>
                                                            <td data-label="@lang('Numar Programare')">
                                                                <span>{{ $order->order_no }}</span>
                                                            </td>
                                                            <td data-label="@lang('Nume Mentor')">
                                                                <span class="fw-bold"><a
                                                                        href="{{ route('influencer.profile', [slug($order->influencer->username), $order->influencer_id]) }}"
                                                                        class="text--base">{{ __(@$order->influencer->username) }}</span>
                                                            </td>
                                                            <td data-label="@lang('Suma')" class="text-center">
                                                                <div>
                                                                    <span
                                                                        class="fw-bold">{{ __($general->cur_sym) }}{{ showAmount($order->amount) }}</span>
                                                                    <br>
                                                                    {{ $order->delivery_date }}
                                                                </div>
                                                            </td>
                                                            <td data-label="@lang('Status')">
                                                                @php echo $order->statusBadge @endphp
                                                            </td>
                                                            <td data-label="@lang('Zoom Meet')" class="text-center">
                                                                @if ($order->zoom_link )
                                                                <a href="{{ $order->zoom_link }}" target="_blank" class="btn btn-sm btn-outline-success">
                                                                    <i class="las la-video"></i> @lang('Join')
                                                                </a>
                                                                </br>
                                                                Password:<br>
                                                                <span class="badge bg-success">{{ $order->password ?? '' }}</span>
                                                                @else
                                                                <span class="badge bg-warning">@lang('Not Available')</span>
                                                                @endif
                                                            </td>

                                                            <td data-label="@lang('Actiuni')">
                                                                <div class="d-flex flex-wrap gap-1 justify-content-end">
                                                                    @if ($order->status == 1)
                                                                        @if ($order->review)
                                                                            <a href="{{ route('user.review.service', $order->id) }}"
                                                                                class="btn btn--sm btn--outline-warning">
                                                                                <i class="las la-star"></i>
                                                                                @lang('Review')
                                                                            </a>
                                                                        @else
                                                                            <a href="{{ route('service.details', [slug(@$order->service->title), $order->service_id, $order->id]) }}"
                                                                                class="btn btn--sm btn--outline-warning">
                                                                                <i class="las la-star"></i>
                                                                                @lang('Review')
                                                                            </a>
                                                                        @endif
                                                                    @else
                                                                        <span class="d-inline-block" tabindex="0"
                                                                            data-bs-toggle="tooltip" data-placement="top"
                                                                            title="@lang('You can review it after the order is completed.')">
                                                                            <button type="button"
                                                                                class="btn btn--sm btn--outline-warning disabled"><i
                                                                                    class="las la-star"></i>
                                                                                @lang('Review')</button>
                                                                        </span>
                                                                    @endif
                                                                    <a href="{{ route('user.order.detail', $order->id) }}"
                                                                        class="btn btn--sm btn--outline-base">
                                                                        <i class="la la-desktop"></i> @lang('Detail')
                                                                    </a>
                                                                    <a href="{{ route('user.order.conversation.view', $order->id) }}"
                                                                        class="btn btn--sm btn--outline-info">
                                                                        <i class="las la-sms"></i> @lang('Chat')
                                                                    </a>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td class="justify-content-center text-center" colspan="100%">
                                                                <i class="la la-4x la-frown"></i>
                                                                <br>
                                                                {{ __($emptyMessage) }}
                                                            </td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                            {{ $orders->links() }}
                                            <canvas id="myChartweave" style="height:230px;"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <footer class="dashboard_footer pt30 pb30">
                            <div class="container">
                                <div class="row align-items-center justify-content-center justify-content-md-between">
                                    {{-- <div class="col-auto">
                  <div class="copyright-widget">
                    <p class="mb-md-0">© Freeio. 2023 CreativeLayers. All rights reserved.</p>
                  </div>
                </div> --}}
                                    <div class="col-12">
                                        <div class="footer_bottom_right_btns at-home8 text-center text-lg-end">
                                            <ul class="p-0 m-0">
                                                <li class="list-inline-item bg-white">
                                                    <select class="selectpicker show-tick">
                                                        <option>US$ USD</option>
                                                        <option>Euro</option>
                                                        <option>Pound</option>
                                                    </select>
                                                </li>
                                                <li class="list-inline-item bg-white">
                                                    <select class="selectpicker show-tick">
                                                        <option>English</option>
                                                        <option>Frenc</option>
                                                        <option>Italian</option>
                                                        <option>Spanish</option>
                                                        <option>Turkey</option>
                                                    </select>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>
                    </div>
                </div>
            </div>
            <a class="scrollToHome" href="#"><i class="fas fa-angle-up"></i></a>
        </div>
    </div>
@endsection
